#! /bin/sh

# Test update of a record.

TMP_DIR="${TMPDIR}"

test -z "${BIN_DIR}" && BIN_DIR=website/cgi-bin

SCRIPT_BASE=`basename $0 | sed "s/_[0-9]*\.sh$//"`

BASENAME=$(basename $0 .pl)

#BEGIN DEPEND------------------------------------------------------------------

INPUT_SCRIPT="${BIN_DIR}/${SCRIPT_BASE}"

#END DEPEND--------------------------------------------------------------------

set -ue
## set -x

test -z "${TMP_DIR}" && TMP_DIR="/tmp"
TMP_DIR="${TMP_DIR}/tmp-${BASENAME}-$$"
mkdir "${TMP_DIR}"

# To make the trap portable between bash and dash, we need to trap
# "signal" 0 ("EXIT") and rely on it for the cleanup:
## trap "rm -rf '${TMP_DIR}'" 0 1 2 3 15
trap "rm -rf '${TMP_DIR}'" EXIT
trap "exit 1" HUP INT QUIT TERM

# Set up the testing "sandbox":
SRC_DB_DIR=db
TMP_DB_DIR=${TMP_DIR}/db
mkdir ${TMP_DB_DIR}

SRC_DB_FILE=${SRC_DB_DIR}/test4fk.db

TMP_TEST_DB=$(basename ${SRC_DB_FILE})
TMP_DB_FILE=${TMP_DB_DIR}/${TMP_TEST_DB}
TMP_DB_BASE=$(basename ${TMP_DB_FILE})
TMP_DB_META=${TMP_DB_DIR}/restful.db
TMP_DB_FILE_ABS=$(cd $(dirname ${TMP_DB_FILE}); pwd)/${TMP_DB_BASE}

cp ${SRC_DB_FILE} ${TMP_DB_FILE}

ln -s $(pwd)/lib ${TMP_DIR}
ln -s $(pwd)/sql ${TMP_DIR}
ln -s $(pwd)/tools ${TMP_DIR}

mkdir -p ${TMP_DIR}/${BIN_DIR}

cp ${INPUT_SCRIPT} ${TMP_DIR}/${BIN_DIR}

# Change dir to the sandbox and run the test:

cd ${TMP_DIR}

sqlite3 ${TMP_DB_FILE} <<EOF
create table experiment_xrd (
   id integer primary key autoincrement,
   uuid char(36) unique,
   sample_id int(11),
   title varchar(255),
   sample_preparation text,
   diffraction_file longblob,
   format varchar(255),
   mimetype varchar(255)
);
EOF

sqlite3 ${TMP_DB_META} < sql/metatables.sql
sqlite3 ${TMP_DB_META} "insert into description (dbname, dbtable, dbcolumn, coltype) values ('${TMP_DB_FILE_ABS}', 'sample', 'id', 'id')"
sqlite3 ${TMP_DB_META} "insert into description (dbname, dbtable, dbcolumn, coltype, fk_target, relation) values ('${TMP_DB_FILE_ABS}', 'experiment', 'sample_id', 'fk', 1, 'N')"
sqlite3 ${TMP_DB_META} "insert into description (dbname, dbtable, dbcolumn, coltype, fk_target, relation) values ('${TMP_DB_FILE_ABS}', 'experiment_xrd', 'sample_id', 'fk', 1, 'N')"

sqlite3 ${TMP_DB_FILE} "insert into experiment (id, sample_id) values (4, 3)"
sqlite3 ${TMP_DB_FILE} "insert into experiment (id, sample_id) values (5, 3)"
sqlite3 ${TMP_DB_FILE} "insert into experiment (id, sample_id) values (6, 3)"
sqlite3 ${TMP_DB_FILE} "insert into experiment (id, sample_id) values (7, 3)"
sqlite3 ${TMP_DB_FILE} "insert into experiment (id, sample_id) values (8, 3)"
sqlite3 ${TMP_DB_FILE} "insert into experiment (id, sample_id) values (9, 3)"
sqlite3 ${TMP_DB_FILE} "insert into experiment (id, sample_id) values (10, 3)"
sqlite3 ${TMP_DB_FILE} "insert into experiment (id, sample_id) values (11, 3)"
sqlite3 ${TMP_DB_FILE} "insert into experiment (id, sample_id) values (12, 3)"
sqlite3 ${TMP_DB_FILE} "insert into experiment (id, sample_id) values (13, 3)"
sqlite3 ${TMP_DB_FILE} "insert into experiment (id, sample_id) values (14, 3)"

sqlite3 ${TMP_DB_FILE} "insert into experiment_xrd (id, sample_id) values (1, 3)"
sqlite3 ${TMP_DB_FILE} "insert into experiment_xrd (id, sample_id) values (2, 3)"
sqlite3 ${TMP_DB_FILE} "insert into experiment_xrd (id, sample_id) values (3, 3)"
sqlite3 ${TMP_DB_FILE} "insert into experiment_xrd (id, sample_id) values (4, 3)"
sqlite3 ${TMP_DB_FILE} "insert into experiment_xrd (id, sample_id) values (5, 3)"
sqlite3 ${TMP_DB_FILE} "insert into experiment_xrd (id, sample_id) values (6, 3)"

export REQUEST_URI="/~saulius/restful/website/${TMP_TEST_DB}/sample/3?format=htmlblock&rows=5&related_table=experiment_xrd"
export HTTP_HOST=restfuldb.domain.net
export REQUEST_METHOD=POST
export CONTENT_TYPE="multipart/form-data; boundary=boundary"
export REMOTE_USER=writer

{
    sqlite3 -nullvalue NULL ${TMP_DB_FILE} 'select * from sample order by id';
    sqlite3 -nullvalue NULL ${TMP_DB_FILE} 'select * from experiment order by id';
    sqlite3 -nullvalue NULL ${TMP_DB_FILE} 'select * from experiment_xrd order by id';
    sqlite3 -nullvalue NULL ${TMP_DB_META} 'select * from description order by id';
} \
| sed "s:$(pwd):/cwd:"

echo "==="

echo Edit=Edit \
| tools/scripts/multipart-form-data boundary \
| tail -n +5 \
| ${INPUT_SCRIPT}

cd - > /dev/null

# Temporary directory will be deleted by the trap.
