struct navier_stokes_dg {
  typedef valarray<field> value_type;
  typedef Float           float_type;
  navier_stokes_dg (Float Re, const geo& omega, string approx);
  value_type initial (string restart) const;
  value_type residue     (const value_type& uh) const;
  void update_derivative (const value_type& uh) const;
  value_type derivative_solve      (const value_type& mrh) const;
  value_type derivative_trans_mult (const value_type& mrh) const;
  Float space_norm       (const value_type& uh) const;
  Float dual_space_norm  (const value_type& mrh) const;
  Float duality_product  (const value_type& mrh, const value_type& msh) const;
  Float Re;
  space Xh, Qh;
  quadrature_option_type qopt;
  form  a0, b, c, mu, mp;
  field lh0, lh, kh;
  solver smu, smp;
  mutable form a1;
  mutable solver_abtb stokes1;
};
#include "navier_stokes_dg1.icc"
#include "navier_stokes_dg2.icc"
