#include "rheolef.h"
#include "rheolef/uzawa_abtb.h"
using namespace rheolef;
using namespace std;

Float g(const point& x) { return 1-x[0]*x[0]; }

int main(int argc, char**argv) {
  geo  omega (argv[1]);
  space X1h (omega, "P1", "vector");
  space Bh  (omega, "bubble", "vector");
  space Qh  (omega, "P1");
  X1h[0].block("left"); X1h.block("right");
  X1h.block("bottom");  X1h[0].block("top");
  space Xh = X1h * Bh;
  field uh (Xh);
  uh[1]["right"]    = 0;
  space W_bottom  (omega, omega["bottom"],  "P1");
  space W_top (omega, omega["top"], "P1");
  uh[1]["bottom"]   = interpolate (W_bottom,  g);
  uh[0]["right"] = uh[0]["left"] = uh[0]["bottom"] = uh[0]["top"] = 0;
  field ph (Qh, 0.);

  form a1 (X1h, X1h, "2D_D");
  form ab (Bh,  Bh,  "2D_D");
  form a0 = form_nul (Bh, X1h);
  form_manip a_manip;
  a_manip << size(2,2)
          << a1        << a0
          << trans(a0) << ab;
  form a (Xh, Xh);
  a_manip >> a;

  form b1 = - form(X1h, Qh, "div");
  form bb = - form(Bh,  Qh, "div");
  form_manip b_manip;
  b_manip << size(1,2)
          << b1 << bb;
  form b (Xh, Qh);
  b_manip >> b;

  int   max_iter  = 500;
  Float tol       = 1e-12;
  Float r         = 1e+7;
  form ar = a + r*trans(b)*b;
  ssk<Float> fact = ldlt(ar.uu);
  uzawa_abtb (ar.uu, fact, b.uu, uh.u, ph.u, -(ar.ub*uh.b), -(b.ub*uh.b), r, max_iter, tol);

  cout << catchmark("u")  << uh
       << catchmark("p")  << ph;

  field pi_h_u (Xh, 0.);
  pi_h_u[1] = interpolate (space(Xh[1]), g);
  Float err = abs (uh-pi_h_u).max();
  cerr << "error = " << err << endl;
  Float tol2 = 1e-7;
  return err < tol2 ? 0 : 1;
}
