///
/// This file is part of Rheolef.
///
/// Copyright (C) 2000-2009 Pierre Saramito <Pierre.Saramito@imag.fr>
///
/// Rheolef is free software; you can redistribute it and/or modify
/// it under the terms of the GNU General Public License as published by
/// the Free Software Foundation; either version 2 of the License, or
/// (at your option) any later version.
///
/// Rheolef is distributed in the hope that it will be useful,
/// but WITHOUT ANY WARRANTY; without even the implied warranty of
/// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
/// GNU General Public License for more details.
///
/// You should have received a copy of the GNU General Public License
/// along with Rheolef; if not, write to the Free Software
/// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
///
/// =========================================================================
//
// geo visualisation main procedure
//
// authors:
//    	Pierre.Saramito@imag.fr
//
// date: 12 may 1997; update 26 january 2006
//
#include "rheolef/georep.h"
#include "rheolef/iorheo.h"
#include "rheolef/iofem.h"
#include "rheolef/rheostream.h" // i/o utility
#include "rheolef/tiny_element.h"
#include "rheolef/geo-visu.h"
#include "geo-connectivity.h"
using namespace std;
namespace rheolef { 
//
// big switch between drivers
//
ostream&
operator << (ostream& s, const georep& g) 
{
  geo_visu_option_type opt (s);
  if (opt.format [iorheo::gnuplot]) {
      if (g._dim == 1)      g.gnuplot1d (opt.basename, opt.execute, opt.clean, opt.verbose);
      else if (g._dim == 2)	g.gnuplot2d (opt.basename, opt.execute, opt.clean, opt.verbose);
      else                  g.gnuplot3d (opt.basename, opt.execute, opt.clean, opt.verbose);
      return s;
  } else if (opt.format [iorheo::plotmtv]) {
      g.plotmtv (opt.basename, opt.execute, opt.clean, opt.verbose);
      return s;
  } else if (opt.format [iorheo::atom]) {
      g.atom (opt.basename, opt.execute, opt.clean, opt.verbose);
      return s;
  } else if (opt.format [iorheo::x3d]) {
      g.x2d (opt.basename, opt.execute, opt.clean, opt.verbose);
      return s;
  } else if (opt.format [iorheo::mayavi]) {
      g.visu_mayavi (opt);
      return s;
  } else if (opt.format [iorheo::vtk]) {
      g.vtk_tcl (opt.basename, opt.execute, opt.clean, opt.verbose, 
  	       opt.fill, opt.shrink, opt.tube, opt.ball, opt.full, opt.cut, opt.split,
	       opt.origin, opt.normal);
      return s;
  } else if (opt.format [iorheo::vtkdata]) {
      return g.put_vtk(s, opt.lattice);
  } else if (opt.format [iorheo::vtkpolydata]) {
      return g.put_vtk_polydata(s);
  } else if (opt.format [iorheo::bamg]) {
      return g.put_bamg(s);
  } else if (opt.format [iorheo::gmsh]) {
      return g.put_gmsh(s);
  } else if (opt.format [iorheo::mmg3d]) {
      return g.put_mmg3d(s);
  } else if (opt.format [iorheo::tetgen]) {
      return g.put_tetgen(s);
  } else if (opt.format [iorheo::qmg]) {
      return g.put_qmg(s);
  } else if (opt.format [iorheo::cemagref]) {
      return g.put_cemagref(s);
  } else { // format [iorheo::rheo]
      return g.put(s);
  }
}
// ======================================================================
// geo visu members
// ======================================================================
geo_visu_option_type::geo_visu_option_type (std::ostream& s) {
     format  = iorheo::flags(s) & iorheo::format_field;
     verbose = iorheo::getverbose(s);
     clean   = iorheo::getclean(s);
     execute = iorheo::getexecute(s);
     basename = iorheo::getbasename(s);
     if (basename.length() == 0) basename = "output";
     color   = iorheo::getcolor(s);
     gray    = iorheo::getgray(s);
     black_and_white = iorheo::getblack_and_white(s);
     stereo  = iorheo::getstereo(s);
     fill    = iorheo::getfill(s);
     shrink  = iorheo::getshrink(s);
     tube    = iorheo::gettube(s);
     ball    = iorheo::getball(s);
     full    = iorheo::getfull(s);
     cut     = iorheo::getcut(s);
     split   = iorheo::getsplit(s);
     lattice = iorheo::getlattice(s);
     origin  = iofem::getorigin(s);
     normal  = iofem::getnormal(s);
}
void
geo_visu_option_type::dump (ostream& os) const {
    os << "dump geo_visu_option_type:" << endl
       << "  format	" << format << endl
       << "   iorheo::vtk "    << iorheo::vtk    << endl
       << "   iorheo::mayavi " << iorheo::mayavi << endl
       << "  execute	" << execute << endl
       << "  clean	" << clean << endl
       << "  verbose	" << verbose << endl
       << "  fill	" << fill << endl
       << "  basename	" << basename << endl
       << "  color	" << color << endl
       << "  gray	" << gray << endl
       << "  black_and_white	" << black_and_white << endl
       << "  stereo	" << stereo << endl
       << "  fill	" << fill << endl
       << "  shrink	" << shrink << endl
       << "  tube	" << tube << endl
       << "  ball	" << ball << endl
       << "  full	" << full << endl
       << "  cut	" << cut << endl
       << "  split	" << split << endl
       << "  lattice	" << lattice << endl
       << "  origin	" << origin << endl
       << "  normal	" << normal << endl
       << endl;
}
}// namespace rheolef
