#ifndef VECTOR_EXTENSSION_H
#define VECTOR_EXTENSSION_H
///
/// This file is part of Rheolef.
///
/// Copyright (C) 2000-2009 Pierre Saramito <Pierre.Saramito@imag.fr>
///
/// Rheolef is free software; you can redistribute it and/or modify
/// it under the terms of the GNU General Public License as published by
/// the Free Software Foundation; either version 2 of the License, or
/// (at your option) any later version.
///
/// Rheolef is distributed in the hope that it will be useful,
/// but WITHOUT ANY WARRANTY; without even the implied warranty of
/// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
/// GNU General Public License for more details.
///
/// You should have received a copy of the GNU General Public License
/// along with Rheolef; if not, write to the Free Software
/// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
/// 
/// =========================================================================

#include <boost/numeric/ublas/vector.hpp>

namespace boost { namespace numeric { namespace ublas {

    // (v1 * v2) [i] = v1 [i] * v2 [i]
    template<class E1, class E2>
    inline
    typename vector_binary_traits<E1, E2, 
      scalar_multiplies<typename E1::value_type, 
                        typename E2::value_type> >::result_type
    mul (const vector_expression<E1> &e1, 
         const vector_expression<E2> &e2) {
         typedef typename 
	   vector_binary_traits<E1, E2, 
	     scalar_multiplies<
	       typename E1::value_type, 
               typename E2::value_type> >::expression_type expression_type;
        return expression_type (e1 (), e2 ());
    }
    // (v1 / v2) [i] = v1 [i] / v2 [i]
    template<class E1, class E2>
    inline
    typename vector_binary_traits<E1, E2, 
      scalar_divides<typename E1::value_type, 
                        typename E2::value_type> >::result_type
    div (const vector_expression<E1> &e1, 
         const vector_expression<E2> &e2) {
         typedef typename 
	   vector_binary_traits<E1, E2, 
	     scalar_divides<
	       typename E1::value_type, 
               typename E2::value_type> >::expression_type expression_type;
        return expression_type (e1 (), e2 ());
    }


}}}
#endif // VECTOR_EXTENSSION_H
