/* ====================================================================
 * ===  Copyright (C) 1998-2007 Yutaka Sagiya. All rights reserved. ===
 * ====================================================================
 * 
 *    Project              : SagCAD
 *    Description          : CAD/CAM
 *    Source               : CulcInputDlg.c
 * 
 *    ----------------------------------
 * 
 *    License              : GNU General Public License (GPL)
 *    Copyright            : (C) 1998-2007 by Yutaka Sagiya
 *    email                : kappa@a6s.highway.ne.jp
 *                         : yutaka@sagiya.com
 *    Begin                : 2003/03/09
 *    Last                 : 2007/11/08
 * ====================================================================
 */

#ifdef HAVE_CONFIG_H
#  include "config.h"
#endif

#include <gtk/gtk.h>
#include <gdk/gdkkeysyms.h>
#include <string.h>
#include <stdio.h>
#include <stdlib.h>

#include "culcfunc.h"
#include "StringCulc.h"
#define _CULCINPUTDLG_
#include "CulcInputDlg.h"


/* -----------------------------------------------------------------------------
 * Button Pushed
 */
void button_pushed(GtkWidget *widget, CULCINPUT_DLG *culcinput_dlg)
{
	char str[256];
	double d_value;
	const char *str_button;
	int start, end;
	gboolean result;
	int position;
	char *get_char;
	
	/* ボタンのラベルの文字をゲッツ */
	str_button = gtk_button_get_label(GTK_BUTTON(widget));
	
	/* = */
	if (strcmp(str_button, "=") == 0) {
		/* テキストエントリーから文字列を取得 */
		strcpy(str, gtk_entry_get_text(GTK_ENTRY(culcinput_dlg->entry)));
		/* 式の計算をして返す */
		d_value = StringCulc(str);
		FloatOut_n(str, d_value, 6, 0);
		gtk_entry_set_text(GTK_ENTRY(culcinput_dlg->entry), str);
		gtk_editable_set_position (GTK_EDITABLE(culcinput_dlg->entry), -1);
	}
	/* C */
	else if (strcmp(str_button, "C") == 0) {
		str[0] = '\0';
		gtk_entry_set_text(GTK_ENTRY(culcinput_dlg->entry), str);
	}
	/* . */
	else if (strcmp(str_button, ".") == 0) {
		/* 選択されていたら */
		result = gtk_editable_get_selection_bounds(
				GTK_EDITABLE(culcinput_dlg->entry), &start, &end);
		if (result == TRUE) {
			gtk_editable_delete_text (GTK_EDITABLE(culcinput_dlg->entry), start, end);
		}
		
		
		position = gtk_editable_get_position(GTK_EDITABLE(culcinput_dlg->entry));
		
		/* 文字列の先頭 */
		if (position == 0) {
			gtk_editable_insert_text(GTK_EDITABLE(culcinput_dlg->entry), 
						"0", 
						1, 
						&position);
			gtk_editable_set_position (GTK_EDITABLE(culcinput_dlg->entry), position);
		}
		/* 先頭でないなら１個前の文字を確認 */
		else {
			get_char = gtk_editable_get_chars (GTK_EDITABLE(culcinput_dlg->entry),
						position - 1, position);
			/* 数字でないなら */
			if (0x30 > get_char[0] || 0x39 < get_char[0]) {
				gtk_editable_insert_text(GTK_EDITABLE(culcinput_dlg->entry), 
							"0", 
							1, 
							&position);
				gtk_editable_set_position (GTK_EDITABLE(culcinput_dlg->entry), position);
			}
		}
		
		position = gtk_editable_get_position(GTK_EDITABLE(culcinput_dlg->entry));
		gtk_editable_insert_text(GTK_EDITABLE(culcinput_dlg->entry), 
					str_button, 
					strlen(str_button), 
					&position);
		gtk_editable_set_position (GTK_EDITABLE(culcinput_dlg->entry), position);
	}
	else {
		/* 選択されていたら */
		result = gtk_editable_get_selection_bounds(
					GTK_EDITABLE(culcinput_dlg->entry), &start, &end);
		if (result == TRUE) {
			gtk_editable_delete_text (GTK_EDITABLE(culcinput_dlg->entry), start, end);
		}
		position = gtk_editable_get_position(GTK_EDITABLE(culcinput_dlg->entry));
		gtk_editable_insert_text(GTK_EDITABLE(culcinput_dlg->entry), 
					str_button, 
					strlen(str_button), 
					&position);
		gtk_editable_set_position (GTK_EDITABLE(culcinput_dlg->entry), position);
	}
}


/* -----------------------------------------------------------------------------
 * CANCEL
 */
void culcinput_dlg_cancel_pushed(GtkWidget *widget, CULCINPUT_DLG *culcinput_dlg)
{
	culcinput_dlg->value = 0;
	culcinput_dlg->anser = 0;
	strcpy(culcinput_dlg->default_str, "");
}


/* -----------------------------------------------------------------------------
 * OK
 */
void culcinput_dlg_ok_pushed(GtkWidget *widget, CULCINPUT_DLG *culcinput_dlg)
{
	/* テキストエントリーから文字列を取得 */
	strcpy(culcinput_dlg->default_str, gtk_entry_get_text(GTK_ENTRY(culcinput_dlg->entry)));
	
	/* 式の計算をして返す */
	culcinput_dlg->anser = StringCulc(culcinput_dlg->default_str);
	
	FloatOut_n(culcinput_dlg->default_str, culcinput_dlg->anser, 6, 0);
	
	strcpy(def_str, culcinput_dlg->default_str);
	culcinput_dlg->value = 1;
}


/* -----------------------------------------------------------------------------
 * キーが押されたイベント
 * 
 *     key_press_event
 * 
 *     linux (GTK-2.8) では、以前の入力がセレクトされているときに、１文字目を入れると
 *     その文字が２文字入ってしまうため、[0-9],+,-,*,/,(,) もボタンを押した処理にした。
 * 
 * TRUE で返すと、ＧＴＫ側では何もしないが、
 * FALSE で返すと、ＧＴＫ側でも文字を入力する。
 * 
 */
static gint culcinput_dlg_key_press_event(GtkWidget *widget, GdkEventKey *event, CULCINPUT_DLG *culcinput_dlg)
{
	switch (event->keyval) {
	case GDK_Return:
	case GDK_KP_Enter:
		culcinput_dlg_ok_pushed(widget, culcinput_dlg);
		gtk_main_quit();
		break;
	default:
		break;
	}
	
	switch (event->string[0]) {
	case ' ' :
	case '=' :
		gtk_button_clicked (GTK_BUTTON(culcinput_dlg->button[CID_BTN_EQUAL]));
		return TRUE;
		break;
	case '.' :
		gtk_button_clicked (GTK_BUTTON(culcinput_dlg->button[CID_BTN_DOT]));
		return TRUE;
		break;
	case 'C' :
		gtk_button_clicked (GTK_BUTTON(culcinput_dlg->button[CID_BTN_CLEAR]));
		return TRUE;
		break;
	case '+' :
		gtk_button_clicked (GTK_BUTTON(culcinput_dlg->button[CID_BTN_PURASU]));
		return TRUE;
		break;
	case '-' :
		gtk_button_clicked (GTK_BUTTON(culcinput_dlg->button[CID_BTN_MAINASU]));
		return TRUE;
		break;
	case '*' :
		gtk_button_clicked (GTK_BUTTON(culcinput_dlg->button[CID_BTN_KAKERU]));
		return TRUE;
		break;
	case '/' :
		gtk_button_clicked (GTK_BUTTON(culcinput_dlg->button[CID_BTN_WARU]));
		return TRUE;
		break;
	case '(' :
		gtk_button_clicked (GTK_BUTTON(culcinput_dlg->button[CID_BTN_OPEN]));
		return TRUE;
		break;
	case ')' :
		gtk_button_clicked (GTK_BUTTON(culcinput_dlg->button[CID_BTN_CLOSED]));
		return TRUE;
		break;
	case '0' :
	case '1' :
	case '2' :
	case '3' :
	case '4' :
	case '5' :
	case '6' :
	case '7' :
	case '8' :
	case '9' :
		gtk_button_clicked (GTK_BUTTON(culcinput_dlg->button[atoi(event->string)]));
		return TRUE;
		break;
	default:
		break;
	}
	return FALSE;
}


/* -----------------------------------------------------------------------------
 * データ入力ダイアログ
 * 
 */
gint CulcInputDialog(CULCINPUT_DLG *culcinput_dlg)
{
	GtkWidget *main_vbox;
	GtkWidget *vbox;
	GtkWidget *msg1_label;
	GtkWidget *msg2_label;
	GtkWidget *table;
	GtkWidget *separator;
	GtkWidget *action_hbox;
	GtkWidget *cancel_buttun;
	GtkWidget *ok_buttun;
	
	/* ダイアログ(culcinput_dlg->dialog)生成 */
	culcinput_dlg->dialog = gtk_window_new(GTK_WINDOW_TOPLEVEL);
	gtk_window_set_title(GTK_WINDOW(culcinput_dlg->dialog), 
				culcinput_dlg->title);
	
	gtk_window_set_position(GTK_WINDOW(culcinput_dlg->dialog), 
				GTK_WIN_POS_MOUSE/*GTK_WIN_POS_CENTER*/);
	
	/* ダイアログを最前面に表示する */
	gtk_window_set_modal(GTK_WINDOW(culcinput_dlg->dialog), TRUE);
	/* メインウィンドウを操作できないように設定 */
	gtk_window_set_transient_for(GTK_WINDOW(culcinput_dlg->dialog), 
				GTK_WINDOW(culcinput_dlg->parent));
	
	g_signal_connect( G_OBJECT(culcinput_dlg->dialog), "key_press_event",
				G_CALLBACK(culcinput_dlg_key_press_event), culcinput_dlg);
	
		/* ダイアログの中にまず、パッキングボックス(main_vbox)を作成 */
		main_vbox = gtk_vbox_new(0, 5);
		gtk_container_add(GTK_CONTAINER(culcinput_dlg->dialog), main_vbox);
		gtk_container_set_border_width(GTK_CONTAINER(culcinput_dlg->dialog), 5);
		gtk_widget_show(main_vbox);
		
			/* -----------------------------------------------------
			 * パッキングボックス(main_vbox) に入れる
			 * パッキングボックス(vbox & table & action_hbox) を作成し
			 * 格納する
			 */
			/* パッキングボックス(hbox) */
			vbox = gtk_vbox_new(FALSE, 2);
			gtk_box_pack_start( (GtkBox *)GTK_BOX(main_vbox), 
								vbox, TRUE, TRUE, 0);
			gtk_widget_show(vbox);
			
				/* ラベル(msg1_label)の作成 */
				if (culcinput_dlg->msg1[0] != '\0') {
					msg1_label = gtk_label_new(culcinput_dlg->msg1);
					gtk_box_pack_start((GtkBox *)GTK_BOX(vbox), msg1_label, TRUE, TRUE, 0);
					gtk_widget_show(msg1_label);
				}
				
				/* ラベル(msg2_label)の作成 */
				if (culcinput_dlg->msg2[0] != '\0') {
					msg2_label = gtk_label_new(culcinput_dlg->msg2);
					gtk_box_pack_start((GtkBox *)GTK_BOX(vbox), msg2_label, TRUE, TRUE, 0);
					gtk_widget_show(msg2_label);
				}
				
				/* テキストエントリー(culcinput_dlg->entry)生成 */
				culcinput_dlg->entry = gtk_entry_new();
				gtk_box_pack_start((GtkBox *)GTK_BOX(vbox), culcinput_dlg->entry, TRUE, TRUE, 1);
				gtk_entry_set_max_length(GTK_ENTRY(culcinput_dlg->entry), 256);
				/* 初期値設定 */
				if (strlen(culcinput_dlg->default_str) == 0) {
					strcpy(culcinput_dlg->default_str, def_str);
				}
				gtk_entry_set_text(GTK_ENTRY(culcinput_dlg->entry), culcinput_dlg->default_str);
				gtk_widget_show(culcinput_dlg->entry);
				
			/* セパレーター(separator) */
			separator = gtk_hseparator_new();
			gtk_box_pack_start( GTK_BOX(main_vbox), separator, TRUE, TRUE, 0);
			gtk_widget_show(separator);
			
			/* テーブルパッキング(table) */
			table = gtk_table_new(4, 5, FALSE);
			gtk_box_pack_start( GTK_BOX(main_vbox), table, TRUE, TRUE, 0);
			gtk_widget_show(table);
			
				/* button_0 */
				culcinput_dlg->button[CID_BTN_0] = gtk_button_new_with_label("0");
				gtk_table_attach_defaults(GTK_TABLE(table), 
						culcinput_dlg->button[CID_BTN_0], 0, 2, 3, 4);
				g_signal_connect(G_OBJECT(culcinput_dlg->button[CID_BTN_0]), 
						"clicked", 
						G_CALLBACK(button_pushed), 
						culcinput_dlg);
				gtk_widget_show(culcinput_dlg->button[CID_BTN_0]);
				
				/* button_1 */
				culcinput_dlg->button[CID_BTN_1] = gtk_button_new_with_label("1");
				gtk_table_attach_defaults(GTK_TABLE(table), 
						culcinput_dlg->button[CID_BTN_1], 0, 1, 2, 3);
				g_signal_connect(G_OBJECT(culcinput_dlg->button[CID_BTN_1]), 
						"clicked", 
						G_CALLBACK(button_pushed), 
						culcinput_dlg);
				gtk_widget_show(culcinput_dlg->button[CID_BTN_1]);
				
				/* button_2 */
				culcinput_dlg->button[CID_BTN_2] = gtk_button_new_with_label("2");
				gtk_table_attach_defaults(GTK_TABLE(table), 
						culcinput_dlg->button[CID_BTN_2], 1, 2, 2, 3);
				g_signal_connect(G_OBJECT(culcinput_dlg->button[CID_BTN_2]), 
						"clicked", 
						G_CALLBACK(button_pushed), 
						culcinput_dlg);
				gtk_widget_show(culcinput_dlg->button[CID_BTN_2]);
				
				/* button_3 */
				culcinput_dlg->button[CID_BTN_3] = gtk_button_new_with_label("3");
				gtk_table_attach_defaults(GTK_TABLE(table), 
						culcinput_dlg->button[CID_BTN_3], 2, 3, 2, 3);
				g_signal_connect(G_OBJECT(culcinput_dlg->button[CID_BTN_3]), 
						"clicked", 
						G_CALLBACK(button_pushed), 
						culcinput_dlg);
				gtk_widget_show(culcinput_dlg->button[CID_BTN_3]);
				
				/* button_4 */
				culcinput_dlg->button[CID_BTN_4] = gtk_button_new_with_label("4");
				gtk_table_attach_defaults(GTK_TABLE(table), 
						culcinput_dlg->button[CID_BTN_4], 0, 1, 1, 2);
				g_signal_connect(G_OBJECT(culcinput_dlg->button[CID_BTN_4]), 
						"clicked", 
						G_CALLBACK(button_pushed), 
						culcinput_dlg);
				gtk_widget_show(culcinput_dlg->button[CID_BTN_4]);
				
				/* button_5 */
				culcinput_dlg->button[CID_BTN_5] = gtk_button_new_with_label("5");
				gtk_table_attach_defaults(GTK_TABLE(table), 
						culcinput_dlg->button[CID_BTN_5], 1, 2, 1, 2);
				g_signal_connect(G_OBJECT(culcinput_dlg->button[CID_BTN_5]), 
						"clicked", 
						G_CALLBACK(button_pushed), 
						culcinput_dlg);
				gtk_widget_show(culcinput_dlg->button[CID_BTN_5]);
				
				/* button_6 */
				culcinput_dlg->button[CID_BTN_6] = gtk_button_new_with_label("6");
				gtk_table_attach_defaults(GTK_TABLE(table), 
						culcinput_dlg->button[CID_BTN_6], 2, 3, 1, 2);
				g_signal_connect(G_OBJECT(culcinput_dlg->button[CID_BTN_6]), 
						"clicked", 
						G_CALLBACK(button_pushed), 
						culcinput_dlg);
				gtk_widget_show(culcinput_dlg->button[CID_BTN_6]);
				
				/* button_7 */
				culcinput_dlg->button[CID_BTN_7] = gtk_button_new_with_label("7");
				gtk_table_attach_defaults(GTK_TABLE(table), 
						culcinput_dlg->button[CID_BTN_7], 0, 1, 0, 1);
				g_signal_connect(G_OBJECT(culcinput_dlg->button[CID_BTN_7]), 
						"clicked", 
						G_CALLBACK(button_pushed), 
						culcinput_dlg);
				gtk_widget_show(culcinput_dlg->button[CID_BTN_7]);
				
				/* button_8 */
				culcinput_dlg->button[CID_BTN_8] = gtk_button_new_with_label("8");
				gtk_table_attach_defaults(GTK_TABLE(table), 
						culcinput_dlg->button[CID_BTN_8], 1, 2, 0, 1);
				g_signal_connect(G_OBJECT(culcinput_dlg->button[CID_BTN_8]), 
						"clicked", 
						G_CALLBACK(button_pushed), 
						culcinput_dlg);
				gtk_widget_show(culcinput_dlg->button[CID_BTN_8]);
				
				/* button_9 */
				culcinput_dlg->button[CID_BTN_9] = gtk_button_new_with_label("9");
				gtk_table_attach_defaults(GTK_TABLE(table), 
						culcinput_dlg->button[CID_BTN_9], 2, 3, 0, 1);
				g_signal_connect(G_OBJECT(culcinput_dlg->button[CID_BTN_9]), 
						"clicked", 
						G_CALLBACK(button_pushed), 
						culcinput_dlg);
				gtk_widget_show(culcinput_dlg->button[CID_BTN_9]);
				
				
				/* button_point */
				culcinput_dlg->button[CID_BTN_DOT] = gtk_button_new_with_label(".");
				gtk_table_attach_defaults(GTK_TABLE(table), 
						culcinput_dlg->button[CID_BTN_DOT], 2, 3, 3, 4);
				g_signal_connect(G_OBJECT(culcinput_dlg->button[CID_BTN_DOT]), 
						"clicked", 
						G_CALLBACK(button_pushed), 
						culcinput_dlg);
				gtk_widget_show(culcinput_dlg->button[CID_BTN_DOT]);
				
				/* + */
				culcinput_dlg->button[CID_BTN_PURASU] = gtk_button_new_with_label("+");
				gtk_table_attach_defaults(GTK_TABLE(table), 
						culcinput_dlg->button[CID_BTN_PURASU], 3, 4, 3, 4);
				g_signal_connect(G_OBJECT(culcinput_dlg->button[CID_BTN_PURASU]), 
						"clicked", 
						G_CALLBACK(button_pushed), 
						culcinput_dlg);
				gtk_widget_show(culcinput_dlg->button[CID_BTN_PURASU]);
				
				/* - */
				culcinput_dlg->button[CID_BTN_MAINASU] = gtk_button_new_with_label("-");
				gtk_table_attach_defaults(GTK_TABLE(table), 
						culcinput_dlg->button[CID_BTN_MAINASU], 3, 4, 2, 3);
				g_signal_connect(G_OBJECT(culcinput_dlg->button[CID_BTN_MAINASU]), 
						"clicked", 
						G_CALLBACK(button_pushed), 
						culcinput_dlg);
				gtk_widget_show(culcinput_dlg->button[CID_BTN_MAINASU]);
				
				/* * */
				culcinput_dlg->button[CID_BTN_KAKERU] = gtk_button_new_with_label("*");
				gtk_table_attach_defaults(GTK_TABLE(table), 
						culcinput_dlg->button[CID_BTN_KAKERU], 3, 4, 1, 2);
				g_signal_connect(G_OBJECT(culcinput_dlg->button[CID_BTN_KAKERU]), 
						"clicked", 
						G_CALLBACK(button_pushed), 
						culcinput_dlg);
				gtk_widget_show(culcinput_dlg->button[CID_BTN_KAKERU]);
				
				/* / */
				culcinput_dlg->button[CID_BTN_WARU] = gtk_button_new_with_label("/");
				gtk_table_attach_defaults(GTK_TABLE(table), 
						culcinput_dlg->button[CID_BTN_WARU], 3, 4, 0, 1);
				g_signal_connect(G_OBJECT(culcinput_dlg->button[CID_BTN_WARU]), 
						"clicked", 
						G_CALLBACK(button_pushed), 
						culcinput_dlg);
				gtk_widget_show(culcinput_dlg->button[CID_BTN_WARU]);
				
				/* button_clear */
				culcinput_dlg->button[CID_BTN_CLEAR] = gtk_button_new_with_label("C");
				gtk_table_attach_defaults(GTK_TABLE(table), 
						culcinput_dlg->button[CID_BTN_CLEAR], 4, 5, 2, 3);
				g_signal_connect(G_OBJECT(culcinput_dlg->button[CID_BTN_CLEAR]), 
						"clicked", 
						G_CALLBACK(button_pushed), 
						culcinput_dlg);
				gtk_widget_show(culcinput_dlg->button[CID_BTN_CLEAR]);
				
				/* button_open_brackets */
				culcinput_dlg->button[CID_BTN_OPEN] = gtk_button_new_with_label("(");
				gtk_table_attach_defaults(GTK_TABLE(table), 
						culcinput_dlg->button[CID_BTN_OPEN], 4, 5, 0, 1);
				g_signal_connect(G_OBJECT(culcinput_dlg->button[CID_BTN_OPEN]), 
						"clicked", 
						G_CALLBACK(button_pushed), 
						culcinput_dlg);
				gtk_widget_show(culcinput_dlg->button[CID_BTN_OPEN]);
				
				/* button_closed_brackets */
				culcinput_dlg->button[CID_BTN_CLOSED] = gtk_button_new_with_label(")");
				gtk_table_attach_defaults(GTK_TABLE(table), 
						culcinput_dlg->button[CID_BTN_CLOSED], 4, 5, 1, 2);
				g_signal_connect(G_OBJECT(culcinput_dlg->button[CID_BTN_CLOSED]), 
						"clicked", 
						G_CALLBACK(button_pushed), 
						culcinput_dlg);
				gtk_widget_show(culcinput_dlg->button[CID_BTN_CLOSED]);
				
				/* button_equal */
				culcinput_dlg->button[CID_BTN_EQUAL] = gtk_button_new_with_label("=");
				gtk_table_attach_defaults(GTK_TABLE(table), 
						culcinput_dlg->button[CID_BTN_EQUAL], 4, 5, 3, 4);
				g_signal_connect(G_OBJECT(culcinput_dlg->button[CID_BTN_EQUAL]), 
						"clicked", 
						G_CALLBACK(button_pushed), 
						culcinput_dlg);
				gtk_widget_show(culcinput_dlg->button[CID_BTN_EQUAL]);
				
		/* セパレーター(separator) */
		separator = gtk_hseparator_new();
		gtk_box_pack_start( GTK_BOX(main_vbox), separator, TRUE, TRUE, 0);
		gtk_widget_show(separator);
		
		/* パッキングボックス(action_hbox) */
		action_hbox = gtk_hbox_new(FALSE, 2);
		gtk_box_pack_start( GTK_BOX(main_vbox), action_hbox, TRUE, TRUE, 0);
		gtk_widget_show(action_hbox);
		
			/* -----------------------------------------------------
			 * パッキングボックス(action_hbox) に入れる
			 * ボタン(cancel_buttun & ok_buttun) を作成し
			 * 格納する
			 */
			/* CANCELボタンの生成 */
			cancel_buttun = gtk_button_new_with_label("CANCEL");
			gtk_box_pack_start((GtkBox *)GTK_BOX(action_hbox), cancel_buttun, TRUE, TRUE, 2);
			g_signal_connect( G_OBJECT(cancel_buttun), "clicked", 
					G_CALLBACK(culcinput_dlg_cancel_pushed), culcinput_dlg);
			g_signal_connect( G_OBJECT(cancel_buttun), "clicked", 
					G_CALLBACK(gtk_main_quit), NULL);
			gtk_widget_show(cancel_buttun);
			
			/* OKボタンの生成 */
			ok_buttun = gtk_button_new_with_label("OK");
			gtk_box_pack_start((GtkBox *)GTK_BOX(action_hbox), ok_buttun, TRUE, TRUE, 2);
			g_signal_connect(G_OBJECT(ok_buttun), "clicked", 
					G_CALLBACK(culcinput_dlg_ok_pushed), culcinput_dlg);
			g_signal_connect(G_OBJECT(ok_buttun), "clicked", 
					G_CALLBACK(gtk_main_quit), NULL);
			gtk_widget_show(ok_buttun);
			
	/*  フォーカスを entry に設定 */
	gtk_window_set_focus(GTK_WINDOW(culcinput_dlg->dialog), culcinput_dlg->entry);
	gtk_editable_select_region( GTK_EDITABLE(culcinput_dlg->entry), 0, 
			GTK_ENTRY(culcinput_dlg->entry)->text_length);
	
	/* ダイアログを可視状態へ */
	gtk_widget_show(culcinput_dlg->dialog);
	/* メインイベントループ */
	gtk_main();
	gtk_widget_destroy(culcinput_dlg->dialog);
	return 0; 
}


/* -----------------------------------------------------------------------------
 * データ入力ダイアログ
 * 
 */
gint CulcInputBox(GtkWidget *widget, char *title, char *msg1, char *msg2, char *default_str)
{
	CULCINPUT_DLG a;
	int i;
	
	a.value = 0;
	strcpy(a.title, title);
	strcpy(a.msg1, msg1);
	strcpy(a.msg2, msg2);
	strcpy(a.default_str, default_str);
	a.push_str = 0;
	a.anser = 0;
	a.entry = NULL;
	
	for (i=0; i<20; i++) {
		a.button[i] = NULL;
	}
	a.parent = widget;
	a.dialog = NULL;
	
	CulcInputDialog(&a);
	if (a.value == 0) {
		return -1;
	}
	strcpy(default_str, a.default_str);
	
	return 0;
}


/* ====================================================================
 * ===  Copyright (C) 1998-2007 Yutaka Sagiya. All rights reserved. ===
 * ====================================================================
 *    Project              : SagCAD
 *    Source               : CulcInputDlg.c
 * ====================================================================
 */
