//<-- CLI SHELL MODE -->
// =============================================================================
// Scilab ( https://www.scilab.org/ ) - This file is part of Scilab
// Copyright (C) ????-2008 - INRIA Serge Steer
//
//  This file is distributed under the same license as the Scilab package.
// =============================================================================



function [x,y]=erf_ref()
    //reference Yr=erf(X) generee par Maple
    //pm:=array(1..1001):x:=-5:
    //for k from 1  to 1001 do
    //pm[k]:=evalf[24](erf(x)):
    //x:=x+0.01:end do;


    x=-5:0.01:5;

    y=[-0.999999999998462540205572
    -0.999999999998297733894900
    -0.999999999998115631480261
    -0.999999999997914458007001
    -0.999999999997692260661541
    -0.999999999997446891397149
    -0.999999999997175987908301
    -0.999999999996876952801260
    -0.999999999996546930794861
    -0.999999999996182783770717
    -0.999999999995781063475994
    -0.999999999995337981664472
    -0.999999999994849377442675
    -0.999999999994310681567322
    -0.999999999993716877418075
    -0.999999999993062458345374
    -0.999999999992341381066975
    -0.999999999991547014758366
    -0.999999999990672085451468
    -0.999999999989708615322670
    -0.999999999988647856415078
    -0.999999999987480218300757
    -0.999999999986195189146334
    -0.999999999984781249599477
    -0.999999999983225778864110
    -0.999999999981514952278515
    -0.999999999979633629652374
    -0.999999999977565233555991
    -0.999999999975291616686970
    -0.999999999972792917366275
    -0.999999999970047402136203
    -0.999999999967031294347156
    -0.999999999963718587527495
    -0.999999999960080842230859
    -0.999999999956086964947412
    -0.999999999951702967549089
    -0.999999999946891705613252
    -0.999999999941612593833703
    -0.999999999935821296581860
    -0.999999999929469391523360
    -0.999999999922504004025582
    -0.999999999914867409908580
    -0.999999999906496603894840
    -0.999999999897322830900966
    -0.999999999887271077085832
    -0.999999999876259517323697
    -0.999999999864198915505960
    -0.999999999850991973790366
    -0.999999999836532626610029
    -0.999999999820705274925103
    -0.999999999803383955845711
    -0.999999999784431442373954
    -0.999999999763698267603729
    -0.999999999741021667277623
    -0.999999999716224434128131
    -0.999999999689113676923764
    -0.999999999659479476596644
    -0.999999999627093431244556
    -0.999999999591707081174197
    -0.999999999553050204480830
    -0.999999999510828972939411
    -0.999999999464723957210342
    -0.999999999414387969535759
    -0.999999999359443731215952
    -0.999999999299481351206210
    -0.999999999234055601157792
    -0.999999999162682971138542
    -0.999999999084838489103913
    -0.999999998999952285943071
    -0.999999998907405886591731
    -0.999999998806528206277959
    -0.999999998696591229443244
    -0.999999998576805347252390
    -0.999999998446314327865434
    -0.999999998304189891785759
    -0.999999998149425862613257
    -0.999999997980931861411821
    -0.999999997797526510638154
    -0.999999997597930111164948
    -0.999999997380756753356393
    -0.999999997144505820407811
    -0.999999996887552839233372
    -0.999999996608139631065173
    -0.999999996304363710601733
    -0.999999995974166879001692
    -0.999999995615322952246180
    -0.999999995225424562376994
    -0.999999994801868964843021
    -0.999999994341842780638679
    -0.999999993842305597079599
    -0.999999993299972345915102
    -0.999999992711294372006456
    -0.999999992072439099985541
    -0.999999991379268200130508
    -0.999999990627314148132540
    -0.999999989811755066458970
    -0.999999988927387727619661
    -0.999999987968598591791738
    -0.999999986929332742926881
    -0.999999985803060578628974
    -0.999999984582742099719981
    -0.999999983260788635479157
    -0.999999981829021830014495
    -0.999999980278629704073472
    -0.999999978600119594788978
    -0.999999976783267763350693
    -0.999999974817065447355071
    -0.999999972689661120580137
    -0.999999970388298708114035
    -0.999999967899251489096719
    -0.999999965207751402768258
    -0.999999962297913456009131
    -0.999999959152654912059634
    -0.999999955753608920567185
    -0.999999952081032228479841
    -0.999999948113706589527419
    -0.999999943828833467051722
    -0.999999939201921600705774
    -0.999999934206666981977303
    -0.999999928814824756540487
    -0.999999922996072543035871
    -0.999999916717864627952817
    -0.999999909945276464770342
    -0.999999902640838872326778
    -0.999999894764361292459493
    -0.999999886272743430203347
    -0.999999877119774561178120
    -0.999999867255919750145400
    -0.999999856628092181986012
    -0.999999845179410761448597
    -0.999999832848942090853798
    -0.999999819571425885409310
    -0.999999805276982833797809
    -0.999999789890803857138683
    -0.999999773332819662188394
    -0.999999755517349424622676
    -0.999999736352727375323111
    -0.999999715740905996653838
    -0.999999693577034466641037
    -0.999999669749010916634964
    -0.999999644137006992314701
    -0.999999616612963128659530
    -0.999999587040052866624547
    -0.999999555272114452585247
    -0.999999521153047871016725
    -0.999999484516175366204968
    -0.999999445183563409904602
    -0.999999402965303968610622
    -0.999999357658752816349255
    -0.999999309047722526460751
    -0.999999256901627658587254
    -0.999999200974579534832405
    -0.999999141004427871663589
    -0.999999076711746401418634
    -0.999999007798759479089598
    -0.999998933948206526218906
    -0.999998854822141014087435
    -0.999998770060660532728832
    -0.999998679280564330496742
    -0.999998582073934540768369
    -0.999998478006637137714638
    -0.999998366616738481729930
    -0.999998247412833126918517
    -0.999998119872278367806604
    -0.999997983439330800015059
    -0.999997837523179959816750
    -0.999997681495873890143584
    -0.999997514690131255533768
    -0.999997336397034395554135
    -0.999997145863597465233101
    -0.999996942290203561838538
    -0.999996724827904479777092
    -0.999996492575576469327953
    -0.999996244576925100210857
    -0.999995979817332047487635
    -0.999995697220536324878170
    -0.999995395645142189112255
    -0.999995073880945628324028
    -0.999994730645071027620088
    -0.999994364577909275721057
    -0.999993974238848237905028
    -0.999993558101786172297790
    -0.999993114550418308799710
    -0.999992641873286442566995
    -0.999992138258581016945169
    -0.999991601788684784070191
    -0.999991030434446735009890
    -0.999990422049174585335565
    -0.999989774362333686430315
    -0.999989084972939807716761
    -0.999988351342632800403966
    -0.999987570788417709415870
    -0.999986740475059447000171
    -0.999985857407116679281056
    -0.999984918420600105892450
    -0.999983920174239833019164
    -0.999982859140346051919802
    -0.999981731595246738576625
    -0.999980533609285585815045
    -0.999979261036362867394040
    -0.999977909503001414558627
    -0.999976474396919359773184
    -0.999974950855090770264459
    -0.999973333751274756079605
    -0.999971617682993094132439
    -0.999969796957935861737626
    -0.999967865579774021028779
    -0.999965817233357340078774
    -0.999963645269275478192029
    -0.999961342687759502470105
    -0.999958902121900541164316
    -0.999956315820161717373451
    -0.999953575628158945224767
    -0.999950672969685610748981
    -0.999947598826955602236751
    -0.999944343720038601012541
    -0.999940897685460994406321
    -0.999937250253945229426789
    -0.999933390427259889483441
    -0.999929306654152248770470
    -0.999924986805334540975777
    -0.999920418147494672237463
    -0.999915587316301614224693
    -0.999910480288375233419033
    -0.999905082352189848729210
    -0.999899378077880363163096
    -0.999893351285919388145981
    -0.999886985014633373018311
    -0.999880261486525369137321
    -0.999873162073371699777589
    -0.999865667260059475670860
    -0.999857756607131593604098
    -0.999849408712005584127087
    -0.999840601168832436289035
    -0.999831310526961324669729
    -0.999821512247975999096039
    -0.999811180661268472697860
    -0.999800288918115561773568
    -0.999788808944223793772524
    -0.999776711390708210081766
    -0.999763965583470650796009
    -0.999750539470943221871744
    -0.999736399570162813678909
    -0.999721510911142766670001
    -0.999705836979508067426713
    -0.999689339657360809492885
    -0.999671979162343070964282
    -0.999653713984864847611602
    -0.999634500823465239215587
    -0.999614294518275720661921
    -0.999593047982555041060436
    -0.999570712132266086606323
    -0.999547235813665918980236
    -0.999522565728881163674247
    -0.999496646359441974605568
    -0.999469419887748945596554
    -0.999440826116448578590456
    -0.999410802385694255639232
    -0.999379283488271099505731
    -0.999346201582564648884856
    -0.999311486103354921430255
    -0.999275063670419193575791
    -0.999236857994928693095374
    -0.999196789783626380902110
    -0.999154776640775095111632
    -0.999110732967867545150889
    -0.999064569861091978842036
    -0.999016195006549802974103
    -0.998965512573224019809696
    -0.998912423103700050040183
    -0.998856823402643348534653
    -0.998798606423041184302075
    -0.998737661150219051712021
    -0.998673872483645407328131
    -0.998607121116541786642636
    -0.998537283413318848302089
    -0.998464231284862520615845
    -0.998387832061698186549948
    -0.998307948365064739107359
    -0.998224437975934368814823
    -0.998137153702018108556548
    -0.998045943242801457529124
    -0.997950649052658834678793
    -0.997851108202100171372239
    -0.997747152237207641699493
    -0.997638607037325344858751
    -0.997525292671069695356701
    -0.997407023250733340776017
    -0.997283606785160610778704
    -0.997154845031177801648948
    -0.997020533343667014496115
    -0.996880460524377788338765
    -0.996734408669576397404104
    -0.996582153016638410456033
    -0.996423461789695933775340
    -0.996258096044456873132539
    -0.996085809512319547895015
    -0.995906348443912066070672
    -0.995719451452192015978668
    -0.995524849355248241312063
    -0.995322265018952734162069
    -0.995111413199616997238347
    -0.994892000386813583757223
    -0.994663724646529912575485
    -0.994426275464827868000969
    -0.994179333592189118776836
    -0.993922570888732519066544
    -0.993655650170496375504198
    -0.993378225056984767759469
    -0.993089939820183484438217
    -0.992790429235257469948358
    -0.992479318433147959270642
    -0.992156222755293694076721
    -0.991820747610706752658708
    -0.991472488335639574649461
    -0.991111030056085706155210
    -0.990735947553362618000491
    -0.990346805133030645297762
    -0.989943156497407646205095
    -0.989524544621944366953582
    -0.989090501635730714183733
    -0.988640548706408159263284
    -0.988174195929768317289394
    -0.987690942224322340437041
    -0.987190275231130125566791
    -0.986671671219182443772211
    -0.986134594996632938939331
    -0.985578499828180497431188
    -0.985002827358905745666562
    -0.984407007544868370574912
    -0.983790458590774563626243
    -0.983152586895026146341339
    -0.982492787002464827943096
    -0.981810441565126558280198
    -0.981104921311322055650339
    -0.980375585023360294162452
    -0.979621779524232013515387
    -0.978842839673570150500483
    -0.978038088373203471420329
    -0.977206836582618593554779
    -0.976348383344644007774283
    -0.975462015821667639794134
    -0.974547009342696901235481
    -0.973602627461567070965916
    -0.972628122026600200033799
    -0.971622733262012538372566
    -0.970585689861363727448927
    -0.969516209093335679948252
    -0.968413496920123165931304
    -0.967276748128711635913826
    -0.966105146475310727066976
    -0.964897864843204212102907
    -0.963654065414268855166142
    -0.962372899854405729886811
    -0.961053509513118027313721
    -0.959695025637459232377443
    -0.958296569600564774513511
    -0.956857253144968859850497
    -0.955376178640896168788291
    -0.953852439359705454847226
    -0.952285119762648810516483
    -0.950673295805096476827758
    -0.949016035256362570111835
    -0.947312398035251987699776
    -0.945561436561433041323207
    -0.943762196122724061065830
    -0.941913715258365323657307
    -0.940015026158330197754595
    -0.938065155078711378050909
    -0.936063122773199513379509
    -0.934007944940652436603893
    -0.931898632688733592554243
    -0.929734193013578152514172
    -0.927513629295424719100128
    -0.925235941810129484510736
    -0.922900128256458230136523
    -0.920505184299029669863949
    -0.918050104126761367892733
    -0.915533881026646830667193
    -0.912955507972669409081356
    -0.910313978229635380238406
    -0.907608285971685037790485
    -0.904837426915216837567545
    -0.902000398965935653353894
    -0.899096202879712030000041
    -0.896123842936915012419506
    -0.893082327629856715369185
    -0.889970670362962317254718
    -0.886787890165254649549837
    -0.883533012414718050732089
    -0.880205069574081699771868
    -0.876803101937538279856830
    -0.873326158387889589649984
    -0.869773297163586659132690
    -0.866143586635108082774537
    -0.862436106090096697765226
    -0.858649946526651453191925
    -0.854784211454148381612389
    -0.850838017700942042052444
    -0.846810496228276697886304
    -0.842700792949714869341221
    -0.838508069555369803579790
    -0.834231504340207880514292
    -0.829870293035667064651115
    -0.825423649643818267103596
    -0.820890807273277941907934
    -0.816271018976062450999077
    -0.811563558584557736234438
    -0.806767721547761677691787
    -0.801882825765941237429626
    -0.796908212422832128518725
    -0.791843246814495351087002
    -0.786687319173932540042657
    -0.781439845490550711651092
    -0.776100268323556715663465
    -0.770668057608352532380083
    -0.765142711454994534663544
    -0.759523756937772996814901
    -0.753810750874962507155164
    -0.748003280597789559230994
    -0.742100964707660486167111
    -0.736103453820691090374864
    -0.730010431298578831244359
    -0.723821613964859289254273
    -0.717536752805590846718625
    -0.711155633653515131598938
    -0.704678077854745777673723
    -0.698103942917044475821896
    -0.691433123138751138842000
    -0.684665550217444285287115
    -0.677801193837418472975629
    -0.670840062235077784356887
    -0.663782202741357985424868
    -0.656627702300305046439084
    -0.649376687962954222750275
    -0.642029327355671841292946
    -0.634585829122141313859706
    -0.627046443338195690464736
    -0.619411461898721260562292
    -0.611681218875880289504687
    -0.603856090847925922562622
    -0.595936497197908576518189
    -0.587922900381600743987037
    -0.579815806163996030236782
    -0.571615763823768395668684
    -0.563323366325108955991688
    -0.554939250456390260497539
    -0.546464096935141688222533
    -0.537898630478854431106614
    -0.529243619841170429010070
    -0.520499877813046537682747
    -0.511668261188523099211697
    -0.502749670694764894533266
    -0.493745050886082136517092
    -0.484655390001679655026703
    -0.475481719786923675319682
    -0.466225115277957539319705
    -0.456886694549540304987442
    -0.447467618426025319819411
    -0.437969090155439536373130
    -0.428392355046668455103604
    -0.418738700069796075759558
    -0.409009453419694044918239
    -0.399205984042999234582144
    -0.389329701128664204753628
    -0.379382053562310320297300
    -0.369364529344658637204124
    -0.359278654974358972988254
    -0.349125994795582757315695
    -0.338908150310790248699499
    -0.328626759459127427638914
    -0.318283495860952262338992
    -0.307880068029034016649000
    -0.297418218547012757893882
    -0.286899723215749152048332
    -0.276326390168236932985068
    -0.265700058953792029795712
    -0.255022599592273160770179
    -0.244295911599128684869262
    -0.233521922982103572925263
    -0.222702589210478454140139
    -0.211839892157749742936947
    -0.200935839018695792648413
    -0.189992461201808793395082
    -0.179011813198105671155184
    -0.167995971427363494770210
    -0.156947033062855800871902
    -0.145867114835695749082958
    -0.134758351819920069295014
    -0.123622896199474309769839
    -0.112462916018284892203275
    -0.101280593914626883352498
    -0.0900781258410181607233922
    -0.0788577197708907433569970
    -0.0676215943933084420794315
    -0.0563719777970166238312711
    -0.0451111061451247520897491
    -0.0338412223417354333022167
    -0.0225645746918449442243659
    -0.0112834155558496169159095
    0.
    0.0112834155558496169159095
    0.0225645746918449442243659
    0.0338412223417354333022167
    0.0451111061451247520897491
    0.0563719777970166238312711
    0.0676215943933084420794315
    0.0788577197708907433569970
    0.0900781258410181607233922
    0.101280593914626883352498
    0.112462916018284892203275
    0.123622896199474309769839
    0.134758351819920069295014
    0.145867114835695749082958
    0.156947033062855800871902
    0.167995971427363494770210
    0.179011813198105671155184
    0.189992461201808793395082
    0.200935839018695792648413
    0.211839892157749742936947
    0.222702589210478454140139
    0.233521922982103572925263
    0.244295911599128684869262
    0.255022599592273160770179
    0.265700058953792029795712
    0.276326390168236932985068
    0.286899723215749152048332
    0.297418218547012757893882
    0.307880068029034016649000
    0.318283495860952262338992
    0.328626759459127427638914
    0.338908150310790248699499
    0.349125994795582757315695
    0.359278654974358972988254
    0.369364529344658637204124
    0.379382053562310320297300
    0.389329701128664204753628
    0.399205984042999234582144
    0.409009453419694044918239
    0.418738700069796075759558
    0.428392355046668455103604
    0.437969090155439536373130
    0.447467618426025319819411
    0.456886694549540304987442
    0.466225115277957539319705
    0.475481719786923675319682
    0.484655390001679655026703
    0.493745050886082136517092
    0.502749670694764894533266
    0.511668261188523099211697
    0.520499877813046537682747
    0.529243619841170429010070
    0.537898630478854431106614
    0.546464096935141688222533
    0.554939250456390260497539
    0.563323366325108955991688
    0.571615763823768395668684
    0.579815806163996030236782
    0.587922900381600743987037
    0.595936497197908576518189
    0.603856090847925922562622
    0.611681218875880289504687
    0.619411461898721260562292
    0.627046443338195690464736
    0.634585829122141313859706
    0.642029327355671841292946
    0.649376687962954222750275
    0.656627702300305046439084
    0.663782202741357985424868
    0.670840062235077784356887
    0.677801193837418472975629
    0.684665550217444285287115
    0.691433123138751138842000
    0.698103942917044475821896
    0.704678077854745777673723
    0.711155633653515131598938
    0.717536752805590846718625
    0.723821613964859289254273
    0.730010431298578831244359
    0.736103453820691090374864
    0.742100964707660486167111
    0.748003280597789559230994
    0.753810750874962507155164
    0.759523756937772996814901
    0.765142711454994534663544
    0.770668057608352532380083
    0.776100268323556715663465
    0.781439845490550711651092
    0.786687319173932540042657
    0.791843246814495351087002
    0.796908212422832128518725
    0.801882825765941237429626
    0.806767721547761677691787
    0.811563558584557736234438
    0.816271018976062450999077
    0.820890807273277941907934
    0.825423649643818267103596
    0.829870293035667064651115
    0.834231504340207880514292
    0.838508069555369803579790
    0.842700792949714869341221
    0.846810496228276697886304
    0.850838017700942042052444
    0.854784211454148381612389
    0.858649946526651453191925
    0.862436106090096697765226
    0.866143586635108082774537
    0.869773297163586659132690
    0.873326158387889589649984
    0.876803101937538279856830
    0.880205069574081699771868
    0.883533012414718050732089
    0.886787890165254649549837
    0.889970670362962317254718
    0.893082327629856715369185
    0.896123842936915012419506
    0.899096202879712030000041
    0.902000398965935653353894
    0.904837426915216837567545
    0.907608285971685037790485
    0.910313978229635380238406
    0.912955507972669409081356
    0.915533881026646830667193
    0.918050104126761367892733
    0.920505184299029669863949
    0.922900128256458230136523
    0.925235941810129484510736
    0.927513629295424719100128
    0.929734193013578152514172
    0.931898632688733592554243
    0.934007944940652436603893
    0.936063122773199513379509
    0.938065155078711378050909
    0.940015026158330197754595
    0.941913715258365323657307
    0.943762196122724061065830
    0.945561436561433041323207
    0.947312398035251987699776
    0.949016035256362570111835
    0.950673295805096476827758
    0.952285119762648810516483
    0.953852439359705454847226
    0.955376178640896168788291
    0.956857253144968859850497
    0.958296569600564774513511
    0.959695025637459232377443
    0.961053509513118027313721
    0.962372899854405729886811
    0.963654065414268855166142
    0.964897864843204212102907
    0.966105146475310727066976
    0.967276748128711635913826
    0.968413496920123165931304
    0.969516209093335679948252
    0.970585689861363727448927
    0.971622733262012538372566
    0.972628122026600200033799
    0.973602627461567070965916
    0.974547009342696901235481
    0.975462015821667639794134
    0.976348383344644007774283
    0.977206836582618593554779
    0.978038088373203471420329
    0.978842839673570150500483
    0.979621779524232013515387
    0.980375585023360294162452
    0.981104921311322055650339
    0.981810441565126558280198
    0.982492787002464827943096
    0.983152586895026146341339
    0.983790458590774563626243
    0.984407007544868370574912
    0.985002827358905745666562
    0.985578499828180497431188
    0.986134594996632938939331
    0.986671671219182443772211
    0.987190275231130125566791
    0.987690942224322340437041
    0.988174195929768317289394
    0.988640548706408159263284
    0.989090501635730714183733
    0.989524544621944366953582
    0.989943156497407646205095
    0.990346805133030645297762
    0.990735947553362618000491
    0.991111030056085706155210
    0.991472488335639574649461
    0.991820747610706752658708
    0.992156222755293694076721
    0.992479318433147959270642
    0.992790429235257469948358
    0.993089939820183484438217
    0.993378225056984767759469
    0.993655650170496375504198
    0.993922570888732519066544
    0.994179333592189118776836
    0.994426275464827868000969
    0.994663724646529912575485
    0.994892000386813583757223
    0.995111413199616997238347
    0.995322265018952734162069
    0.995524849355248241312063
    0.995719451452192015978668
    0.995906348443912066070672
    0.996085809512319547895015
    0.996258096044456873132539
    0.996423461789695933775340
    0.996582153016638410456033
    0.996734408669576397404104
    0.996880460524377788338765
    0.997020533343667014496115
    0.997154845031177801648948
    0.997283606785160610778704
    0.997407023250733340776017
    0.997525292671069695356701
    0.997638607037325344858751
    0.997747152237207641699493
    0.997851108202100171372239
    0.997950649052658834678793
    0.998045943242801457529124
    0.998137153702018108556548
    0.998224437975934368814823
    0.998307948365064739107359
    0.998387832061698186549948
    0.998464231284862520615845
    0.998537283413318848302089
    0.998607121116541786642636
    0.998673872483645407328131
    0.998737661150219051712021
    0.998798606423041184302075
    0.998856823402643348534653
    0.998912423103700050040183
    0.998965512573224019809696
    0.999016195006549802974103
    0.999064569861091978842036
    0.999110732967867545150889
    0.999154776640775095111632
    0.999196789783626380902110
    0.999236857994928693095374
    0.999275063670419193575791
    0.999311486103354921430255
    0.999346201582564648884856
    0.999379283488271099505731
    0.999410802385694255639232
    0.999440826116448578590456
    0.999469419887748945596554
    0.999496646359441974605568
    0.999522565728881163674247
    0.999547235813665918980236
    0.999570712132266086606323
    0.999593047982555041060436
    0.999614294518275720661921
    0.999634500823465239215587
    0.999653713984864847611602
    0.999671979162343070964282
    0.999689339657360809492885
    0.999705836979508067426713
    0.999721510911142766670001
    0.999736399570162813678909
    0.999750539470943221871744
    0.999763965583470650796009
    0.999776711390708210081766
    0.999788808944223793772524
    0.999800288918115561773568
    0.999811180661268472697860
    0.999821512247975999096039
    0.999831310526961324669729
    0.999840601168832436289035
    0.999849408712005584127087
    0.999857756607131593604098
    0.999865667260059475670860
    0.999873162073371699777589
    0.999880261486525369137321
    0.999886985014633373018311
    0.999893351285919388145981
    0.999899378077880363163096
    0.999905082352189848729210
    0.999910480288375233419033
    0.999915587316301614224693
    0.999920418147494672237463
    0.999924986805334540975777
    0.999929306654152248770470
    0.999933390427259889483441
    0.999937250253945229426789
    0.999940897685460994406321
    0.999944343720038601012541
    0.999947598826955602236751
    0.999950672969685610748981
    0.999953575628158945224767
    0.999956315820161717373451
    0.999958902121900541164316
    0.999961342687759502470105
    0.999963645269275478192029
    0.999965817233357340078774
    0.999967865579774021028779
    0.999969796957935861737626
    0.999971617682993094132439
    0.999973333751274756079605
    0.999974950855090770264459
    0.999976474396919359773184
    0.999977909503001414558627
    0.999979261036362867394040
    0.999980533609285585815045
    0.999981731595246738576625
    0.999982859140346051919802
    0.999983920174239833019164
    0.999984918420600105892450
    0.999985857407116679281056
    0.999986740475059447000171
    0.999987570788417709415870
    0.999988351342632800403966
    0.999989084972939807716761
    0.999989774362333686430315
    0.999990422049174585335565
    0.999991030434446735009890
    0.999991601788684784070191
    0.999992138258581016945169
    0.999992641873286442566995
    0.999993114550418308799710
    0.999993558101786172297790
    0.999993974238848237905028
    0.999994364577909275721057
    0.999994730645071027620088
    0.999995073880945628324028
    0.999995395645142189112255
    0.999995697220536324878170
    0.999995979817332047487635
    0.999996244576925100210857
    0.999996492575576469327953
    0.999996724827904479777092
    0.999996942290203561838538
    0.999997145863597465233101
    0.999997336397034395554135
    0.999997514690131255533768
    0.999997681495873890143584
    0.999997837523179959816750
    0.999997983439330800015059
    0.999998119872278367806604
    0.999998247412833126918517
    0.999998366616738481729930
    0.999998478006637137714638
    0.999998582073934540768369
    0.999998679280564330496742
    0.999998770060660532728832
    0.999998854822141014087435
    0.999998933948206526218906
    0.999999007798759479089598
    0.999999076711746401418634
    0.999999141004427871663589
    0.999999200974579534832405
    0.999999256901627658587254
    0.999999309047722526460751
    0.999999357658752816349255
    0.999999402965303968610622
    0.999999445183563409904602
    0.999999484516175366204968
    0.999999521153047871016725
    0.999999555272114452585247
    0.999999587040052866624547
    0.999999616612963128659530
    0.999999644137006992314701
    0.999999669749010916634964
    0.999999693577034466641037
    0.999999715740905996653838
    0.999999736352727375323111
    0.999999755517349424622676
    0.999999773332819662188394
    0.999999789890803857138683
    0.999999805276982833797809
    0.999999819571425885409310
    0.999999832848942090853798
    0.999999845179410761448597
    0.999999856628092181986012
    0.999999867255919750145400
    0.999999877119774561178120
    0.999999886272743430203347
    0.999999894764361292459493
    0.999999902640838872326778
    0.999999909945276464770342
    0.999999916717864627952817
    0.999999922996072543035871
    0.999999928814824756540487
    0.999999934206666981977303
    0.999999939201921600705774
    0.999999943828833467051722
    0.999999948113706589527419
    0.999999952081032228479841
    0.999999955753608920567185
    0.999999959152654912059634
    0.999999962297913456009131
    0.999999965207751402768258
    0.999999967899251489096719
    0.999999970388298708114035
    0.999999972689661120580137
    0.999999974817065447355071
    0.999999976783267763350693
    0.999999978600119594788978
    0.999999980278629704073472
    0.999999981829021830014495
    0.999999983260788635479157
    0.999999984582742099719981
    0.999999985803060578628974
    0.999999986929332742926881
    0.999999987968598591791738
    0.999999988927387727619661
    0.999999989811755066458970
    0.999999990627314148132540
    0.999999991379268200130508
    0.999999992072439099985541
    0.999999992711294372006456
    0.999999993299972345915102
    0.999999993842305597079599
    0.999999994341842780638679
    0.999999994801868964843021
    0.999999995225424562376994
    0.999999995615322952246180
    0.999999995974166879001692
    0.999999996304363710601733
    0.999999996608139631065173
    0.999999996887552839233372
    0.999999997144505820407811
    0.999999997380756753356393
    0.999999997597930111164948
    0.999999997797526510638154
    0.999999997980931861411821
    0.999999998149425862613257
    0.999999998304189891785759
    0.999999998446314327865434
    0.999999998576805347252390
    0.999999998696591229443244
    0.999999998806528206277959
    0.999999998907405886591731
    0.999999998999952285943071
    0.999999999084838489103913
    0.999999999162682971138542
    0.999999999234055601157792
    0.999999999299481351206210
    0.999999999359443731215952
    0.999999999414387969535759
    0.999999999464723957210342
    0.999999999510828972939411
    0.999999999553050204480830
    0.999999999591707081174197
    0.999999999627093431244556
    0.999999999659479476596644
    0.999999999689113676923764
    0.999999999716224434128131
    0.999999999741021667277623
    0.999999999763698267603729
    0.999999999784431442373954
    0.999999999803383955845711
    0.999999999820705274925103
    0.999999999836532626610029
    0.999999999850991973790366
    0.999999999864198915505960
    0.999999999876259517323697
    0.999999999887271077085832
    0.999999999897322830900966
    0.999999999906496603894840
    0.999999999914867409908580
    0.999999999922504004025582
    0.999999999929469391523360
    0.999999999935821296581860
    0.999999999941612593833703
    0.999999999946891705613252
    0.999999999951702967549089
    0.999999999956086964947412
    0.999999999960080842230859
    0.999999999963718587527495
    0.999999999967031294347156
    0.999999999970047402136203
    0.999999999972792917366275
    0.999999999975291616686970
    0.999999999977565233555991
    0.999999999979633629652374
    0.999999999981514952278515
    0.999999999983225778864110
    0.999999999984781249599477
    0.999999999986195189146334
    0.999999999987480218300757
    0.999999999988647856415078
    0.999999999989708615322670
    0.999999999990672085451468
    0.999999999991547014758366
    0.999999999992341381066975
    0.999999999993062458345374
    0.999999999993716877418075
    0.999999999994310681567322
    0.999999999994849377442675
    0.999999999995337981664472
    0.999999999995781063475994
    0.999999999996182783770717
    0.999999999996546930794861
    0.999999999996876952801260
    0.999999999997175987908301
    0.999999999997446891397149
    0.999999999997692260661541
    0.999999999997914458007001
    0.999999999998115631480261
    0.999999999998297733894900
    0.999999999998462540205572]';
endfunction

[Xr,Yr]=erf_ref();
y=erf(Xr);
assert_checkalmostequal(Yr,y,sqrt(%eps),sqrt(%eps));

// Tests are from faddeeva code:

assert_checkalmostequal(erf(1 + 2*%i), -0.5366435657785650339917955593141927494421 + -5.049143703447034669543036958614140565553*%i, 1.e-10);
assert_checkalmostequal(erf(-1 + 2*%i), 0.5366435657785650339917955593141927494421 + -5.049143703447034669543036958614140565553*%i, 1.e-10);
assert_checkalmostequal(erf(1 + -2*%i), -0.5366435657785650339917955593141927494421 + 5.049143703447034669543036958614140565553*%i, 1.e-10);
assert_checkalmostequal(erf(-1 + -2*%i), 0.5366435657785650339917955593141927494421 + 5.049143703447034669543036958614140565553*%i, 1.e-10);
assert_checkalmostequal(erf(9 + -28*%i), 0.3359473673830576996788000505817956637777e304 + -0.1999896139679880888755589794455069208455e304*%i, 1.e-10);
assert_checkalmostequal(erf(21 + -33*%i), 0.3584459971462946066523939204836760283645e278 + 0.3818954885257184373734213077678011282505e280*%i, 1.e-10);
assert_checkalmostequal(erf(1e3 + 1e3*%i), 0.9996020422657148639102150147542224526887 + 0.00002801044116908227889681753993542916894856*%i, 1.e-10);
assert_checkalmostequal(erf(-3001 + -1000*%i), -1 + 0*%i, 1.e-10);
assert_checkalmostequal(erf(1e160 + -1e159*%i), 1 + 0*%i, 1.e-10);
assert_checkalmostequal(erf(5.1e-3 + 1e-8*%i), 0.005754683859034800134412990541076554934877 + 0.1128349818335058741511924929801267822634e-7*%i, 1.e-10);
assert_checkalmostequal(erf(-4.9e-3 + 4.95e-3*%i), -0.005529149142341821193633460286828381876955 + 0.005585388387864706679609092447916333443570*%i, 1.e-10);
assert_checkalmostequal(erf(4.9e-3 + 0.5*%i), 0.007099365669981359632319829148438283865814 + 0.6149347012854211635026981277569074001219*%i, 1.e-10);
assert_checkalmostequal(erf(4.9e-4 + -0.5e1*%i), 0.3981176338702323417718189922039863062440e8 + -0.8298176341665249121085423917575122140650e10*%i, 1.e-10);
assert_checkalmostequal(erf(-4.9e-5 + -0.5e2*%i), complex(-%inf, -%inf), 1.e-10);
assert_checkalmostequal(erf(5.1e-3 + 0.5*%i), 0.007389128308257135427153919483147229573895 + 0.6149332524601658796226417164791221815139*%i, 1.e-10);
assert_checkalmostequal(erf(5.1e-4 + -0.5e1*%i), 0.4143671923267934479245651547534414976991e8 + -0.8298168216818314211557046346850921446950e10*%i, 1.e-10);
assert_checkalmostequal(erf(-5.1e-5 + -0.5e2*%i), complex(-%inf, -%inf), 1.e-10);
assert_checkalmostequal(erf(1e-6 + 2e-6*%i), 0.1128379167099649964175513742247082845155e-5 + 0.2256758334191777400570377193451519478895e-5*%i, 1.e-10);
assert_checkalmostequal(erf(0 + 2e-6*%i), 0 + 0.2256758334194034158904576117253481476197e-5*%i, 1.e-10);
assert_checkalmostequal(erf(0 + 2*%i), 0 + 18.56480241457555259870429191324101719886*%i, 1.e-10);
assert_checkalmostequal(erf(0 + 20*%i), 0 + 0.1474797539628786202447733153131835124599e173*%i, 1.e-10);
assert_checkalmostequal(erf(0 + 200*%i), complex(0, %inf), 1.e-10);
assert_checkalmostequal(erf(%inf + 0*%i), 1 + 0*%i, 1.e-10);
assert_checkalmostequal(erf(-%inf + 0*%i), -1 + 0*%i, 1.e-10);
assert_checkalmostequal(erf(0 + %inf*%i), complex(%nan, %nan), 1.e-10);
assert_checkalmostequal(erf(0 + -%inf*%i), complex(%nan, %nan), 1.e-10);
assert_checkalmostequal(erf(%inf + %inf*%i), %nan + %nan*%i, 1.e-10);
assert_checkalmostequal(erf(%inf + -%inf*%i), %nan + %nan*%i, 1.e-10);
assert_checkalmostequal(erf(%nan + %nan*%i), %nan + %nan*%i, 1.e-10);
assert_checkalmostequal(erf(%nan + 0*%i), %nan + 0*%i, 1.e-10);
assert_checkalmostequal(erf(0 + %nan*%i), 0 + %nan*%i, 1.e-10);
assert_checkalmostequal(erf(%nan + %inf*%i), %nan + %nan*%i, 1.e-10);
assert_checkalmostequal(erf(%inf + %nan*%i), %nan + %nan*%i, 1.e-10);
assert_checkalmostequal(erf(1e-3 + %nan*%i), %nan + %nan*%i, 1.e-10);
assert_checkalmostequal(erf(7e-2 + 7e-2*%i), 0.07924380404615782687930591956705225541145 + 0.07872776218046681145537914954027729115247*%i, 1.e-10);
assert_checkalmostequal(erf(7e-2 + -7e-4*%i), 0.07885775828512276968931773651224684454495 + -0.0007860046704118224342390725280161272277506*%i, 1.e-10);
assert_checkalmostequal(erf(-9e-2 + 7e-4*%i), -0.1012806432747198859687963080684978759881 + 0.0007834934747022035607566216654982820299469*%i, 1.e-10);
assert_checkalmostequal(erf(-9e-2 + 9e-2*%i), -0.1020998418798097910247132140051062512527 + 0.1010030778892310851309082083238896270340*%i, 1.e-10);
assert_checkalmostequal(erf(-7e-4 + 9e-2*%i), -0.0007962891763147907785684591823889484764272 + 0.1018289385936278171741809237435404896152*%i, 1.e-10);
assert_checkalmostequal(erf(7e-2 + 0.9e-2*%i), 0.07886408666470478681566329888615410479530 + 0.01010604288780868961492224347707949372245*%i, 1.e-10);
assert_checkalmostequal(erf(7e-2 + 1.1e-2*%i), 0.07886723099940260286824654364807981336591 + 0.01235199327873258197931147306290916629654*%i, 1.e-10);

assert_checkerror("erf(''foo'')",[],999);
assert_checkerror("erf(sparse([1,2;4,5;3,10],[1,2,3]))",[],999);
