// ==========================================================================
//                 SeqAn - The Library for Sequence Analysis
// ==========================================================================
// Copyright (c) 2006-2010, Knut Reinert, FU Berlin
// All rights reserved.
//
// Redistribution and use in source and binary forms, with or without
// modification, are permitted provided that the following conditions are met:
//
//     * Redistributions of source code must retain the above copyright
//       notice, this list of conditions and the following disclaimer.
//     * Redistributions in binary form must reproduce the above copyright
//       notice, this list of conditions and the following disclaimer in the
//       documentation and/or other materials provided with the distribution.
//     * Neither the name of Knut Reinert or the FU Berlin nor the names of
//       its contributors may be used to endorse or promote products derived
//       from this software without specific prior written permission.
//
// THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
// AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
// IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
// ARE DISCLAIMED. IN NO EVENT SHALL KNUT REINERT OR THE FU BERLIN BE LIABLE
// FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
// DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
// SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
// CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
// LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
// OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH
// DAMAGE.
//
// ==========================================================================


#ifndef SEQAN_HEADER_MISC_GENERATED_FORWARDS_H 
#define SEQAN_HEADER_MISC_GENERATED_FORWARDS_H 

//////////////////////////////////////////////////////////////////////////////
// NOTE: This file is automatically generated by build_forwards.py
//       Do not edit this file manually!
//////////////////////////////////////////////////////////////////////////////


//////////////////////////////////////////////////////////////////////////////
// CLASSES
//////////////////////////////////////////////////////////////////////////////

namespace SEQAN_NAMESPACE_MAIN {

//____________________________________________________________________________
// CommandLineOption

class CommandLineOption;       	// "seqan-1.3.1/seqan/misc/misc_cmdparser.h"(123)

//____________________________________________________________________________
// CommandLineParser

class CommandLineParser;       	// "seqan-1.3.1/seqan/misc/misc_cmdparser.h"(636)

//____________________________________________________________________________
// Dequeue

template <typename TValue, typename TSpec > class Dequeue;       	// "seqan-1.3.1/seqan/misc/misc_dequeue.h"(58)

//____________________________________________________________________________
// EditEnvironment

template <typename TDistanceSpec, unsigned DISTANCE > struct EditEnvironment;       	// "seqan-1.3.1/seqan/misc/edit_environment.h"(40)

//____________________________________________________________________________
// Enumerator

template <typename TObject, typename TSpec > class Enumerator;       	// "seqan-1.3.1/seqan/misc/edit_environment.h"(62)

//____________________________________________________________________________
// EnumeratorHammingModifier_

template <typename TSize> struct EnumeratorHammingModifier_;       	// "seqan-1.3.1/seqan/misc/edit_environment.h"(139)

//____________________________________________________________________________
// EnumeratorLevenshteinModifier_

template <typename TSize> struct EnumeratorLevenshteinModifier_;       	// "seqan-1.3.1/seqan/misc/edit_environment.h"(402)

//____________________________________________________________________________
// IntervalAndCargo

template <typename TValue , typename TCargo > class IntervalAndCargo;       	// "seqan-1.3.1/seqan/misc/misc_interval_tree.h"(65)

//____________________________________________________________________________
// IntervalTree

template <typename TValue, typename TCargo> class IntervalTree;       	// "seqan-1.3.1/seqan/misc/misc_interval_tree.h"(297)

//____________________________________________________________________________
// IntervalTreeNode

template <typename TInterval, typename TSpec> class IntervalTreeNode;       	// "seqan-1.3.1/seqan/misc/misc_interval_tree.h"(214)

//____________________________________________________________________________
// ListType

template <typename T> struct ListType;       	// "seqan-1.3.1/seqan/misc/misc_interval_tree.h"(792)

//____________________________________________________________________________
// MersenneBuffer_

template <typename T > struct MersenneBuffer_;       	// "seqan-1.3.1/seqan/misc/misc_random.h"(69)

//____________________________________________________________________________
// Object

template <typename TElement> struct Object;       	// "seqan-1.3.1/seqan/misc/misc_base.h"(68)

//____________________________________________________________________________
// OptionType

struct OptionType;       	// "seqan-1.3.1/seqan/misc/misc_cmdparser.h"(96)

//____________________________________________________________________________
// PointAndCargo

template <typename TValue, typename TCargo> class PointAndCargo;       	// "seqan-1.3.1/seqan/misc/misc_interval_tree.h"(130)

//____________________________________________________________________________
// PriorityHeap

struct PriorityHeap;       	// "seqan-1.3.1/seqan/misc/priority_type_base.h"(43)

//____________________________________________________________________________
// PriorityType

template <typename TValue , typename TLess , typename TSpec > class PriorityType;       	// "seqan-1.3.1/seqan/misc/priority_type_base.h"(62)

//____________________________________________________________________________
// SVGFile

struct SVGFile;       	// "seqan-1.3.1/seqan/misc/misc_svg.h"(44)

//____________________________________________________________________________
// Set

template <typename TKey> struct Set;       	// "seqan-1.3.1/seqan/misc/misc_set.h"(562)

//____________________________________________________________________________
// SetLess_

template <typename TElement> struct SetLess_;       	// "seqan-1.3.1/seqan/misc/misc_set.h"(379)

//____________________________________________________________________________
// SetObjVector_

template <typename TSet> struct SetObjVector_;       	// "seqan-1.3.1/seqan/misc/misc_set.h"(83)

//____________________________________________________________________________
// SetSetVector_

template <typename TSet> struct SetSetVector_;       	// "seqan-1.3.1/seqan/misc/misc_set.h"(68)

//____________________________________________________________________________
// StoreIntervals

struct StoreIntervals;       	// "seqan-1.3.1/seqan/misc/misc_interval_tree.h"(187)

//____________________________________________________________________________
// StorePointsOnly

struct StorePointsOnly;       	// "seqan-1.3.1/seqan/misc/misc_interval_tree.h"(183)

//____________________________________________________________________________
// TagComputeCenter_

struct TagComputeCenter_;       	// "seqan-1.3.1/seqan/misc/misc_interval_tree.h"(426)

//____________________________________________________________________________
// TagRandomCenter_

struct TagRandomCenter_;       	// "seqan-1.3.1/seqan/misc/misc_interval_tree.h"(437)

//____________________________________________________________________________
// VectorSetIterator_

struct VectorSetIterator_;       	// "seqan-1.3.1/seqan/misc/misc_set.h"(173)

//____________________________________________________________________________
// VectorSetKeySize_

template <typename TElement> struct VectorSetKeySize_;       	// "seqan-1.3.1/seqan/misc/misc_set.h"(62)

//____________________________________________________________________________
// VectorSet_

template <typename TElement, typename TSpec> class VectorSet_;       	// "seqan-1.3.1/seqan/misc/misc_set.h"(55)
template <typename TElement , typename TSpec > class VectorSet_;       	// "seqan-1.3.1/seqan/misc/misc_set.h"(103)

} //namespace SEQAN_NAMESPACE_MAIN
//////////////////////////////////////////////////////////////////////////////

namespace seqan {

//____________________________________________________________________________
// DynamicWidth_

struct DynamicWidth_;       	// "seqan-1.3.1/seqan/misc/misc_long_word.h"(68)

//____________________________________________________________________________
// LongWord

template <typename TSpec> struct LongWord;       	// "seqan-1.3.1/seqan/misc/misc_long_word.h"(53)

//____________________________________________________________________________
// LongWordBitProxy

template <typename TWord, typename TSpec> struct LongWordBitProxy;       	// "seqan-1.3.1/seqan/misc/misc_long_word.h"(57)

//____________________________________________________________________________
// StaticWidth

template <unsigned LENGTH> struct StaticWidth;       	// "seqan-1.3.1/seqan/misc/misc_long_word.h"(73)

//____________________________________________________________________________
// _NativeWideWidth

struct _NativeWideWidth;       	// "seqan-1.3.1/seqan/misc/misc_long_word.h"(64)

//____________________________________________________________________________
// _NativeWidth

struct _NativeWidth;       	// "seqan-1.3.1/seqan/misc/misc_long_word.h"(60)

} //namespace seqan


//////////////////////////////////////////////////////////////////////////////
// TYPEDEFS
//////////////////////////////////////////////////////////////////////////////

namespace SEQAN_NAMESPACE_MAIN {

//____________________________________________________________________________
// ComputeCenter

typedef Tag<TagComputeCenter_> const ComputeCenter;       	// "seqan-1.3.1/seqan/misc/misc_interval_tree.h"(427)

//____________________________________________________________________________
// RandomCenter

typedef Tag<TagRandomCenter_> const RandomCenter;       	// "seqan-1.3.1/seqan/misc/misc_interval_tree.h"(438)

//____________________________________________________________________________
// VectorSetIterator__

typedef Tag<VectorSetIterator_> VectorSetIterator__;       	// "seqan-1.3.1/seqan/misc/misc_set.h"(174)

} //namespace SEQAN_NAMESPACE_MAIN
//////////////////////////////////////////////////////////////////////////////

namespace seqan {

//____________________________________________________________________________
// DynamicWidth

typedef Tag<DynamicWidth_> DynamicWidth;       	// "seqan-1.3.1/seqan/misc/misc_long_word.h"(69)

//____________________________________________________________________________
// NativeWideWidth

typedef Tag<_NativeWideWidth> NativeWideWidth;       	// "seqan-1.3.1/seqan/misc/misc_long_word.h"(65)

//____________________________________________________________________________
// NativeWidth

typedef Tag<_NativeWidth> NativeWidth;       	// "seqan-1.3.1/seqan/misc/misc_long_word.h"(61)

} //namespace seqan


//////////////////////////////////////////////////////////////////////////////
// FUNCTIONS
//////////////////////////////////////////////////////////////////////////////

namespace SEQAN_NAMESPACE_MAIN {

//____________________________________________________________________________
// _adjustHeapTowardLeaves

template <typename TValue, typename TLess, typename TSize> inline void _adjustHeapTowardLeaves( PriorityType<TValue, TLess, PriorityHeap> & me, TValue element, TSize h, TSize i );       	// "seqan-1.3.1/seqan/misc/priority_type_heap.h"(288)

//____________________________________________________________________________
// _adjustHeapTowardRoot

template <typename TValue, typename TLess, typename TSize> inline void _adjustHeapTowardRoot( PriorityType<TValue, TLess, PriorityHeap> & me, TValue const & element, TSize h );       	// "seqan-1.3.1/seqan/misc/priority_type_heap.h"(236)

//____________________________________________________________________________
// _alignNeedlemanWunschMatrix

template <typename TStringSet, typename TTrace, typename TIndexPair> void _alignNeedlemanWunschMatrix(SVGFile& svg, TStringSet const& str, TTrace const& trace, TIndexPair const&);       	// "seqan-1.3.1/seqan/misc/misc_svg.h"(399)

//____________________________________________________________________________
// _alignTracePrint

template <typename TStringSet, typename TId, typename TPos, typename TTraceValue> inline void _alignTracePrint(SVGFile& svg, TStringSet const&, TId const, TPos pos1, TId const, TPos pos2, TPos const segLen, TTraceValue const tv);       	// "seqan-1.3.1/seqan/misc/misc_svg.h"(448)

//____________________________________________________________________________
// _allMandatorySet

inline bool _allMandatorySet(CommandLineParser const & me);       	// "seqan-1.3.1/seqan/misc/misc_cmdparser.h"(1169)

//____________________________________________________________________________
// _appendIntervalTreeNodeLists

template <typename TInterval> void _appendIntervalTreeNodeLists(IntervalTreeNode<TInterval,StoreIntervals> & knot,TInterval & interval);       	// "seqan-1.3.1/seqan/misc/misc_interval_tree.h"(729)
template <typename TInterval> void _appendIntervalTreeNodeLists(IntervalTreeNode<TInterval,StorePointsOnly> & knot,TInterval & interval);       	// "seqan-1.3.1/seqan/misc/misc_interval_tree.h"(756)

//____________________________________________________________________________
// _assignOptionValue

template <typename TErrorStream> bool _assignOptionValue(CommandLineParser & me, unsigned option_index, CharString const & val, unsigned argNo, TErrorStream & estream);       	// "seqan-1.3.1/seqan/misc/misc_cmdparser.h"(1194)
template <typename TErrorStream> inline bool _assignOptionValue(CommandLineParser & me, unsigned option_index, CharString const & val, TErrorStream & estream);       	// "seqan-1.3.1/seqan/misc/misc_cmdparser.h"(1235)

//____________________________________________________________________________
// _calcIntervalTreeNodeCenterLeft

template <typename TIntervals, typename TValue> TValue _calcIntervalTreeNodeCenterLeft(TIntervals & intervals, TValue &, TValue &, Tag<TagRandomCenter_> const);       	// "seqan-1.3.1/seqan/misc/misc_interval_tree.h"(1156)

//____________________________________________________________________________
// _calcIntervalTreeNodeCenterRight

template <typename TIntervals, typename TValue> TValue _calcIntervalTreeNodeCenterRight(TIntervals & intervals, TValue &, TValue &, Tag<TagRandomCenter_> const);       	// "seqan-1.3.1/seqan/misc/misc_interval_tree.h"(1168)

//____________________________________________________________________________
// _calcIntervalTreeRootCenter

template <typename TIntervals> typename Value<typename Value<TIntervals>::Type>::Type _calcIntervalTreeRootCenter(TIntervals & intervals);       	// "seqan-1.3.1/seqan/misc/misc_interval_tree.h"(1180)

//____________________________________________________________________________
// _convertOptionValue

inline bool _convertOptionValue(CommandLineOption const & opt, bool & dst, CharString const & src);       	// "seqan-1.3.1/seqan/misc/misc_cmdparser.h"(1458)
inline bool _convertOptionValue(CommandLineOption const & opt, int & dst, CharString const & src);       	// "seqan-1.3.1/seqan/misc/misc_cmdparser.h"(1466)
inline bool _convertOptionValue(CommandLineOption const & opt, unsigned int & dst, CharString const & src);       	// "seqan-1.3.1/seqan/misc/misc_cmdparser.h"(1474)
inline bool _convertOptionValue(CommandLineOption const & opt, __int64 & dst, CharString const & src);       	// "seqan-1.3.1/seqan/misc/misc_cmdparser.h"(1482)
inline bool _convertOptionValue(CommandLineOption const & opt, __uint64 & dst, CharString const & src);       	// "seqan-1.3.1/seqan/misc/misc_cmdparser.h"(1490)
inline bool _convertOptionValue(CommandLineOption const & opt, float & dst, CharString const & src);       	// "seqan-1.3.1/seqan/misc/misc_cmdparser.h"(1498)
inline bool _convertOptionValue(CommandLineOption const & opt, double & dst, CharString const & src);       	// "seqan-1.3.1/seqan/misc/misc_cmdparser.h"(1506)
template <typename TObject> inline bool _convertOptionValue(CommandLineOption const & opt, TObject & dst, CharString const & src);       	// "seqan-1.3.1/seqan/misc/misc_cmdparser.h"(1515)

//____________________________________________________________________________
// _copyHeapElement

template <typename TValue, typename TLess, typename TSize> inline void _copyHeapElement (PriorityType<TValue, TLess, PriorityHeap> & me, TSize i, TSize & h);       	// "seqan-1.3.1/seqan/misc/priority_type_heap.h"(157)
template <typename TValue, typename TLess, typename TSize> inline void _copyHeapElement (PriorityType<TValue, TLess, PriorityHeap> & me, TValue const & element, TSize h);       	// "seqan-1.3.1/seqan/misc/priority_type_heap.h"(167)

//____________________________________________________________________________
// _createIntervalTree

template <typename TGraph, typename TPropertyMap, typename TIntervalPointer, typename TValue> void _createIntervalTree(TGraph & g, TPropertyMap & pm, String<TIntervalPointer*> & intervals, typename VertexDescriptor<TGraph>::Type & knot, TValue, TValue center, typename VertexDescriptor<TGraph>::Type len, Tag<TagComputeCenter_> const tag);       	// "seqan-1.3.1/seqan/misc/misc_interval_tree.h"(956)
template <typename TGraph, typename TPropertyMap, typename TSpec, typename TInterval, typename TValue> void _createIntervalTree(TGraph & g, TPropertyMap & pm, String<TInterval*> & intervals, typename VertexDescriptor<TGraph>::Type & knot, TValue last_center, TValue center, typename VertexDescriptor<TGraph>::Type len, Tag<TSpec> const tag);       	// "seqan-1.3.1/seqan/misc/misc_interval_tree.h"(1055)

//____________________________________________________________________________
// _dataHost

template <typename TText, typename TSpec> inline Holder<TText> & _dataHost(Enumerator<TText, TSpec> &enumerator);       	// "seqan-1.3.1/seqan/misc/edit_environment.h"(125)
template <typename TText, typename TSpec> inline Holder<TText> const & _dataHost(Enumerator<TText, TSpec> const &enumerator);       	// "seqan-1.3.1/seqan/misc/edit_environment.h"(130)

//____________________________________________________________________________
// _getOptionValue

inline CharString const & _getOptionValue(CommandLineParser const & me, unsigned option_index, unsigned argNo);       	// "seqan-1.3.1/seqan/misc/misc_cmdparser.h"(1438)
inline CharString const & _getOptionValue(CommandLineParser const & me, unsigned option_index);       	// "seqan-1.3.1/seqan/misc/misc_cmdparser.h"(1450)

//____________________________________________________________________________
// _getOptionValues

inline String<CharString> const & _getOptionValues(CommandLineParser const & me, unsigned option_index);       	// "seqan-1.3.1/seqan/misc/misc_cmdparser.h"(1428)

//____________________________________________________________________________
// _greater_compI2_ITree

template <typename TPair> bool _greater_compI2_ITree(TPair const& p1, TPair const& p2);       	// "seqan-1.3.1/seqan/misc/misc_interval_tree.h"(698)

//____________________________________________________________________________
// _isDigit

template <typename TChar> inline bool _isDigit(TChar const c);       	// "seqan-1.3.1/seqan/misc/misc_cmdparser.h"(53)

//____________________________________________________________________________
// _isDouble

template <typename TString> inline bool _isDouble(TString const s);       	// "seqan-1.3.1/seqan/misc/misc_cmdparser.h"(60)

//____________________________________________________________________________
// _isInt

template <typename TString> inline bool _isInt(TString const s);       	// "seqan-1.3.1/seqan/misc/misc_cmdparser.h"(81)

//____________________________________________________________________________
// _less_compI1_ITree

template <typename TPair> bool _less_compI1_ITree(TPair const& p1, TPair const& p2);       	// "seqan-1.3.1/seqan/misc/misc_interval_tree.h"(691)

//____________________________________________________________________________
// _makePointerInterval

template <typename TIntervals, typename TIntervalPointers> void _makePointerInterval(TIntervals & intervals,TIntervalPointers & interval_pointers);       	// "seqan-1.3.1/seqan/misc/misc_interval_tree.h"(1131)

//____________________________________________________________________________
// _parseAppName

inline CharString _parseAppName(CharString const & candidate);       	// "seqan-1.3.1/seqan/misc/misc_cmdparser.h"(1179)

//____________________________________________________________________________
// _printContig

template <typename TFormatTag, typename TContigGaps, typename TContigName> inline void _printContig( SVGFile &svg, Tag<TFormatTag> const &format, AlignedReadLayout &, TContigGaps &contigGaps, TContigName const &contigName);       	// "seqan-1.3.1/seqan/misc/misc_svg.h"(210)

//____________________________________________________________________________
// _printRead

template <typename TFormatTag, typename TContigGaps, typename TReadGaps, typename TAlignedRead, typename TLine> inline void _printRead( SVGFile &svg, Tag<TFormatTag> const &, AlignedReadLayout &layout, TContigGaps &contigGaps, TReadGaps &readGaps, TAlignedRead &alignedRead, TLine line);       	// "seqan-1.3.1/seqan/misc/misc_svg.h"(263)

//____________________________________________________________________________
// _printStringSet

template <typename TStringSet, typename TStream> inline void _printStringSet(TStringSet const & set, TStream & target);       	// "seqan-1.3.1/seqan/misc/misc_cmdparser.h"(924)

//____________________________________________________________________________
// _setIntervalTreeNode

template <typename TValue, typename TInterval> void _setIntervalTreeNode(IntervalTreeNode<TInterval,StoreIntervals> & knot,TValue center,TInterval & interval);       	// "seqan-1.3.1/seqan/misc/misc_interval_tree.h"(717)
template <typename TValue, typename TInterval> void _setIntervalTreeNode(IntervalTreeNode<TInterval,StorePointsOnly> & knot,TValue center,TInterval & interval);       	// "seqan-1.3.1/seqan/misc/misc_interval_tree.h"(742)

//____________________________________________________________________________
// _streamPut

template <typename TChar> inline void _streamPut(SVGFile & svg, TChar character);       	// "seqan-1.3.1/seqan/misc/misc_svg.h"(183)

//____________________________________________________________________________
// _title

template <typename TStream> inline void _title(CommandLineParser const & me, TStream & target);       	// "seqan-1.3.1/seqan/misc/misc_cmdparser.h"(965)

//____________________________________________________________________________
// _usage

template <typename TStream> inline void _usage(CommandLineParser const & me, TStream & target);       	// "seqan-1.3.1/seqan/misc/misc_cmdparser.h"(935)

//____________________________________________________________________________
// _writeOptName

template <typename TStream> inline void _writeOptName(TStream & target, CommandLineOption const & me);       	// "seqan-1.3.1/seqan/misc/misc_cmdparser.h"(594)

//____________________________________________________________________________
// addArgumentText

inline CommandLineOption addArgumentText(CommandLineOption const & opt, CharString const & text);       	// "seqan-1.3.1/seqan/misc/misc_cmdparser.h"(261)

//____________________________________________________________________________
// addHelpLine

template <typename TString> inline void addHelpLine(CommandLineParser & me, TString const & line);       	// "seqan-1.3.1/seqan/misc/misc_cmdparser.h"(776)

//____________________________________________________________________________
// addInterval

template <typename TGraph, typename TPropertyMap, typename TInterval> void addInterval(TGraph & g, TPropertyMap & pm, TInterval interval);       	// "seqan-1.3.1/seqan/misc/misc_interval_tree.h"(1223)
template <typename TValue, typename TCargo, typename TInterval> void addInterval(IntervalTree<TValue,TCargo> & itree, TInterval interval);       	// "seqan-1.3.1/seqan/misc/misc_interval_tree.h"(1322)
template <typename TValue, typename TCargo> void addInterval(IntervalTree<TValue,TCargo> & itree, TValue begin, TValue end, TCargo cargo);       	// "seqan-1.3.1/seqan/misc/misc_interval_tree.h"(1341)
template <typename TValue, typename TCargo> void addInterval(IntervalTree<TValue,TCargo> & itree, TValue begin, TValue end);       	// "seqan-1.3.1/seqan/misc/misc_interval_tree.h"(1360)

//____________________________________________________________________________
// addLine

template <typename TString> inline void addLine(CommandLineParser & me, TString const & line);       	// "seqan-1.3.1/seqan/misc/misc_cmdparser.h"(756)

//____________________________________________________________________________
// addOption

inline void addOption(CommandLineParser & me, CommandLineOption const & opt);       	// "seqan-1.3.1/seqan/misc/misc_cmdparser.h"(715)

//____________________________________________________________________________
// addSection

template <typename TString> inline void addSection(CommandLineParser & me, TString const & line);       	// "seqan-1.3.1/seqan/misc/misc_cmdparser.h"(796)

//____________________________________________________________________________
// addTitleLine

template <typename TString> inline void addTitleLine(CommandLineParser & me, TString const & line);       	// "seqan-1.3.1/seqan/misc/misc_cmdparser.h"(817)

//____________________________________________________________________________
// addUsageLine

inline void addUsageLine(CommandLineParser & me, CharString const & line);       	// "seqan-1.3.1/seqan/misc/misc_cmdparser.h"(858)

//____________________________________________________________________________
// addVersionLine

template <typename TString> inline void addVersionLine(CommandLineParser & me, TString const & line);       	// "seqan-1.3.1/seqan/misc/misc_cmdparser.h"(837)

//____________________________________________________________________________
// adjustTop

template <typename TValue, typename TLess> inline void adjustTop (PriorityType<TValue, TLess, PriorityHeap> & me);       	// "seqan-1.3.1/seqan/misc/priority_type_heap.h"(185)

//____________________________________________________________________________
// argumentCount

inline Size<String<CharString> >::Type argumentCount(CommandLineParser const & me);       	// "seqan-1.3.1/seqan/misc/misc_cmdparser.h"(1715)

//____________________________________________________________________________
// argumentText

inline CharString argumentText(CommandLineOption const & me);       	// "seqan-1.3.1/seqan/misc/misc_cmdparser.h"(563)

//____________________________________________________________________________
// atBegin

template <typename TObject, unsigned DISTANCE > inline void atBegin(Iter<Enumerator<TObject, EditEnvironment<HammingDistance, DISTANCE> >, Standard> const & it);       	// "seqan-1.3.1/seqan/misc/edit_environment.h"(253)
template <typename TObject, unsigned DISTANCE > inline bool atBegin(Iter<Enumerator<TObject, EditEnvironment<HammingDistance, DISTANCE> >, Standard> & it);       	// "seqan-1.3.1/seqan/misc/edit_environment.h"(261)

//____________________________________________________________________________
// atEnd

template <typename TObject, unsigned DISTANCE > inline bool atEnd(Iter<Enumerator<TObject, EditEnvironment<HammingDistance, DISTANCE> >, Standard> const & it);       	// "seqan-1.3.1/seqan/misc/edit_environment.h"(283)
template <typename TObject, unsigned DISTANCE > inline bool atEnd(Iter<Enumerator<TObject, EditEnvironment<HammingDistance, DISTANCE> >, Standard> & it);       	// "seqan-1.3.1/seqan/misc/edit_environment.h"(299)
template <typename TSet> inline bool atEnd(Iter<TSet, VectorSetIterator__> const &a);       	// "seqan-1.3.1/seqan/misc/misc_set.h"(335)

//____________________________________________________________________________
// back

template <typename TValue, typename TSpec> inline TValue & back(Dequeue<TValue, TSpec> &me);       	// "seqan-1.3.1/seqan/misc/misc_dequeue.h"(184)
template <typename TValue, typename TSpec> inline TValue const & back(Dequeue<TValue, TSpec> const &me);       	// "seqan-1.3.1/seqan/misc/misc_dequeue.h"(191)

//____________________________________________________________________________
// begin

template <typename TObject, typename TSpec > inline Iter< Enumerator<TObject, TSpec>, Standard > begin(Enumerator<TObject, TSpec> &enumerator, Standard);       	// "seqan-1.3.1/seqan/misc/edit_environment.h"(754)
template <typename TObject, typename TSpec > inline Iter< Enumerator<TObject, TSpec>, Standard > begin(Enumerator<TObject, TSpec> const &enumerator, Standard);       	// "seqan-1.3.1/seqan/misc/edit_environment.h"(759)
template <typename TElement, typename TSpec> inline typename Iterator< VectorSet_<TElement, TSpec> >::Type begin(VectorSet_<TElement, TSpec> &set);       	// "seqan-1.3.1/seqan/misc/misc_set.h"(294)
template <typename TElement, typename TSpec> inline typename Iterator< VectorSet_<TElement, TSpec> const>::Type begin(VectorSet_<TElement, TSpec> const &set);       	// "seqan-1.3.1/seqan/misc/misc_set.h"(300)

//____________________________________________________________________________
// cargo

template <typename TValue, typename TCargo> TCargo & cargo(IntervalAndCargo<TValue,TCargo> & interval);       	// "seqan-1.3.1/seqan/misc/misc_interval_tree.h"(542)
template <typename TValue, typename TCargo> TCargo & cargo(PointAndCargo<TValue,TCargo> & point);       	// "seqan-1.3.1/seqan/misc/misc_interval_tree.h"(649)

//____________________________________________________________________________
// clear

template <typename TValue, typename TLess> inline void clear (PriorityType<TValue,TLess, PriorityHeap> & me);       	// "seqan-1.3.1/seqan/misc/priority_type_heap.h"(95)
template <typename TValue, typename TSpec> inline void clear(Dequeue<TValue, TSpec> &me);       	// "seqan-1.3.1/seqan/misc/misc_dequeue.h"(126)
template <typename TValue, typename TSpec> finline void clear(VectorSet_<TValue, TSpec> &set);       	// "seqan-1.3.1/seqan/misc/misc_set.h"(228)

//____________________________________________________________________________
// close

inline bool close(SVGFile &svg);       	// "seqan-1.3.1/seqan/misc/misc_svg.h"(171)

//____________________________________________________________________________
// createIntervalTree

template <typename TGraph, typename TPropertyMap, typename TIntervals, typename TSpec> void createIntervalTree(TGraph & g, TPropertyMap & pm, TIntervals & intervals, Tag<TSpec> const tag);       	// "seqan-1.3.1/seqan/misc/misc_interval_tree.h"(841)
template <typename TGraph, typename TPropertyMap, typename TIntervals> void createIntervalTree(TGraph & g, TPropertyMap & pm, TIntervals & intervals);       	// "seqan-1.3.1/seqan/misc/misc_interval_tree.h"(880)
template <typename TGraph, typename TPropertyMap, typename TIntervals, typename TSpec> void createIntervalTree(TGraph & g, TPropertyMap & pm, TIntervals & intervals, typename Value<typename Value<TIntervals>::Type>::Type center, Tag<TSpec> const tag);       	// "seqan-1.3.1/seqan/misc/misc_interval_tree.h"(896)
template <typename TGraph, typename TPropertyMap, typename TIntervals> void createIntervalTree(TGraph & g, TPropertyMap & pm, TIntervals & intervals, typename Value<typename Value<TIntervals>::Type>::Type center);       	// "seqan-1.3.1/seqan/misc/misc_interval_tree.h"(937)

//____________________________________________________________________________
// empty

template <typename TValue, typename TLess> inline bool empty(PriorityType<TValue, TLess, PriorityHeap> const & me);       	// "seqan-1.3.1/seqan/misc/priority_type_heap.h"(104)
template <typename TValue, typename TSpec> inline bool empty(Dequeue<TValue, TSpec> const &me);       	// "seqan-1.3.1/seqan/misc/misc_dequeue.h"(117)

//____________________________________________________________________________
// end

template <typename TObject, typename TSpec > inline Iter< Enumerator<TObject, TSpec>, Standard > end(Enumerator<TObject, TSpec> &enumerator, Standard);       	// "seqan-1.3.1/seqan/misc/edit_environment.h"(769)
template <typename TObject, typename TSpec > inline Iter< Enumerator<TObject, TSpec>, Standard > end(Enumerator<TObject, TSpec> const &enumerator, Standard);       	// "seqan-1.3.1/seqan/misc/edit_environment.h"(776)
template <typename TElement, typename TSpec> inline typename Iterator< VectorSet_<TElement, TSpec> >::Type end(VectorSet_<TElement, TSpec> &set);       	// "seqan-1.3.1/seqan/misc/misc_set.h"(307)
template <typename TElement, typename TSpec> inline typename Iterator< VectorSet_<TElement, TSpec> const>::Type end(VectorSet_<TElement, TSpec> const &set);       	// "seqan-1.3.1/seqan/misc/misc_set.h"(313)

//____________________________________________________________________________
// eof

template <typename TSet> inline bool eof(Iter<TSet, VectorSetIterator__> const &a);       	// "seqan-1.3.1/seqan/misc/misc_set.h"(330)

//____________________________________________________________________________
// erase

template <typename TKey, typename TValue, typename TSpec> finline void erase(TKey const &key, VectorSet_<TValue, TSpec> &set);       	// "seqan-1.3.1/seqan/misc/misc_set.h"(258)

//____________________________________________________________________________
// find

template <typename TKey, typename TKey2, typename TSpec> inline typename Iterator< VectorSet_<TKey2, TSpec> >::Type find(TKey const &key, VectorSet_<TKey2, TSpec> &set);       	// "seqan-1.3.1/seqan/misc/misc_set.h"(273)
template <typename TKey, typename TKey2, typename TSpec> inline typename Iterator< VectorSet_<TKey2, TSpec> const>::Type find(TKey const &key, VectorSet_<TKey2, TSpec> const &set);       	// "seqan-1.3.1/seqan/misc/misc_set.h"(283)

//____________________________________________________________________________
// findIntervals

template <typename TGraph, typename TPropertyMap, typename TValue,typename TCargo> void findIntervals(TGraph & g, TPropertyMap & pm, TValue query, String<TCargo> & result);       	// "seqan-1.3.1/seqan/misc/misc_interval_tree.h"(1383)
template <typename TValue,typename TCargo> void findIntervals(IntervalTree<TValue,TCargo> & it, TValue query, String<TCargo> & result);       	// "seqan-1.3.1/seqan/misc/misc_interval_tree.h"(1461)
template <typename TValue,typename TCargo> void findIntervals(IntervalTree<TValue,TCargo> & tree, TValue query_begin, TValue query_end, String<TCargo> & result);       	// "seqan-1.3.1/seqan/misc/misc_interval_tree.h"(1585)
template <typename TGraph, typename TPropertyMap, typename TValue,typename TCargo> void findIntervals(TGraph & g, TPropertyMap & pm, TValue query_begin, TValue query_end, String<TCargo> & result);       	// "seqan-1.3.1/seqan/misc/misc_interval_tree.h"(1597)
template <typename TGraph, typename TPropertyMap, typename TValue,typename TCargo> void findIntervals(TGraph & g, TPropertyMap & pm, typename VertexDescriptor<TGraph>::Type & act_knot, TValue query_begin, TValue query_end, String<TCargo> & result);       	// "seqan-1.3.1/seqan/misc/misc_interval_tree.h"(1620)

//____________________________________________________________________________
// findIntervalsExcludeTouching

template <typename TGraph, typename TPropertyMap, typename TValue,typename TCargo> void findIntervalsExcludeTouching(TGraph & g, TPropertyMap & pm, TValue query, String<TCargo> & result);       	// "seqan-1.3.1/seqan/misc/misc_interval_tree.h"(1485)
template <typename TValue,typename TCargo> void findIntervalsExcludeTouching(IntervalTree<TValue,TCargo> & tree, TValue query, String<TCargo> & result);       	// "seqan-1.3.1/seqan/misc/misc_interval_tree.h"(1566)

//____________________________________________________________________________
// front

template <typename TValue, typename TSpec> inline TValue & front(Dequeue<TValue, TSpec> &me);       	// "seqan-1.3.1/seqan/misc/misc_dequeue.h"(168)
template <typename TValue, typename TSpec> inline TValue const & front(Dequeue<TValue, TSpec> const &me);       	// "seqan-1.3.1/seqan/misc/misc_dequeue.h"(175)

//____________________________________________________________________________
// geomRand

template <typename T> inline T geomRand();       	// "seqan-1.3.1/seqan/misc/misc_random.h"(212)

//____________________________________________________________________________
// getArgumentValue

inline CharString const & getArgumentValue(CommandLineParser const & me, unsigned position);       	// "seqan-1.3.1/seqan/misc/misc_cmdparser.h"(1677)

//____________________________________________________________________________
// getArgumentValues

inline String<CharString> const & getArgumentValues(CommandLineParser const & me);       	// "seqan-1.3.1/seqan/misc/misc_cmdparser.h"(1698)

//____________________________________________________________________________
// getCargo

template <typename TValue, typename TCargo> TCargo getCargo(IntervalAndCargo<TValue,TCargo> & interval);       	// "seqan-1.3.1/seqan/misc/misc_interval_tree.h"(557)
template <typename TValue, typename TCargo> TCargo getCargo(PointAndCargo<TValue,TCargo> & point);       	// "seqan-1.3.1/seqan/misc/misc_interval_tree.h"(665)

//____________________________________________________________________________
// getLeftBoundary

template <typename TValue, typename TCargo> TValue getLeftBoundary(IntervalAndCargo<TValue,TCargo> & interval);       	// "seqan-1.3.1/seqan/misc/misc_interval_tree.h"(505)
template <typename TValue, typename TCargo> TValue getLeftBoundary(PointAndCargo<TValue,TCargo> & point);       	// "seqan-1.3.1/seqan/misc/misc_interval_tree.h"(621)

//____________________________________________________________________________
// getOptionValueLong

template <typename TValue> inline bool getOptionValueLong(CommandLineParser & me, CharString const & longName, unsigned argNo, TValue & val);       	// "seqan-1.3.1/seqan/misc/misc_cmdparser.h"(1610)
template <typename TValue> inline bool getOptionValueLong(CommandLineParser & me,CharString const & longName, TValue & val);       	// "seqan-1.3.1/seqan/misc/misc_cmdparser.h"(1628)

//____________________________________________________________________________
// getOptionValueShort

template <typename TValue> inline bool getOptionValueShort(CommandLineParser & me, CharString const & shortName, unsigned argNo, TValue & val);       	// "seqan-1.3.1/seqan/misc/misc_cmdparser.h"(1540)
template <typename TValue> inline bool getOptionValueShort(CommandLineParser & me, CharString const & shortName, TValue & val);       	// "seqan-1.3.1/seqan/misc/misc_cmdparser.h"(1558)

//____________________________________________________________________________
// getOptionValuesLong

inline String<CharString> const & getOptionValuesLong(CommandLineParser & me, CharString const & longName);       	// "seqan-1.3.1/seqan/misc/misc_cmdparser.h"(1646)

//____________________________________________________________________________
// getOptionValuesShort

inline String<CharString> const & getOptionValuesShort(CommandLineParser & me,CharString const & shortName);       	// "seqan-1.3.1/seqan/misc/misc_cmdparser.h"(1576)

//____________________________________________________________________________
// getRightBoundary

template <typename TValue, typename TCargo> TValue getRightBoundary(IntervalAndCargo<TValue,TCargo> & interval);       	// "seqan-1.3.1/seqan/misc/misc_interval_tree.h"(526)
template <typename TValue, typename TCargo> TValue getRightBoundary(PointAndCargo<TValue,TCargo> & point);       	// "seqan-1.3.1/seqan/misc/misc_interval_tree.h"(635)

//____________________________________________________________________________
// goBegin

template <typename TObject, unsigned DISTANCE > inline void goBegin(Iter<Enumerator<TObject, EditEnvironment<HammingDistance, DISTANCE> >, Standard> & it);       	// "seqan-1.3.1/seqan/misc/edit_environment.h"(209)
template <typename TObject, unsigned DISTANCE > inline void goBegin(Iter<Enumerator<TObject, EditEnvironment<LevenshteinDistance, DISTANCE> >, Standard> & it);       	// "seqan-1.3.1/seqan/misc/edit_environment.h"(555)

//____________________________________________________________________________
// goEnd

template <typename TObject, unsigned DISTANCE > inline void goEnd(Iter<Enumerator<TObject, EditEnvironment<HammingDistance, DISTANCE> >, Standard> & it);       	// "seqan-1.3.1/seqan/misc/edit_environment.h"(268)
template <typename TObject, unsigned DISTANCE > inline void goEnd(Iter<Enumerator<TObject, EditEnvironment<LevenshteinDistance, DISTANCE> >, Standard> & it);       	// "seqan-1.3.1/seqan/misc/edit_environment.h"(582)

//____________________________________________________________________________
// hasOptionLong

inline bool hasOptionLong(CommandLineParser const & me, CharString const & _long);       	// "seqan-1.3.1/seqan/misc/misc_cmdparser.h"(877)

//____________________________________________________________________________
// hasOptionShort

inline bool hasOptionShort(CommandLineParser const & me, CharString const & _short);       	// "seqan-1.3.1/seqan/misc/misc_cmdparser.h"(895)

//____________________________________________________________________________
// help

template <typename TStream> inline void help(CommandLineParser const & me, TStream & target);       	// "seqan-1.3.1/seqan/misc/misc_cmdparser.h"(1015)
inline void help(CommandLineParser const & me);       	// "seqan-1.3.1/seqan/misc/misc_cmdparser.h"(1089)

//____________________________________________________________________________
// helpText

inline CharString & helpText(CommandLineOption & me);       	// "seqan-1.3.1/seqan/misc/misc_cmdparser.h"(360)
inline const CharString & helpText(CommandLineOption const & me);       	// "seqan-1.3.1/seqan/misc/misc_cmdparser.h"(365)

//____________________________________________________________________________
// in

template <typename TKey, typename TValue, typename TSpec> finline bool in(TKey const &key, VectorSet_<TValue, TSpec> const &set);       	// "seqan-1.3.1/seqan/misc/misc_set.h"(267)

//____________________________________________________________________________
// insert

template <typename TElement, typename TSetKey, typename TSpec> finline void insert(TElement const &element, VectorSet_<TSetKey, TSpec> &set);       	// "seqan-1.3.1/seqan/misc/misc_set.h"(235)
template <typename TElement, typename TSetKey, typename TSetObject, typename TPairSpec, typename TSpec> finline void insert(TElement const &element, VectorSet_< Pair<TSetKey, TSetObject, TPairSpec>, TSpec > &set);       	// "seqan-1.3.1/seqan/misc/misc_set.h"(248)

//____________________________________________________________________________
// isBooleanOption

inline bool isBooleanOption(CommandLineOption const & me);       	// "seqan-1.3.1/seqan/misc/misc_cmdparser.h"(418)

//____________________________________________________________________________
// isDoubleOption

inline bool isDoubleOption(CommandLineOption const & me);       	// "seqan-1.3.1/seqan/misc/misc_cmdparser.h"(436)

//____________________________________________________________________________
// isHiddenOption

inline bool isHiddenOption(CommandLineOption const & me);       	// "seqan-1.3.1/seqan/misc/misc_cmdparser.h"(472)

//____________________________________________________________________________
// isIntOption

inline bool isIntOption(CommandLineOption const & me);       	// "seqan-1.3.1/seqan/misc/misc_cmdparser.h"(454)

//____________________________________________________________________________
// isLabelOption

inline bool isLabelOption(CommandLineOption const & me);       	// "seqan-1.3.1/seqan/misc/misc_cmdparser.h"(508)

//____________________________________________________________________________
// isOptionList

inline bool isOptionList(CommandLineOption const & me);       	// "seqan-1.3.1/seqan/misc/misc_cmdparser.h"(526)

//____________________________________________________________________________
// isOptionMandatory

inline bool isOptionMandatory(CommandLineOption const & me);       	// "seqan-1.3.1/seqan/misc/misc_cmdparser.h"(490)

//____________________________________________________________________________
// isSetLong

inline bool isSetLong(CommandLineParser & me,CharString const & longName);       	// "seqan-1.3.1/seqan/misc/misc_cmdparser.h"(1157)

//____________________________________________________________________________
// isSetShort

inline bool isSetShort(CommandLineParser & me, CharString const & shortName);       	// "seqan-1.3.1/seqan/misc/misc_cmdparser.h"(1134)

//____________________________________________________________________________
// isStringOption

inline bool isStringOption(CommandLineOption const & me);       	// "seqan-1.3.1/seqan/misc/misc_cmdparser.h"(400)

//____________________________________________________________________________
// keyOf

template <typename TElement> inline typename Key<TElement>::Type & keyOf(TElement & element);       	// "seqan-1.3.1/seqan/misc/misc_base.h"(85)
template <typename TElement> inline typename Key<TElement const>::Type & keyOf(TElement const & element);       	// "seqan-1.3.1/seqan/misc/misc_base.h"(91)
template <typename TKey, typename TObject, typename TSpec> inline TKey & keyOf(Pair<TKey, TObject, TSpec> &element);       	// "seqan-1.3.1/seqan/misc/misc_base.h"(97)
template <typename TKey, typename TObject, typename TSpec> inline TKey const & keyOf(Pair<TKey, TObject, TSpec> const &element);       	// "seqan-1.3.1/seqan/misc/misc_base.h"(102)
template <typename TSet> inline typename Key<TSet>::Type keyOf(Iter<TSet, VectorSetIterator__> &it);       	// "seqan-1.3.1/seqan/misc/misc_set.h"(343)
template <typename TSet> inline typename Key<TSet>::Type keyOf(Iter<TSet, VectorSetIterator__> const &it);       	// "seqan-1.3.1/seqan/misc/misc_set.h"(348)

//____________________________________________________________________________
// leftBoundary

template <typename TValue, typename TCargo> TValue & leftBoundary(IntervalAndCargo<TValue,TCargo> & interval);       	// "seqan-1.3.1/seqan/misc/misc_interval_tree.h"(463)
template <typename TValue, typename TCargo> TValue & leftBoundary(PointAndCargo<TValue,TCargo> & point);       	// "seqan-1.3.1/seqan/misc/misc_interval_tree.h"(593)

//____________________________________________________________________________
// length

template <typename TObject, unsigned DISTANCE > inline typename Size< Enumerator<TObject, EditEnvironment<HammingDistance, DISTANCE> > >::Type length(Enumerator<TObject, EditEnvironment<HammingDistance, DISTANCE> > const & me);       	// "seqan-1.3.1/seqan/misc/edit_environment.h"(373)
template <typename TObject, unsigned DISTANCE > inline typename Size< Enumerator<TObject, EditEnvironment<LevenshteinDistance, DISTANCE> > >::Type length(Enumerator<TObject, EditEnvironment<LevenshteinDistance, DISTANCE> > const & me);       	// "seqan-1.3.1/seqan/misc/edit_environment.h"(698)
template <typename TValue, typename TLess> inline typename Size<PriorityType<TValue, TLess, PriorityHeap> >::Type length( PriorityType<TValue, TLess, PriorityHeap> const & me);       	// "seqan-1.3.1/seqan/misc/priority_type_heap.h"(114)
template <typename TValue, typename TSpec> inline typename Size<Dequeue<TValue, TSpec> >::Type length(Dequeue<TValue, TSpec> const &me);       	// "seqan-1.3.1/seqan/misc/misc_dequeue.h"(300)
template <typename TObject, typename TSpec> inline typename Size< VectorSet_<TObject, TSpec> >::Type length(VectorSet_<TObject, TSpec> const &set);       	// "seqan-1.3.1/seqan/misc/misc_set.h"(164)

//____________________________________________________________________________
// lognormRand

inline double lognormRand(double mean, double stddev);       	// "seqan-1.3.1/seqan/misc/misc_random.h"(279)

//____________________________________________________________________________
// longName

inline CharString & longName(CommandLineOption & me);       	// "seqan-1.3.1/seqan/misc/misc_cmdparser.h"(282)
inline const CharString & longName(CommandLineOption const & me);       	// "seqan-1.3.1/seqan/misc/misc_cmdparser.h"(287)

//____________________________________________________________________________
// mtRand

inline unsigned mtRand();       	// "seqan-1.3.1/seqan/misc/misc_random.h"(156)

//____________________________________________________________________________
// mtRandDouble

inline double mtRandDouble();       	// "seqan-1.3.1/seqan/misc/misc_random.h"(191)

//____________________________________________________________________________
// mtRandInit

inline void mtRandInit(bool _doSRand );       	// "seqan-1.3.1/seqan/misc/misc_random.h"(113)
inline void mtRandInit();       	// "seqan-1.3.1/seqan/misc/misc_random.h"(133)

//____________________________________________________________________________
// normRand

inline double normRand(double mean, double stddev);       	// "seqan-1.3.1/seqan/misc/misc_random.h"(248)

//____________________________________________________________________________
// objectOf

template <typename TKey, typename TObject, typename TSpec> inline TObject & objectOf(Pair<TKey, TObject, TSpec> &element);       	// "seqan-1.3.1/seqan/misc/misc_base.h"(112)
template <typename TKey, typename TObject, typename TSpec> inline TObject const & objectOf(Pair<TKey, TObject, TSpec> const &element);       	// "seqan-1.3.1/seqan/misc/misc_base.h"(117)
template <typename TSet> inline typename Object<TSet>::Type & objectOf(Iter<TSet, VectorSetIterator__> &it);       	// "seqan-1.3.1/seqan/misc/misc_set.h"(354)
template <typename TSet> inline typename Object<TSet>::Type & objectOf(Iter<TSet, VectorSetIterator__> const &it);       	// "seqan-1.3.1/seqan/misc/misc_set.h"(359)

//____________________________________________________________________________
// open

template <typename TFileName> inline bool open(SVGFile &svg, TFileName const &fileName);       	// "seqan-1.3.1/seqan/misc/misc_svg.h"(163)

//____________________________________________________________________________
// operator!=

template <typename TObject, unsigned DISTANCE> inline bool operator!= ( Iter<Enumerator<TObject, EditEnvironment<HammingDistance, DISTANCE> >, Standard> const & a, Iter<Enumerator<TObject, EditEnvironment<HammingDistance, DISTANCE> >, Standard> const & b);       	// "seqan-1.3.1/seqan/misc/edit_environment.h"(841)
template <typename TObject, unsigned DISTANCE> inline bool operator!= ( Iter<Enumerator<TObject, EditEnvironment<LevenshteinDistance, DISTANCE> >, Standard> const & a, Iter<Enumerator<TObject, EditEnvironment<LevenshteinDistance, DISTANCE> >, Standard> const & b);       	// "seqan-1.3.1/seqan/misc/edit_environment.h"(863)
template <typename TSet> inline bool operator!=(Iter<TSet, VectorSetIterator__> const &a, Iter<TSet, VectorSetIterator__> const &b);       	// "seqan-1.3.1/seqan/misc/misc_set.h"(325)

//____________________________________________________________________________
// operator*

template <typename TObject, typename TSpec > inline TObject const & operator* (Iter<Enumerator<TObject, TSpec>, Standard> & it);       	// "seqan-1.3.1/seqan/misc/edit_environment.h"(192)
template <typename TObject, typename TSpec > inline TObject const & operator* (Iter<Enumerator<TObject, TSpec>, Standard> const & it);       	// "seqan-1.3.1/seqan/misc/edit_environment.h"(199)

//____________________________________________________________________________
// operator++

template <typename TObject, unsigned DISTANCE > inline Iter<Enumerator<TObject, EditEnvironment<HammingDistance, DISTANCE> >, Standard> & operator++ (Iter<Enumerator<TObject, EditEnvironment<HammingDistance, DISTANCE> >, Standard> & it);       	// "seqan-1.3.1/seqan/misc/edit_environment.h"(306)
template <typename TObject, unsigned DISTANCE > inline Iter<Enumerator<TObject, EditEnvironment<LevenshteinDistance, DISTANCE> >, Standard> & operator++ (Iter<Enumerator<TObject, EditEnvironment<LevenshteinDistance, DISTANCE> >, Standard> &it);       	// "seqan-1.3.1/seqan/misc/edit_environment.h"(599)

//____________________________________________________________________________
// operator<<

inline SVGFile & operator<< (SVGFile & target, char source);       	// "seqan-1.3.1/seqan/misc/misc_svg.h"(378)
inline SVGFile & operator<< (SVGFile & target, char const *source);       	// "seqan-1.3.1/seqan/misc/misc_svg.h"(386)
template <typename TStream> inline TStream & operator<< (TStream & target, CommandLineOption const & source);       	// "seqan-1.3.1/seqan/misc/misc_cmdparser.h"(621)

//____________________________________________________________________________
// operator==

template <typename TObject, unsigned DISTANCE> inline bool operator== ( Iter<Enumerator<TObject, EditEnvironment<HammingDistance, DISTANCE> >, Standard> const & a, Iter<Enumerator<TObject, EditEnvironment<HammingDistance, DISTANCE> >, Standard> const & b);       	// "seqan-1.3.1/seqan/misc/edit_environment.h"(791)
template <typename TObject, unsigned DISTANCE> inline bool operator== ( Iter<Enumerator<TObject, EditEnvironment<LevenshteinDistance, DISTANCE> >, Standard> const & a, Iter<Enumerator<TObject, EditEnvironment<LevenshteinDistance, DISTANCE> >, Standard> const & b);       	// "seqan-1.3.1/seqan/misc/edit_environment.h"(813)
template <typename TSet> inline bool operator==(Iter<TSet, VectorSetIterator__> const &a, Iter<TSet, VectorSetIterator__> const &b);       	// "seqan-1.3.1/seqan/misc/misc_set.h"(320)

//____________________________________________________________________________
// parse

template <typename TErrorStream> bool parse(CommandLineParser & me, int argc, const char *argv[], TErrorStream & estream);       	// "seqan-1.3.1/seqan/misc/misc_cmdparser.h"(1258)
inline bool parse(CommandLineParser & me, int argc, const char *argv[]);       	// "seqan-1.3.1/seqan/misc/misc_cmdparser.h"(1419)

//____________________________________________________________________________
// pop

template <typename TValue, typename TLess> inline void pop (PriorityType<TValue, TLess, PriorityHeap> & me);       	// "seqan-1.3.1/seqan/misc/priority_type_heap.h"(266)

//____________________________________________________________________________
// popBack

template <typename TValue, typename TSpec> inline bool popBack(Dequeue<TValue, TSpec> &me);       	// "seqan-1.3.1/seqan/misc/misc_dequeue.h"(217)

//____________________________________________________________________________
// popFront

template <typename TValue, typename TSpec> inline bool popFront(Dequeue<TValue, TSpec> &me);       	// "seqan-1.3.1/seqan/misc/misc_dequeue.h"(200)

//____________________________________________________________________________
// push

template <typename TValue, typename TLess> inline void push (PriorityType<TValue, TLess, PriorityHeap> & me, TValue const & element);       	// "seqan-1.3.1/seqan/misc/priority_type_heap.h"(214)

//____________________________________________________________________________
// pushBack

template <typename TValue, typename TSpec> inline void pushBack(Dequeue<TValue, TSpec> &me, TValue const & _value);       	// "seqan-1.3.1/seqan/misc/misc_dequeue.h"(269)

//____________________________________________________________________________
// pushFront

template <typename TValue, typename TSpec> inline void pushFront(Dequeue<TValue, TSpec> &me, TValue const & _value);       	// "seqan-1.3.1/seqan/misc/misc_dequeue.h"(237)

//____________________________________________________________________________
// requiredArguments

inline void requiredArguments(CommandLineParser & me, unsigned count);       	// "seqan-1.3.1/seqan/misc/misc_cmdparser.h"(914)

//____________________________________________________________________________
// reserve

template <typename TValue, typename TSpec, typename TSize_, typename TExpand> inline typename Size<Dequeue<TValue, TSpec> >::Type reserve(Dequeue<TValue, TSpec> &me, TSize_ new_capacity, Tag<TExpand> const tag);       	// "seqan-1.3.1/seqan/misc/misc_dequeue.h"(314)

//____________________________________________________________________________
// rightBoundary

template <typename TValue, typename TCargo> TValue & rightBoundary(IntervalAndCargo<TValue,TCargo> & interval);       	// "seqan-1.3.1/seqan/misc/misc_interval_tree.h"(484)
template <typename TValue, typename TCargo> TValue & rightBoundary(PointAndCargo<TValue,TCargo> & point);       	// "seqan-1.3.1/seqan/misc/misc_interval_tree.h"(607)

//____________________________________________________________________________
// setHelpText

inline void setHelpText(CommandLineOption & me, CharString const & newHelp);       	// "seqan-1.3.1/seqan/misc/misc_cmdparser.h"(381)

//____________________________________________________________________________
// setLongName

inline void setLongName(CommandLineOption & me, CharString const & newName);       	// "seqan-1.3.1/seqan/misc/misc_cmdparser.h"(304)

//____________________________________________________________________________
// setOptionType

inline void setOptionType(CommandLineOption & me, const int _newOptionType);       	// "seqan-1.3.1/seqan/misc/misc_cmdparser.h"(544)

//____________________________________________________________________________
// setShortName

inline void setShortName(CommandLineOption & me, CharString const & newName);       	// "seqan-1.3.1/seqan/misc/misc_cmdparser.h"(343)

//____________________________________________________________________________
// shortHelp

template <typename TStream> inline void shortHelp(CommandLineParser const & me, TStream & target);       	// "seqan-1.3.1/seqan/misc/misc_cmdparser.h"(984)
template <typename TStream> inline void shortHelp(CommandLineParser const & me);       	// "seqan-1.3.1/seqan/misc/misc_cmdparser.h"(995)

//____________________________________________________________________________
// shortName

inline CharString & shortName(CommandLineOption & me);       	// "seqan-1.3.1/seqan/misc/misc_cmdparser.h"(322)
inline const CharString & shortName(CommandLineOption const & me);       	// "seqan-1.3.1/seqan/misc/misc_cmdparser.h"(327)

//____________________________________________________________________________
// svgWriteFooter

inline void svgWriteFooter(SVGFile &svg);       	// "seqan-1.3.1/seqan/misc/misc_svg.h"(155)

//____________________________________________________________________________
// svgWriteHeader

inline void svgWriteHeader(SVGFile &svg);       	// "seqan-1.3.1/seqan/misc/misc_svg.h"(120)

//____________________________________________________________________________
// top

template <typename TValue, typename TLess> inline TValue & top(PriorityType<TValue, TLess, PriorityHeap> & me);       	// "seqan-1.3.1/seqan/misc/priority_type_heap.h"(140)
template <typename TValue, typename TLess> inline TValue const & top(PriorityType<TValue, TLess, PriorityHeap> const & me);       	// "seqan-1.3.1/seqan/misc/priority_type_heap.h"(148)

//____________________________________________________________________________
// value

template <typename TValue, typename TSpec, typename TPos> inline TValue & value(Dequeue<TValue, TSpec> &me, TPos pos);       	// "seqan-1.3.1/seqan/misc/misc_dequeue.h"(140)
template <typename TValue, typename TSpec, typename TPos> inline TValue const & value(Dequeue<TValue, TSpec> const &me, TPos pos);       	// "seqan-1.3.1/seqan/misc/misc_dequeue.h"(153)

//____________________________________________________________________________
// version

template <typename TStream> inline void version(CommandLineParser const & me, TStream & target);       	// "seqan-1.3.1/seqan/misc/misc_cmdparser.h"(1109)
inline void version(CommandLineParser const & me);       	// "seqan-1.3.1/seqan/misc/misc_cmdparser.h"(1115)

//____________________________________________________________________________
// write

template <typename TStream> inline void write(TStream & target, CommandLineOption const & me);       	// "seqan-1.3.1/seqan/misc/misc_cmdparser.h"(610)

} //namespace SEQAN_NAMESPACE_MAIN
//////////////////////////////////////////////////////////////////////////////

namespace seqan {

//____________________________________________________________________________
// length

inline size_t length(LongWord<NativeWidth> const &);       	// "seqan-1.3.1/seqan/misc/misc_long_word.h"(144)
template <unsigned LENGTH> size_t length(LongWord<StaticWidth<LENGTH> > const &);       	// "seqan-1.3.1/seqan/misc/misc_long_word.h"(276)
size_t length(LongWord<DynamicWidth> const & a);       	// "seqan-1.3.1/seqan/misc/misc_long_word.h"(622)

//____________________________________________________________________________
// operator!=

template <unsigned LENGTH> bool operator!=(LongWord<StaticWidth<LENGTH> > const & a, LongWord<StaticWidth<LENGTH> > const & b);       	// "seqan-1.3.1/seqan/misc/misc_long_word.h"(297)
bool operator!=(LongWord<DynamicWidth> const & a, LongWord<DynamicWidth> const & b);       	// "seqan-1.3.1/seqan/misc/misc_long_word.h"(641)

//____________________________________________________________________________
// operator&

template <unsigned LENGTH> LongWord<StaticWidth<LENGTH> > operator&(LongWord<StaticWidth<LENGTH> > const & a, LongWord<StaticWidth<LENGTH> > const & b);       	// "seqan-1.3.1/seqan/misc/misc_long_word.h"(390)
LongWord<DynamicWidth> operator&(LongWord<DynamicWidth> const & a, LongWord<DynamicWidth> const & b);       	// "seqan-1.3.1/seqan/misc/misc_long_word.h"(711)

//____________________________________________________________________________
// operator&=

inline LongWord<NativeWidth> & operator&=(LongWord<NativeWidth> & x, LongWord<NativeWidth> const & mask);       	// "seqan-1.3.1/seqan/misc/misc_long_word.h"(164)
template <unsigned LENGTH> LongWord<StaticWidth<LENGTH> > & operator&=(LongWord<StaticWidth<LENGTH> > & a, LongWord<StaticWidth<LENGTH> > const & b);       	// "seqan-1.3.1/seqan/misc/misc_long_word.h"(402)
LongWord<DynamicWidth> & operator&=(LongWord<DynamicWidth> & a, LongWord<DynamicWidth> const & b);       	// "seqan-1.3.1/seqan/misc/misc_long_word.h"(701)

//____________________________________________________________________________
// operator<

template <unsigned LENGTH> bool operator<(LongWord<StaticWidth<LENGTH> > const & a, LongWord<StaticWidth<LENGTH> > const & b);       	// "seqan-1.3.1/seqan/misc/misc_long_word.h"(338)
bool operator<(LongWord<DynamicWidth> const & a, LongWord<DynamicWidth> const & b);       	// "seqan-1.3.1/seqan/misc/misc_long_word.h"(671)

//____________________________________________________________________________
// operator<<

template <unsigned LENGTH> LongWord<StaticWidth<LENGTH> > operator<<(LongWord<StaticWidth<LENGTH> > const & a, unsigned shift);       	// "seqan-1.3.1/seqan/misc/misc_long_word.h"(478)
LongWord<DynamicWidth> operator<<(LongWord<DynamicWidth> const & a, unsigned shift);       	// "seqan-1.3.1/seqan/misc/misc_long_word.h"(803)

//____________________________________________________________________________
// operator<<=

inline LongWord<NativeWidth> & operator<<=(LongWord<NativeWidth> & x, unsigned const shift);       	// "seqan-1.3.1/seqan/misc/misc_long_word.h"(157)
template <unsigned LENGTH> LongWord<StaticWidth<LENGTH> > & operator<<=(LongWord<StaticWidth<LENGTH> > & a, unsigned shift);       	// "seqan-1.3.1/seqan/misc/misc_long_word.h"(487)
LongWord<DynamicWidth> & operator<<=(LongWord<DynamicWidth> & a, unsigned shift);       	// "seqan-1.3.1/seqan/misc/misc_long_word.h"(773)

//____________________________________________________________________________
// operator<=

template <unsigned LENGTH> bool operator<=(LongWord<StaticWidth<LENGTH> > const & a, LongWord<StaticWidth<LENGTH> > const & b);       	// "seqan-1.3.1/seqan/misc/misc_long_word.h"(312)
bool operator<=(LongWord<DynamicWidth> const & a, LongWord<DynamicWidth> const & b);       	// "seqan-1.3.1/seqan/misc/misc_long_word.h"(647)

//____________________________________________________________________________
// operator==

template <unsigned LENGTH> bool operator==(LongWord<StaticWidth<LENGTH> > const & a, LongWord<StaticWidth<LENGTH> > const & b);       	// "seqan-1.3.1/seqan/misc/misc_long_word.h"(283)
bool operator==(LongWord<DynamicWidth> const & a, LongWord<DynamicWidth> const & b);       	// "seqan-1.3.1/seqan/misc/misc_long_word.h"(628)

//____________________________________________________________________________
// operator>

template <unsigned LENGTH> bool operator>(LongWord<StaticWidth<LENGTH> > const & a, LongWord<StaticWidth<LENGTH> > const & b);       	// "seqan-1.3.1/seqan/misc/misc_long_word.h"(352)
bool operator>(LongWord<DynamicWidth> const & a, LongWord<DynamicWidth> const & b);       	// "seqan-1.3.1/seqan/misc/misc_long_word.h"(677)

//____________________________________________________________________________
// operator>=

template <unsigned LENGTH> bool operator>=(LongWord<StaticWidth<LENGTH> > const & a, LongWord<StaticWidth<LENGTH> > const & b);       	// "seqan-1.3.1/seqan/misc/misc_long_word.h"(325)
bool operator>=(LongWord<DynamicWidth> const & a, LongWord<DynamicWidth> const & b);       	// "seqan-1.3.1/seqan/misc/misc_long_word.h"(659)

//____________________________________________________________________________
// operator>>

template <unsigned LENGTH> LongWord<StaticWidth<LENGTH> > operator>>(LongWord<StaticWidth<LENGTH> > const & a, unsigned shift);       	// "seqan-1.3.1/seqan/misc/misc_long_word.h"(438)
LongWord<DynamicWidth> operator>>(LongWord<DynamicWidth> const & a, unsigned shift);       	// "seqan-1.3.1/seqan/misc/misc_long_word.h"(766)

//____________________________________________________________________________
// operator>>=

inline LongWord<NativeWidth> & operator>>=(LongWord<NativeWidth> & x, unsigned const shift);       	// "seqan-1.3.1/seqan/misc/misc_long_word.h"(150)
template <unsigned LENGTH> LongWord<StaticWidth<LENGTH> > & operator>>=(LongWord<StaticWidth<LENGTH> > & a, unsigned shift);       	// "seqan-1.3.1/seqan/misc/misc_long_word.h"(447)
LongWord<DynamicWidth> & operator>>=(LongWord<DynamicWidth> & a, unsigned shift);       	// "seqan-1.3.1/seqan/misc/misc_long_word.h"(737)

//____________________________________________________________________________
// operator^

template <unsigned LENGTH> LongWord<StaticWidth<LENGTH> > operator^(LongWord<StaticWidth<LENGTH> > const & a, LongWord<StaticWidth<LENGTH> > const & b);       	// "seqan-1.3.1/seqan/misc/misc_long_word.h"(414)
LongWord<DynamicWidth> operator^(LongWord<DynamicWidth> const & a, LongWord<DynamicWidth> const & b);       	// "seqan-1.3.1/seqan/misc/misc_long_word.h"(729)

//____________________________________________________________________________
// operator^=

inline LongWord<NativeWidth> & operator^=(LongWord<NativeWidth> & x, LongWord<NativeWidth> const & mask);       	// "seqan-1.3.1/seqan/misc/misc_long_word.h"(178)
template <unsigned LENGTH> LongWord<StaticWidth<LENGTH> > & operator^=(LongWord<StaticWidth<LENGTH> > & a, LongWord<StaticWidth<LENGTH> > const & b);       	// "seqan-1.3.1/seqan/misc/misc_long_word.h"(426)
LongWord<DynamicWidth> & operator^=(LongWord<DynamicWidth> & a, LongWord<DynamicWidth> const & b);       	// "seqan-1.3.1/seqan/misc/misc_long_word.h"(719)

//____________________________________________________________________________
// operator|

template <unsigned LENGTH> LongWord<StaticWidth<LENGTH> > operator|(LongWord<StaticWidth<LENGTH> > const & a, LongWord<StaticWidth<LENGTH> > const & b);       	// "seqan-1.3.1/seqan/misc/misc_long_word.h"(366)
LongWord<DynamicWidth> operator|(LongWord<DynamicWidth> const & a, LongWord<DynamicWidth> const & b);       	// "seqan-1.3.1/seqan/misc/misc_long_word.h"(693)

//____________________________________________________________________________
// operator|=

inline LongWord<NativeWidth> & operator|=(LongWord<NativeWidth> & x, LongWord<NativeWidth> const & mask);       	// "seqan-1.3.1/seqan/misc/misc_long_word.h"(171)
template <unsigned LENGTH> LongWord<StaticWidth<LENGTH> > & operator|=(LongWord<StaticWidth<LENGTH> > & a, LongWord<StaticWidth<LENGTH> > const & b);       	// "seqan-1.3.1/seqan/misc/misc_long_word.h"(378)
LongWord<DynamicWidth> & operator|=(LongWord<DynamicWidth> & a, LongWord<DynamicWidth> const & b);       	// "seqan-1.3.1/seqan/misc/misc_long_word.h"(683)

//____________________________________________________________________________
// reset

inline LongWord<NativeWidth> & reset(LongWord<NativeWidth> & x);       	// "seqan-1.3.1/seqan/misc/misc_long_word.h"(137)
template <unsigned LENGTH> inline LongWord<StaticWidth<LENGTH> > & reset(LongWord<StaticWidth<LENGTH> > & a);       	// "seqan-1.3.1/seqan/misc/misc_long_word.h"(266)
inline LongWord<DynamicWidth> & reset(LongWord<DynamicWidth> & a);       	// "seqan-1.3.1/seqan/misc/misc_long_word.h"(614)

} //namespace seqan
//////////////////////////////////////////////////////////////////////////////

namespace std {

//____________________________________________________________________________
// operator<<

template <typename TStream, unsigned LENGTH> TStream & operator<<(TStream & stream, seqan::LongWord<seqan::StaticWidth<LENGTH> > const & a);       	// "seqan-1.3.1/seqan/misc/misc_long_word.h"(816)
template <typename TStream> TStream & operator<<(TStream & stream, seqan::LongWord<seqan::DynamicWidth> const & a);       	// "seqan-1.3.1/seqan/misc/misc_long_word.h"(833)

} //namespace std

#endif

