/* $Id: message.c,v 1.6 2002/03/02 19:37:36 sverrehu Exp $ */
/*------------------------------------------------------------------------
 |  FILE            message.c
 |  MODULE OF       shhmsg - library for displaying messages.
 |
 |  DESCRIPTION     Routines for displaying messages unless "quiet mode"
 |                  is on.
 |
 |  WRITTEN BY      Sverre H. Huseby <shh@thathost.com>
 +----------------------------------------------------------------------*/

#include <stdio.h>
#include <stdarg.h>

#include "internal.h"
#include "shhmsg.h"

/*-----------------------------------------------------------------------+
|  PUBLIC DATA                                                           |
+-----------------------------------------------------------------------*/

int msgBeQuiet = 0;             /* supress everything from msgMessage() ? */

/*-----------------------------------------------------------------------+
|  PUBLIC FUNCTIONS                                                      |
+-----------------------------------------------------------------------*/

/*------------------------------------------------------------------------
 |
 |  NAME          msgSetQuiet
 |
 |  FUNCTION      Decide whether msgMessage() should display anything.
 |
 |  SYNOPSIS      #include "shhmsg.h"
 |                void msgSetQuiet(int onoff);
 |
 |  INPUT         onoff   1 to disable all messages, 0 to enable.
 |
 |  DESCRIPTION   Used in conjunction with the msgMessage() function.
 |                Note that changing the msgBeQuiet-variable directly
 |                is fully legal.
 */
void
msgSetQuiet(int onoff)
{
    msgBeQuiet = onoff;
}

/*------------------------------------------------------------------------
 |
 |  NAME          msgMessage
 |
 |  FUNCTION      Show given message unless quiet mode is on.
 |
 |  SYNOPSIS      #include "shhmsg.h"
 |                void msgMessage(const char *format, ...);
 |
 |  INPUT         format, ...
 |                        Arguments used as with printf().
 |
 |  DESCRIPTION   If msgSetQuiet(0) has been called, the given message is
 |                displayed on the _msgMessageStream. If msgSetQuiet(1)
 |                has been called, this function just returns.
 */
void
msgMessage(const char *format, ...)
{
    va_list ap;

    if (msgBeQuiet)
        return;
    fflush(stdout);
    if (_msgShowNameAlways)
	fprintf(GET_MESSAGE_STREAM, "%s: ", msgGetName());
    va_start(ap, format);
    vfprintf(GET_MESSAGE_STREAM, format, ap);
    va_end(ap);
}
