/*
 * heartbeat.h - Heart-beat task SiriDB.
 *
 * author       : Jeroen van der Heijden
 * email        : jeroen@transceptor.technology
 * copyright    : 2016, Transceptor Technology
 *
 * There is one and only one heart-beat task thread running for SiriDB. For
 * this reason we do not need to parse data but we should only take care for
 * locks while writing data.
 *
 * changes
 *  - initial version, 17-06-2016
 *
 */
#pragma once

#include <siri/siri.h>

typedef struct siri_s siri_t;

void siri_heartbeat_init(siri_t * siri);
void siri_heartbeat_stop(siri_t * siri);
void siri_heartbeat_force(void);
