8.1 Listen

# Listen

In diesem Abschnitt werden wir uns eine sehr nützliche Datenstruktur 
anschauen - die Liste. 

Wir hatten schon einmal in dem Abschnitt über Randomisierung kurz mit 
ihr zu tun, als wir die zu spielenden Noten zufällig aus einer Liste 
auswählten:

```
play choose([50, 55, 62])
```

In diesem Abschnitt erforschen wir, wie man Akkorde und Skalen mit
Listen darstellen kann. Rufen wir uns wieder in Erinnerung, 
wie wir einen Akkord spielen könnten. Wenn wir `sleep` nicht verwenden, 
werden alle Töne zur gleichen Zeit abgespielt: 

```
play 52
play 55
play 59
```

Wir können diesen Code aber auch anders schreiben.

## Eine Liste abspielen

Eine Möglichkeit ist es, alle Noten aus einer Liste zu spielen: 
`[52, 55, 59]`. Unsere freundliche Funktion `play` ist schlau genug, um 
zu wissen, wie man eine Liste von Noten abspielt. Versuche es einmal:

```
play [52, 55, 59]
```

Prima, das kann man schon viel besser lesen. Das Abspielen einer Liste 
hindert uns aber nicht daran, die gewohnten Parameter zu verwenden:

```
play [52, 55, 59], amp: 0.3
```

Natürlich kannst Du auch die traditionellen Namen der Noten anstelle 
der MIDI-Nummern verwenden:

```
play [:E3, :G3, :B3]
```

Die Glücklichen unter Euch, die ein bisschen Musiktheorie gelernt haben, 
erkannten den Akkord vielleicht: Es ist *E-Moll* in der dritten Oktave.

## Listenzugriffe

Sehr nützlich an Listen ist, dass man auf die enthaltenen Informationen
zugreifen kann. Das klingt vielleicht seltsam, aber es ist nicht
komplizierter als beispielsweise das Öffnen eines Buches auf der Seite
23. Eine Liste fragt man einfach "Was ist das Element am Index 23?".
Du musst Dir nur eine Merkwürdigkeit merken: Beim Programmieren beginnt
man beim Zählen der Listenelemente normalerweise mit 0 statt mit 1.

Listenindizes zählen wir also nicht 1,2,3,... sondern 0,1,2,...

Wir schauen uns das etwas genauer an. Nehmen wir diese Liste:

```
[52, 55, 59]
```

Nicht besonders beängstigend. Was ist das zweite Element dieser Liste? 
Natürlich, das ist `55`. Das war einfach. Jetzt versuchen wir, ob wir 
nicht den Computer dazu bringen können, die Frage für uns zu 
beantworten:

```
puts [52, 55, 59][1]
```

Falls Du so etwas noch nie gesehen hast, mag das ein bisschen seltsam 
wirken. Aber vertrau mir, das ist nicht schwierig zu durchschauen.
Die Zeile oben besteht aus drei Teilen: Dem Wort `puts`, unserer Liste
`52, 55, 59` und unserem Index `[1]`. Als Erstes sagen wir `puts`, damit
Sonic Pi die Antwort für uns ins Protokoll schreibt. Danach 
übergeben wir unsere Liste und am Ende den Index, mit dem wir nach dem 
zweiten Element der Liste fragen. Den Index müssen wir mit eckigen 
Klammern umschließen, und da wir bei `0` zu zählen beginnen, ist der 
Index des zweiten Elements `1`. Wie hier unten:

```
# indexes:  0   1   2
           [52, 55, 59]
```

Versuche mal, den Code `puts [52, 55, 59][1]` auszuführen, dann wirst 
Du sehen, dass `55` im Protokoll erscheint. Ändere mal den Index `1` in
einen anderen, probiere längere Listen aus und denke darüber nach, wie
Du Listen in Deinem nächsten Code-Jam verwenden könntest. Welche 
Strukturen aus der Musik könnte man denn als eine Reihe von Zahlen 
interpretieren?
