#!/usr/bin/env python
# Eclipse SUMO, Simulation of Urban MObility; see https://eclipse.dev/sumo
# Copyright (C) 2009-2023 German Aerospace Center (DLR) and others.
# This program and the accompanying materials are made available under the
# terms of the Eclipse Public License 2.0 which is available at
# https://www.eclipse.org/legal/epl-2.0/
# This Source Code may also be made available under the following Secondary
# Licenses when the conditions for such availability set forth in the Eclipse
# Public License 2.0 are satisfied: GNU General Public License, version 2
# or later which is available at
# https://www.gnu.org/licenses/old-licenses/gpl-2.0-standalone.html
# SPDX-License-Identifier: EPL-2.0 OR GPL-2.0-or-later

# @file    test.py
# @author  Pablo Alvarez Lopez
# @date    2019-07-16

# import common functions for netedit tests
import os
import sys

testRoot = os.path.join(os.environ.get('SUMO_HOME', '.'), 'tests')
neteditTestRoot = os.path.join(
    os.environ.get('TEXTTEST_HOME', testRoot), 'netedit')
sys.path.append(neteditTestRoot)
import neteditTestFunctions as netedit  # noqa

# Open netedit
neteditProcess, referencePosition = netedit.setupAndStart(neteditTestRoot)

# go to demand mode
netedit.supermodeDemand()

# go to container mode
netedit.containerMode()

# change Container
netedit.changeElement("containerFlow")

# create container using three edges
netedit.leftClick(referencePosition, 274, 400)
netedit.leftClick(referencePosition, 180, 60)

# press enter to create container
netedit.typeEnter()

# create container using three edges
netedit.leftClick(referencePosition, 560, 220)
netedit.leftClick(referencePosition, 180, 57)

# press enter to create container
netedit.typeEnter()

# change zoom
netedit.setZoom("0", "-6", "5")

# go to inspect mode
netedit.inspectMode()

# inspect container
netedit.leftClick(referencePosition, 310, 140)

# change ID with an invalid value
netedit.modifyAttribute(netedit.attrs.containerFlow.inspect.id, "", False)

# change ID with an invalid value
netedit.modifyAttribute(netedit.attrs.containerFlow.inspect.id, ";;;;;;;;", False)

# change ID with an invalid value
netedit.modifyAttribute(netedit.attrs.containerFlow.inspect.id, "id with spaces", False)

# change ID with an invalid value
netedit.modifyAttribute(netedit.attrs.containerFlow.inspect.id, "cf_1", False)

# change ID with an invalid value (empty)
netedit.modifyAttribute(netedit.attrs.containerFlow.inspect.id, "customID", False)

# Check undo
netedit.undo(referencePosition, 3)
netedit.redo(referencePosition, 3)

# save Netedit config
netedit.saveNeteditConfig(referencePosition)

# save containers
# quit netedit
netedit.quit(neteditProcess)
