// ************************************************************
// This file is automatically generated by genxdr. Do not edit.
// ************************************************************

package protocol

import (
	"github.com/calmh/xdr"
)

/*

Version13HelloMessage Structure:

 0                   1                   2                   3
 0 1 2 3 4 5 6 7 8 9 0 1 2 3 4 5 6 7 8 9 0 1 2 3 4 5 6 7 8 9 0 1
+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
/                                                               /
\              Device Name (length + padded data)               \
/                                                               /
+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
/                                                               /
\              Client Name (length + padded data)               \
/                                                               /
+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
/                                                               /
\             Client Version (length + padded data)             \
/                                                               /
+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+


struct Version13HelloMessage {
	string DeviceName<64>;
	string ClientName<64>;
	string ClientVersion<64>;
}

*/

func (o Version13HelloMessage) XDRSize() int {
	return 4 + len(o.DeviceName) + xdr.Padding(len(o.DeviceName)) +
		4 + len(o.ClientName) + xdr.Padding(len(o.ClientName)) +
		4 + len(o.ClientVersion) + xdr.Padding(len(o.ClientVersion))
}

func (o Version13HelloMessage) MarshalXDR() ([]byte, error) {
	buf := make([]byte, o.XDRSize())
	m := &xdr.Marshaller{Data: buf}
	return buf, o.MarshalXDRInto(m)
}

func (o Version13HelloMessage) MustMarshalXDR() []byte {
	bs, err := o.MarshalXDR()
	if err != nil {
		panic(err)
	}
	return bs
}

func (o Version13HelloMessage) MarshalXDRInto(m *xdr.Marshaller) error {
	if l := len(o.DeviceName); l > 64 {
		return xdr.ElementSizeExceeded("DeviceName", l, 64)
	}
	m.MarshalString(o.DeviceName)
	if l := len(o.ClientName); l > 64 {
		return xdr.ElementSizeExceeded("ClientName", l, 64)
	}
	m.MarshalString(o.ClientName)
	if l := len(o.ClientVersion); l > 64 {
		return xdr.ElementSizeExceeded("ClientVersion", l, 64)
	}
	m.MarshalString(o.ClientVersion)
	return m.Error
}

func (o *Version13HelloMessage) UnmarshalXDR(bs []byte) error {
	u := &xdr.Unmarshaller{Data: bs}
	return o.UnmarshalXDRFrom(u)
}
func (o *Version13HelloMessage) UnmarshalXDRFrom(u *xdr.Unmarshaller) error {
	o.DeviceName = u.UnmarshalStringMax(64)
	o.ClientName = u.UnmarshalStringMax(64)
	o.ClientVersion = u.UnmarshalStringMax(64)
	return u.Error
}
