C-----------------------------------------------------------------------
C
C                        SYRTHES version 3.4
C                        -------------------
C
C     This file is part of the SYRTHES Kernel, element of the
C     thermal code SYRTHES.
C
C     Copyright (C) 1988-2008 EDF S.A., France
C
C     contact: syrthes-support@edf.fr
C
C
C     The SYRTHES Kernel is free software; you can redistribute it
C     and/or modify it under the terms of the GNU General Public License
C     as published by the Free Software Foundation; either version 2 of
C     the License, or (at your option) any later version.
C
C     The SYRTHES Kernel is distributed in the hope that it will be
C     useful, but WITHOUT ANY WARRANTY; without even the implied warranty
C     of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
C     GNU General Public License for more details.
C
C
C     You should have received a copy of the GNU General Public License
C     along with the Code_Saturne Kernel; if not, write to the
C     Free Software Foundation, Inc.,
C     51 Franklin St, Fifth Floor,
C     Boston, MA  02110-1301  USA
C
C-----------------------------------------------------------------------
C/MEMBR ADD NAME=PROSCA,SSI=0
C
                     SUBROUTINE PROSCA
C                    *****************
C
C     -----------------
     *(  NP,X,Y,AUXR )
C     -----------------
C***********************************************************************
C* SYRTHES 3.4.3                                    COPYRIGHT EDF 2008 *
C***********************************************************************
C AUTEURS : C. PENIGUEL, I. RUPP                                       *
C***********************************************************************
C                                                                      *
C      FONCTION :                                                      *
C      ---------     PRODUIT SCALAIRE DE DEUX VECTEURS X ET Y          *
C                    auxr = SOM ( Xi * Yi ) i = 1....NP                *
C-----------------------------------------------------------------------
C		    (*)    (*)			ARGUMENTS
C   .___________.______._______________________________________________.
C   !    NOM    ! TYPE !MODE!                    ROLE                  !
C   !___________!______!____!__________________________________________!
C   !   NP      !   E  ! D  !  DIMENSION DU VECTEUR                    !
C   !   X       !  TR  ! D  !  VECTEUR                                 !
C   !   Y       !  TR  ! D  !  VECTEUR                                 !
C   !   AUXR    !   R  ! M  !  PRODUIT SCALAIRE DES VECTEURS X ET Y    !
C   !___________!______!____!__________________________________________!
C (*) TYPE : E (ENTIER), R (REEL), A (ALPHANUMERIQUE), T (TABLEAU)
C     ET TYPES COMPOSES
C (*) MODE : D (DONNEE NON MODIFIEE), R (RESULTAT), M (DONNEE MODIFIEE)
C            A (TABLEAU AUXILIAIRE)
C-----------------------------------------------------------------------
C    SOUS PROGRAMME(S) APPELE(S)    : AUCUN
C-----------------------------------------------------------------------
C    SOUS PROGRAMME(S) APPELANT(S)  : GRCONJ
C
C***********************************************************************
C
	IMPLICIT NONE
C
C***********************************************************************
C	DONNEES EN COMMON
C***********************************************************************
C
C***********************************************************************
C
      INTEGER NP
      DOUBLE PRECISION X(NP),Y(NP)
      DOUBLE PRECISION AUXR
C
      INTEGER I
C
C************************************************************************
C
      AUXR = 0.D0
C
CCDIR$ IVDEP
      DO 10 I=1,NP
          AUXR = AUXR + X(I) * Y(I)
   10 CONTINUE
C
      END
          
          
          
          
          
          
          
          
          
          
          
          
