[vset VERSION 1.0.4]
[comment {-*- tcl -*- doctools manpage}]
[manpage_begin tcl::chan::variable n [vset VERSION]]
[keywords {in-memory channel}]
[keywords {reflected channel}]
[keywords {tip 219}]
[keywords {virtual channel}]
[copyright {2009 Andreas Kupries <andreas_kupries@users.sourceforge.net>}]
[moddesc   {Reflected/virtual channel support}]
[category  Channels]
[titledesc {In-memory channel using variable for storage}]
[require Tcl 8.5]
[require TclOO]
[require tcl::chan::events [opt 1]]
[require tcl::chan::variable [opt [vset VERSION]]]
[description]
[para]

The [package tcl::chan::variable] package provides a command creating
channels which live purely in memory. They provide random-access,
i.e. are seekable.

In contrast to the channels created by [package tcl::chan::memchan]
the data is not hidden in the channel however, but stored in an
associated variable, specified at the time of construction.

[para] Packages related to this are [package tcl::chan::memchan] and
[package tcl::chan::string].

[para] The internal [package TclOO] class implementing the channel
handler is a sub-class of the [package tcl::chan::events] framework.

[section API]

[list_begin definitions]

[call [cmd ::tcl::chan::variable] [arg varname]]

This command creates a new variable channel and returns its handle.
The content of the channel is stored in the associated namespace
variable [arg varname].

[list_end]

[vset CATEGORY virtchannel]
[include ../doctools2base/include/feedback.inc]
[manpage_end]
