package slb

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// UploadServerCertificate invokes the slb.UploadServerCertificate API synchronously
func (client *Client) UploadServerCertificate(request *UploadServerCertificateRequest) (response *UploadServerCertificateResponse, err error) {
	response = CreateUploadServerCertificateResponse()
	err = client.DoAction(request, response)
	return
}

// UploadServerCertificateWithChan invokes the slb.UploadServerCertificate API asynchronously
func (client *Client) UploadServerCertificateWithChan(request *UploadServerCertificateRequest) (<-chan *UploadServerCertificateResponse, <-chan error) {
	responseChan := make(chan *UploadServerCertificateResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.UploadServerCertificate(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// UploadServerCertificateWithCallback invokes the slb.UploadServerCertificate API asynchronously
func (client *Client) UploadServerCertificateWithCallback(request *UploadServerCertificateRequest, callback func(response *UploadServerCertificateResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *UploadServerCertificateResponse
		var err error
		defer close(result)
		response, err = client.UploadServerCertificate(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// UploadServerCertificateRequest is the request struct for api UploadServerCertificate
type UploadServerCertificateRequest struct {
	*requests.RpcRequest
	AccessKeyId                 string           `position:"Query" name:"access_key_id"`
	ResourceOwnerId             requests.Integer `position:"Query" name:"ResourceOwnerId"`
	ServerCertificate           string           `position:"Query" name:"ServerCertificate"`
	AliCloudCertificateName     string           `position:"Query" name:"AliCloudCertificateName"`
	AliCloudCertificateId       string           `position:"Query" name:"AliCloudCertificateId"`
	PrivateKey                  string           `position:"Query" name:"PrivateKey"`
	ResourceGroupId             string           `position:"Query" name:"ResourceGroupId"`
	ResourceOwnerAccount        string           `position:"Query" name:"ResourceOwnerAccount"`
	OwnerAccount                string           `position:"Query" name:"OwnerAccount"`
	StandardType                string           `position:"Query" name:"StandardType"`
	OwnerId                     requests.Integer `position:"Query" name:"OwnerId"`
	Tags                        string           `position:"Query" name:"Tags"`
	AliCloudCertificateRegionId string           `position:"Query" name:"AliCloudCertificateRegionId"`
	ServerCertificateName       string           `position:"Query" name:"ServerCertificateName"`
}

// UploadServerCertificateResponse is the response struct for api UploadServerCertificate
type UploadServerCertificateResponse struct {
	*responses.BaseResponse
	AliCloudCertificateName string                                           `json:"AliCloudCertificateName" xml:"AliCloudCertificateName"`
	CreateTimeStamp         int64                                            `json:"CreateTimeStamp" xml:"CreateTimeStamp"`
	ExpireTime              string                                           `json:"ExpireTime" xml:"ExpireTime"`
	CreateTime              string                                           `json:"CreateTime" xml:"CreateTime"`
	ServerCertificateId     string                                           `json:"ServerCertificateId" xml:"ServerCertificateId"`
	ExpireTimeStamp         int64                                            `json:"ExpireTimeStamp" xml:"ExpireTimeStamp"`
	RegionId                string                                           `json:"RegionId" xml:"RegionId"`
	RequestId               string                                           `json:"RequestId" xml:"RequestId"`
	Fingerprint             string                                           `json:"Fingerprint" xml:"Fingerprint"`
	ServerCertificateName   string                                           `json:"ServerCertificateName" xml:"ServerCertificateName"`
	CommonName              string                                           `json:"CommonName" xml:"CommonName"`
	ResourceGroupId         string                                           `json:"ResourceGroupId" xml:"ResourceGroupId"`
	RegionIdAlias           string                                           `json:"RegionIdAlias" xml:"RegionIdAlias"`
	AliCloudCertificateId   string                                           `json:"AliCloudCertificateId" xml:"AliCloudCertificateId"`
	IsAliCloudCertificate   int                                              `json:"IsAliCloudCertificate" xml:"IsAliCloudCertificate"`
	SubjectAlternativeNames SubjectAlternativeNamesInUploadServerCertificate `json:"SubjectAlternativeNames" xml:"SubjectAlternativeNames"`
}

// CreateUploadServerCertificateRequest creates a request to invoke UploadServerCertificate API
func CreateUploadServerCertificateRequest() (request *UploadServerCertificateRequest) {
	request = &UploadServerCertificateRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Slb", "2014-05-15", "UploadServerCertificate", "Slb", "openAPI")
	request.Method = requests.POST
	return
}

// CreateUploadServerCertificateResponse creates a response to parse from UploadServerCertificate response
func CreateUploadServerCertificateResponse() (response *UploadServerCertificateResponse) {
	response = &UploadServerCertificateResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
