# - Try to find Hunspell
# Once done this will define
#
#  HUNSPELL_FOUND - system has Hunspell
#  HUNSPELL_INCLUDE_DIR - the Hunspell include directory
#  HUNSPELL_LIBRARIES - Link these to use Hunspell
#
# Redistribution and use of this file is allowed according to the terms of the
# MIT license. For details see the file COPYING-CMAKE-MODULES.


if ( HUNSPELL_INCLUDE_DIR AND HUNSPELL_LIBRARIES )
   # in cache already
   SET(Hunspell_FIND_QUIETLY TRUE)
endif ( HUNSPELL_INCLUDE_DIR AND HUNSPELL_LIBRARIES )

# use pkg-config to get the directories and then use these values
# in the FIND_PATH() and FIND_LIBRARY() calls
if( NOT WIN32 )
  find_package(PkgConfig)

  pkg_check_modules(HUNSPELL_PKG QUIET hunspell)
endif( NOT WIN32 )

FIND_PATH(HUNSPELL_INCLUDE_DIR NAMES hunspell.h
  PATHS
    /usr/local/include
    /usr/include
  HINTS
    ${HUNSPELL_PKG_INCLUDE_DIRS} # Generated by pkg-config
  PATH_SUFFIXES hunspell
)

FIND_LIBRARY(HUNSPELL_LIBRARIES NAMES hunspell-1.7 hunspell-1.6 hunspell-1.5 hunspell-1.4 hunspell-1.3 hunspell-1.2 hunspell ${HUNSPELL_PKG_LIBRARIES}
  PATHS
    /usr/local
    /usr
  HINTS
    ${HUNSPELL_PKG_LIBRARY_DIRS} # Generated by pkg-config
  PATH_SUFFIXES
    lib64
    lib
)

include(FindPackageHandleStandardArgs)
FIND_PACKAGE_HANDLE_STANDARD_ARGS(Hunspell DEFAULT_MSG HUNSPELL_LIBRARIES HUNSPELL_INCLUDE_DIR )

# show the HUNSPELL_INCLUDE_DIR and HUNSPELL_LIBRARIES variables only in the advanced view
MARK_AS_ADVANCED(HUNSPELL_INCLUDE_DIR HUNSPELL_LIBRARIES )

