# $Id: cyrillize.tcl 1463 2008-06-18 11:29:09Z sergei $

namespace eval cyrillize {
}

proc cyrillize::load_table {} {
    variable convert

    set f [file join [file dirname [info script]] engrus.tbl]
    set fd [open $f]
    fconfigure $fd -encoding koi8-r
    set convert_table [read $fd]
    close $fd

    foreach {f t} $convert_table {
	set convert(eng,rus,$f) $t
	set convert(rus,eng,$t) $f
    }
}

cyrillize::load_table

#puts [array get cyrillize::engrus]

proc cyrillize::do {s from to} {
    variable convert

    set res ""
    foreach c [split $s ""] {
	if {[info exists convert($from,$to,$c)]} {
	    append res $convert($from,$to,$c)
	} elseif {[info exists convert($from,$to,[string tolower $c])]} {
	    append res [string toupper $convert($from,$to,[string tolower $c])]
	} else {
	    append res $c
	}
    }
    return $res
}

#puts [cyrillize::do Ghbdtn]

proc cyrillize::wordInText {w from to} {
    if {[$w cget -state] != "normal"} return

    set ins [lindex [split [$w index insert] .] 1]
    set line [$w get "insert linestart" "insert lineend"]
    set wordstart [string wordstart $line [expr {$ins-1}]]
    set wordend [string length \
			[string trimright \
				[string range $line 0 [expr {$wordstart-1}]]]]
    set word [string range $line $wordstart [expr {$ins-1}]]

    set newword [do $word $from $to]
    $w delete "insert linestart +$wordstart chars" insert
    $w insert insert $newword

    $w mark set insert "insert linestart +$wordend chars"
}

proc cyrillize::wordInEntry {w from to} {
    if {[$w cget -state] != "normal"} return

    set ins [$w index insert]
    set line [$w get]
    set wordstart [string wordstart $line [expr {$ins-1}]]
    set wordend [string length \
			[string trimright \
				[string range $line 0 [expr {$wordstart-1}]]]]
    set word [string range $line $wordstart [expr {$ins-1}]]

    set newword [do $word $from $to]
    $w delete $wordstart insert
    $w insert insert $newword

    $w icursor $wordend
}

event add <<Cyrillize-Eng-Rus>> <Control-quoteright>
event add <<Cyrillize-Eng-Rus>> <Control-yacute>
event add <<Cyrillize-Rus-Eng>> <Control-quotedbl>
event add <<Cyrillize-Rus-Eng>> <Control-Yacute>

bind Text <<Cyrillize-Eng-Rus>> \
     [list [namespace current]::cyrillize::wordInText %W eng rus]
bind Text <<Cyrillize-Eng-Rus>> +break
bind Text <<Cyrillize-Rus-Eng>> \
     [list [namespace current]::cyrillize::wordInText %W rus eng]
bind Text <<Cyrillize-Rus-Eng>> +break

bind Entry <<Cyrillize-Eng-Rus>> \
     [list [namespace current]::cyrillize::wordInEntry %W eng rus]
bind Entry <<Cyrillize-Eng-Rus>> +break
bind Entry <<Cyrillize-Rus-Eng>> \
     [list [namespace current]::cyrillize::wordInEntry %W rus eng]
bind Entry <<Cyrillize-Rus-Eng>> +break

bind BwEntry <<Cyrillize-Eng-Rus>> \
     [list [namespace current]::cyrillize::wordInEntry %W eng rus]
bind BwEntry <<Cyrillize-Eng-Rus>> +break
bind BwEntry <<Cyrillize-Rus-Eng>> \
     [list [namespace current]::cyrillize::wordInEntry %W rus eng]
bind BwEntry <<Cyrillize-Rus-Eng>> +break

