-- Topal: GPG/GnuPG and Alpine/Pine integration
-- Copyright (C) 2001--2008  Phillip J. Brooke
--
-- This program is free software: you can redistribute it and/or modify
-- it under the terms of the GNU General Public License version 3 as
-- published by the Free Software Foundation.
--
-- This program is distributed in the hope that it will be useful,
-- but WITHOUT ANY WARRANTY; without even the implied warranty of
-- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
-- GNU General Public License for more details.
--
-- You should have received a copy of the GNU General Public License
-- along with this program.  If not, see <http://www.gnu.org/licenses/>.

with Globals; use Globals;

generic
   type Index is (<>);
package Char_Menus is

   Arrays_Not_Matched : exception;

   type MA is array (Index range <>) of UBS;

   -- Give a Menu_Array where each item contains the valid characters for
   -- that option.  The appropriate number will be returned.  Char_Words
   -- gives the word to display when that character is accepted.
   generic
      Accept_Chars   : MA;
      Char_Words     : MA;
      Default_Prompt : String := "";
   function Menu (Prompt : in String := Default_Prompt) return Index;

end Char_Menus;



