/*
    Tucnak - VHF contest log
    Copyright (C) 2002-2006  Ladislav Vaiz <ok1zia@nagano.cz>
    and authors of web browser Links 0.96

    This program is free software; you can redistribute it and/or
    modify it under the terms of the GNU General Public License
    version 2 as published by the Free Software Foundation.

*/

#include "header.h"


int retval = RET_OK;
char * starting_sbrk;


    
void sig_terminate(cba_t cba)
{
    unhandle_basic_signals();
    terminate = 1;
    retval = RET_SIGNAL;
}

void sig_intr(cba_t cba)
{              
    if (!term) {
        unhandle_basic_signals();
        terminate = 1;
    } else {
        unhandle_basic_signals();
        exit_prog(CBA0);
    }
}

void sig_ctrl_c(cba_t cba)
{
    dbg("sig_ctrl_c\n");
    if (!is_blocked()) kbd_ctrl_c();
}

void sig_ign(cba_t cba)
{
}

void sig_tstp(cba_t cba)
{              
#ifdef SIGSTOP
    int pid = getpid();
    block_itrm(0);
#if defined (SIGCONT) && defined(SIGTTOU)
    if (!fork()) {
        sleep(1);
        kill(pid, SIGCONT);
        exit(0);
    }
#endif
    raise(SIGSTOP);
#endif
}

void sig_cont(cba_t cba)
{
    if (!unblock_itrm(0)) resize_terminal(CBA0);
}

void sig_segv(cba_t cba){
    signal(SIGSEGV, SIG_DFL);
    fprintf(stderr, "sig_segv(%d)", (int)GETCBA(cba, int_));
/*    printf("\n\n\n  sig_segv() sdl=%p \n\n\n",sdl);*/
/*  install_signal_handler(SIGSEGV, NULL, CBA0, 0);*/
    cwdaemon_safe_abort(cwda);
#ifdef HAVE_SDL    
    if (sdl) {
        SDL_Quit();
    }
    else
#endif    
    {
        itrm_safe_abort();
    }
    raise(SIGSEGV);
}   

static void sig_pipe(int a){
   /* dbg("sig_pipe(%d)\n", a);
    dbg("pid=%d\n", getpid());
    sleep(10);*/
}
    
void handle_basic_signals(struct terminal *term)
{
#ifndef HAVE_SDL    
#define sdl 0
#endif
    install_signal_handler(SIGHUP, sig_intr, CBA0, 0);
    if (!sdl) install_signal_handler(SIGINT, sig_ctrl_c, CBA0, 0);
    install_signal_handler(SIGTERM, sig_terminate, CBA0, 0);
    if (!sdl){
#ifdef SIGTSTP
        install_signal_handler(SIGTSTP, sig_tstp, CBA0, 0);
#endif
#ifdef SIGTTIN
        install_signal_handler(SIGTTIN, sig_tstp, CBA0, 0);
#endif
#ifdef SIGCONT
        install_signal_handler(SIGCONT, sig_cont, CBA0, 0);
#endif
    }
#ifdef SIGTTOU
    install_signal_handler(SIGTTOU, sig_ign, CBA0, 0);
#endif
    install_signal_handler(SIGSEGV, sig_segv, CBA0, 1);
	signal(SIGPIPE, sig_pipe);
}

static void handle_sdl_signals(void){
    install_signal_handler(SIGSEGV, sig_segv, CBA0, 1);
}


void unhandle_terminal_signals()
{
    install_signal_handler(SIGHUP, NULL, CBA0, 0);
    if (!sdl) install_signal_handler(SIGINT, NULL, CBA0, 0);
#ifdef SIGTSTP
    install_signal_handler(SIGTSTP, NULL, CBA0, 0);
#endif
#ifdef SIGTTIN
    install_signal_handler(SIGTTIN, NULL, CBA0, 0);
#endif
#ifdef SIGCONT
    install_signal_handler(SIGCONT, NULL, CBA0, 0);
#endif
#ifdef SIGTTOU
    install_signal_handler(SIGTTOU, NULL, CBA0, 0);
#endif
    install_signal_handler(SIGSEGV, NULL, CBA0, 0);
	signal(SIGPIPE, SIG_IGN);
}

void unhandle_basic_signals()
{
    install_signal_handler(SIGHUP, NULL, CBA0, 0);
    if (!sdl) install_signal_handler(SIGINT, NULL, CBA0, 0);
    install_signal_handler(SIGTERM, NULL, CBA0, 0);
#ifdef SIGTSTP
    install_signal_handler(SIGTSTP, NULL, CBA0, 0);
#endif
#ifdef SIGTTIN
    install_signal_handler(SIGTTIN, NULL, CBA0, 0);
#endif
#ifdef SIGCONT
    install_signal_handler(SIGCONT, NULL, CBA0, 0);
#endif
#ifdef SIGTTOU
    install_signal_handler(SIGTTOU, NULL, CBA0, 0);
#endif
    install_signal_handler(SIGSEGV, NULL, CBA0, 0);
	signal(SIGPIPE, SIG_IGN);
}

#ifndef HAVE_SDL
#undef sdl
#endif

int term_attach_terminal(int in, int out, int ctl)
{
    int fd[2];

    /*struct terminal *term;*/
    dbg("attach_terminal\n");
    if (c_pipe(fd)) {
        error("ERROR: can't create pipe for internal communication");
        return -1;
    }
    fcntl(fd[0], F_SETFL, O_NONBLOCK);
    fcntl(fd[1], F_SETFL, O_NONBLOCK);
    handle_trm(in, out, out, fd[1], ctl);
    if ((term = init_term(fd[0], out, win_func))) {
        handle_basic_signals(term); /* OK, this is race condition, but it must be so; GPM installs it's own buggy TSTP handler */
        return fd[1];
    }

    closesocket(fd[0]);
    closesocket(fd[1]);
    return -1;
}

/*struct status dump_stat;*/
//static int dump_pos;

static int ac;
static char **av;

char *path_to_exe;

/*int init_b = 0;*/

static char *tucnak_home = NULL;
int first_use = 0;
int first_contest_def = 0;


static char *get_home(int *n)
{
    struct stat st;
    char *home = stracpy(getenv("HOME"));
    char *home_tucnak;
    char *config_dir = stracpy(getenv("CONFIG_DIR"));

    if (n) *n = 1;
    if (!home) {
        int i;
        home = stracpy(path_to_exe);
        if (!home) {
            if (config_dir) mem_free(config_dir);
            return NULL;
        }
        for (i = strlen(home) - 1; i >= 0; i--) if (dir_sep(home[i])) {
            home[i + 1] = 0;
            goto br;
        }
        home[0] = 0;
        br:;
    }
    while (home[0] && dir_sep(home[strlen(home) - 1])) home[strlen(home) - 1] = 0;
    if (home[0]) add_to_strn(&home, "/");
    home_tucnak = stracpy(home);
    if (config_dir)     
    {
        add_to_strn(&home_tucnak, config_dir);
        while (home_tucnak[0] && dir_sep(home_tucnak[strlen(home_tucnak) - 1])) home_tucnak[strlen(home_tucnak) - 1] = 0;
        if (stat(home_tucnak, &st) != -1 && S_ISDIR(st.st_mode)) {
            add_to_strn(&home_tucnak, "/tucnak");
            } else {
            fprintf(stderr, "CONFIG_DIR set to %s. But directory %s doesn't exist.\n\007", config_dir, home_tucnak);
            sleep(3);
            mem_free(home_tucnak);
            home_tucnak = stracpy(home);
            add_to_strn(&home_tucnak, "tucnak");        
        }
        mem_free(config_dir);
    } else add_to_strn(&home_tucnak, "tucnak");
    if (stat(home_tucnak, &st)) {
        if (!tmkdir(home_tucnak, 0777)) goto home_creat;
        if (config_dir) goto failed;
        goto first_failed;
    }
    if (S_ISDIR(st.st_mode)) goto home_ok;
    first_failed:
    mem_free(home_tucnak);
    home_tucnak = stracpy(home);
    add_to_strn(&home_tucnak, "tucnak");
    if (stat(home_tucnak, &st)) {
        if (!tmkdir(home_tucnak, 0777)) goto home_creat;
        goto failed;
    }
    if (S_ISDIR(st.st_mode)) goto home_ok;
    failed:
    mem_free(home_tucnak);
    mem_free(home);
    return NULL;

    home_ok:
    if (n) *n = 0;
    home_creat:
#ifdef HAVE_CHMOD
    chmod(home_tucnak, 0700);
#endif
    add_to_strn(&home_tucnak, "/");
    mem_free(home);
    return home_tucnak;
}

static void init_home(void)
{
    tucnak_home = get_home(&first_use);
    if (!tucnak_home) {
        fprintf(stderr, "Unable to find or create tucnak config directory. Please check, that you have $HOME variable set correctly and that you have write permission to your home directory.\n\007");
        sleep(3);
        return;
    }
}

//#define INIT(cmd) dbg("%s...\n", #cmd); cmd;
#define INIT(cmd) cmd

static void init(void)
{

    parse_options(ac, av);
    if (opt_i){
        printf("\n  %s %s\n\n", PACKAGE, VERSION);
#ifdef __GLIBC__
        printf("\n  glibc info\n");
        printf("compiled version: %d.%d\n", __GLIBC__, __GLIBC_MINOR__);
        printf("runtime version: %s\n", gnu_get_libc_version());
        printf("runtime release: %s\n\n", gnu_get_libc_release());
#endif
#ifdef HAVE_SDL        
        sdl_info();
#endif
#ifdef HAVE_LINUX_PPDEV_H        
        parport_info();
#endif        
#ifdef HAVE_ALSA        
#ifdef HAVE_SNDFILE
        alsa_info();
#endif
#endif        
#ifdef HAVE_LIBFTDI
        usb_info();
#endif
        iface_info();
        exit(0);
    }
    if (opt_s){
        printf("%s", txt_settings);
        printf("    macros: ");
#ifdef UNIX
        printf("UNIX ");  
#endif
#ifdef _UNIX
        printf("_UNIX ");  
#endif
#ifdef __UNIX
        printf("__UNIX ");  
#endif
#ifdef LINUX
        printf("LINUX ");
#endif
#ifdef _LINUX
        printf("_LINUX ");
#endif
#ifdef __LINUX
        printf("__LINUX ");
#endif
#ifdef WIN32
        printf("WIN32 ");
#endif
#ifdef _WIN32
        printf("_WIN32 ");
#endif
#ifdef _WIN64
        printf("_WIN64 ");
#endif
#ifdef __CYGWIN__
        printf("__CYGWIN__ ");
#endif
#ifdef __GNUC__
        printf("__GNUC__=%d.%d.%d ", __GNUC__, __GNUC_MINOR__, __GNUC_PATCHLEVEL__);
#endif
#ifdef _MSC_VER
        printf("_MSC_VER=%d.%02d ", _MSC_VER / 100, _MSC_VER % 100);
#endif
#ifdef __MINGW32__
        printf("__MINGW32__ ");
#endif
        printf("\n");
        exit(0);
    }
        
    g_thread_init(NULL);
#ifdef __MINGW32__
    init_mingw();
#endif
    INIT(init_debug());

    /*char *ccc = mem_alloc(8);
    strcpy(ccc, "0123456");
    ccc = mem_realloc(ccc, 16);
    mem_free(ccc);
    exit(0);*/

    INIT(init_iarray());
    INIT(init_ghash());

    INIT(init_trans());
    INIT(init_rc());
    INIT(term_spec_init());
	
    INIT(set_sigcld());
    INIT(init_home());
    INIT(init_keymaps());
    INIT(tpipe=init_threadpipe());
	
	INIT(read_rc_files());
    	
#ifdef HAVE_SDL    
    INIT(sdl=init_sdl());
    if (sdl) handle_sdl_signals(); 

    if (sdl){
        setenv("TERM", "sdl", 1);
        if (!sdl_attach_terminal(get_input_handle(), get_output_handle(), get_ctl_handle())==-1){
            retval = RET_FATAL;
            terminate = 1;
        }
    }
    else
#endif
    {
        if (!term_attach_terminal(get_input_handle(), get_output_handle(), get_ctl_handle())==-1){
            retval = RET_FATAL;
            terminate = 1;
        }
    }
    if (!term) internal_("init() !term");
        
    
	INIT(glog = init_fifo(1000));        
    INIT(gtalk = init_fifo(1000));        

    

    
    INIT(cw = init_cw());
    INIT(dw = init_dw());
    INIT(excdb = init_exc());
    INIT(qrvdb = init_qrv());
    INIT(wizz = init_wizz());
	INIT(namedb = init_namedb());
	INIT(masterdb = init_masterdb());
    INIT(init_sconns());
    INIT(init_rotars());
#ifdef HAVE_LIBFTDI
	hdkeyb = init_hdkeyb(); // after init_rotars
#endif
#ifdef HAVE_SDL    
    INIT(cor = init_cor());
#endif

    INIT(disable_screensaver());
    
    INIT(read_cw_files(cw));
    INIT(read_dw_files(dw));
    INIT(read_wizz_files(wizz));
	INIT(read_namedb_files(namedb));
	/*read_ebw_files(cw,namedb);*/
	INIT(read_masterdb_files(masterdb));
    
    INIT(init_sound());
    INIT(net = init_net());
	INIT(httpd = init_httpd());
    INIT(cwda = init_cwdaemon());
#ifdef HAVE_SNDFILE
    INIT(dsp = init_dsp());
    INIT(ssbd = init_ssbd());
#endif

    INIT(spotdb = init_spotdb());
#ifndef __CYGWIN__
    INIT(ntpq = init_ntpq());        
#endif
#ifdef HAVE_HAMLIB
    INIT(trig = init_trig());        
#endif
	INIT(fft = init_fft());
}

#define FREE(cmd) dbg("%s...\n", #cmd); cmd;
//#define FREE(cmd) cmd

static void terminate_all_subsystems(void)
{
#ifdef HAVE_SDL
    /*free_gfx();*/
#endif
    dbg("terminate_all_subsystems\n");
    FREE(check_bottom_halves());
    FREE(check_bottom_halves());
	FREE(check_bottom_halves());


#ifdef HAVE_SDL    
    FREE(sdl_stop_event_thread());
    FREE(free_cor(cor));
#endif
#ifdef HAVE_HAMLIB
    FREE(free_trig(trig)); 
#endif
#ifndef __CYGWIN__
    FREE(free_ntpq(ntpq)); 
#endif
    FREE(free_qrv(qrvdb));
    FREE(free_exc(excdb));
    FREE(free_dw(dw));
    FREE(free_cw(cw));
    FREE(free_wizz(wizz));
	FREE(free_namedb(namedb));
	FREE(free_masterdb(masterdb));
#ifdef HAVE_LIBFTDI
    free_hdkeyb(hdkeyb);
#endif
    FREE(free_rotars());
    FREE(free_spotdb(spotdb));
	FREE(free_httpd(httpd));
    FREE(free_net(net));
    FREE(free_cwdaemon(cwda); cwda = NULL);
#ifdef HAVE_SNDFILE
    FREE(free_ssbd(ssbd); ssbd = NULL);
    FREE(free_dsp(dsp));
#endif
    FREE(free_sound());
	FREE(free_fft(fft));  // after ssb
    FREE(free_threadpipe(tpipe));
    
    FREE(free_fifo(glog));
    FREE(free_fifo(gtalk));
	

    FREE(free_namelist());
    FREE(free_all_itrms());
    FREE(shrink_memory(1));

    FREE(free_history_lists());
    FREE(free_term_specs());
    FREE(free_keymaps());
    FREE(free_conv_table());
    FREE(check_bottom_halves());
    FREE(check_bottom_halves());
    FREE(destroy_terminal(CBA0));
#ifdef HAVE_SDL    
    FREE(free_sdl());
#endif

    if (tucnak_home) mem_free(tucnak_home);

    FREE(shutdown_trans());
    FREE(terminate_osdep());
    FREE(free_rc());
    FREE(check_memory_leaks());
    FREE(free_ghash());
    FREE(free_iarray());
    FREE(free_debug());
}


int main(int argc, char *argv[])
{
#if 0
	GString *gs = g_string_new("");
	zg_string_eprintfa("", gs, "%b", "A", 1);
	g_string_assign(gs, "");
	zg_string_eprintfa("", gs, "%b", "AA", 2);
	g_string_assign(gs, "");
	zg_string_eprintfa("", gs, "%b", "AAA", 3);
	g_string_assign(gs, "");
	zg_string_eprintfa("", gs, "%b", "AAAA", 4);

#endif
#if 0
    char s[20], t[20];
    strcpy(s, "  abc  "); strcpy(t, s); printf("'%s'   '%s'\n", s, trim(t)); 
    strcpy(s, "  abc"); strcpy(t, s); printf("'%s'   '%s'\n", s, trim(t)); 
    strcpy(s, "abc  "); strcpy(t, s); printf("'%s'   '%s'\n", s, trim(t)); 
    strcpy(s, " abc "); strcpy(t, s); printf("'%s'   '%s'\n", s, trim(t)); 
    strcpy(s, " abc"); strcpy(t, s); printf("'%s'   '%s'\n", s, trim(t)); 
    strcpy(s, "abc "); strcpy(t, s); printf("'%s'   '%s'\n", s, trim(t)); 
    strcpy(s, "abc"); strcpy(t, s); printf("'%s'   '%s'\n", s, trim(t)); 
    strcpy(s, "  "); strcpy(t, s); printf("'%s'   '%s'\n", s, trim(t)); 
    strcpy(s, " "); strcpy(t, s); printf("'%s'   '%s'\n", s, trim(t)); 
    strcpy(s, ""); strcpy(t, s); printf("'%s'   '%s'\n", s, trim(t)); 
    printf("'%s'   '%s'\n", NULL, trim(NULL)); 
    exit(0);
#endif

#if 0
	char str[256];
	printf("%s\n", sunrisesetstr(str, 50.1, -100));
	printf("%s\n", sunrisesetstr(str, 50.1, 0));
	printf("%s\n", sunrisesetstr(str, 50.1, 100));
	return 0;
#endif
#if 0
    g_thread_init(NULL);
    debug_type=2;
    init_debug();
    int thr=2;
    ST_START;
    similar_calls("OK2M", "OK1ZIA",0,thr,1);
    similar_calls("OK2M", "OK1KRQ",0,thr,1);

    similar_calls("OK2M", "OK2",0,thr,1);
    similar_calls("OK2M", "OKM",0,thr,1);
    similar_calls("OK2M", "O2M",0,thr,1);
    similar_calls("OK2M", "K2M",0,thr,1);
    
    similar_calls("OK2M", "KO2M",0,thr,1);
    
    similar_calls("OK2M", "OK2X",0,thr,1);
    similar_calls("OK2M", "OKXM",0,thr,1);
    similar_calls("OK2M", "OX2M",0,thr,1);
    similar_calls("OK2M", "XK2M",0,thr,1);
    
    similar_calls("OK2M", "OK2MX",0,thr,1);
    similar_calls("OK2M", "OK2XM",0,thr,1);
    similar_calls("OK2M", "OKX2M",0,thr,1);
    similar_calls("OK2M", "OXK2M",0,thr,1);
    similar_calls("OK2M", "XOK2M",0,thr,1);
    
    similar_calls("OK2M", "DK2M",0,thr,1);
    similar_calls("OK2M", "DK3M",0,thr,1);
    similar_calls("OK2M", "DK3O",0,thr,1);
    similar_calls("OK2M", "DL2M",0,thr,1);
    similar_calls("OK2M", "DL3M",0,thr,1);
    similar_calls("OK2M", "DL3O",0,thr,1);
    
    similar_calls("OK1KRQ", "OK1ZIA",0,thr,1);

    similar_calls("OK1KRQ", "OK1KRQ",0,thr,1);
    similar_calls("OK1KRQ", "OK1KR",0,thr,1);
    similar_calls("OK1KRQ", "OK1KQ",0,thr,1);
    similar_calls("OK1KRQ", "OK1RQ",0,thr,1);
    similar_calls("OK1KRQ", "OKKRQ",0,thr,1);
    similar_calls("OK1KRQ", "K1KRQ",0,thr,1);
    
    similar_calls("OK1KRQ", "OK1KQR",0,thr,1);
    similar_calls("OK1KRQ", "OK1RKQ",0,thr,1);
    similar_calls("OK1KRQ", "OKK1RQ",0,thr,1);
    similar_calls("OK1KRQ", "O1KKRQ",0,thr,1);
    similar_calls("OK1KRQ", "KO1KRQ",0,thr,1);

    similar_calls("OK1KRQ", "OK1KRX",0,thr,1);
    similar_calls("OK1KRQ", "OK1KXQ",0,thr,1);
    similar_calls("OK1KRQ", "OK1XRQ",0,thr,1);
    similar_calls("OK1KRQ", "OKXKRQ",0,thr,1);
    similar_calls("OK1KRQ", "OX1KRQ",0,thr,1);
    similar_calls("OK1KRQ", "XK1KRQ",0,thr,1);
    similar_calls("OK1KRQ", "OK1Q",0,thr,1);
    
    similar_calls("OM3I", "OM3RLA",0,thr,1);
    similar_calls("OM3I", "OM3RL",0,thr,1);
    similar_calls("OM3I", "OM3R",0,thr,1);
    similar_calls("OM3RKA", "OM5MZ",0,thr,1);
    similar_calls("HG10P", "HG3A",0,thr,1);
    similar_calls("HG3A", "HG10P",0,thr,1);
    ST_STOP;
    return;
#endif    
#if 0    
    GThread *thr;
    GError *gerr;
    gpointer ex;

    g_thread_init(NULL);
    thr=g_thread_create(func, NULL, 1,&gerr); 
    ex=g_thread_join(thr);
    printf("thread exited %p\n", ex);
    return(0);
#endif
    
#if 0    
    {
        void *p;
        init_debug();
        p=mem_alloc(10);
        p=mem_realloc(p, 20);
        mem_free(p);
                
        free_debug();
        check_memory_leaks();
        exit(0);
    }
#endif    
    
#if 0
    char *s;
    g_thread_init(NULL);
    init_debug();

    s=g_strdup("");
    printf("'%s'  ", s);
    s=optimize_path(s);
    printf(" '%s'\n", s);
    g_free(s);
    
    s=g_strdup(".");
    printf("'%s'  ", s);
    s=optimize_path(s);
    printf(" '%s'\n", s);
    g_free(s);
    
    s=g_strdup("/");
    printf("'%s'  ", s);
    s=optimize_path(s);
    printf(" '%s'\n", s);
    g_free(s);
    
    s=g_strdup("./");
    printf("'%s'  ", s);
    s=optimize_path(s);
    printf(" '%s'\n", s);
    g_free(s);
    
    s=g_strdup("/.");
    printf("'%s'  ", s);
    s=optimize_path(s);
    printf(" '%s'\n", s);
    g_free(s);
    
    s=g_strdup("a./");
    printf("'%s'  ", s);
    s=optimize_path(s);
    printf(" '%s'\n", s);
    g_free(s);
    
    s=g_strdup("a/./");
    printf("'%s'  ", s);
    s=optimize_path(s);
    printf(" '%s'\n", s);
    g_free(s);
    
    s=g_strdup("./b");
    printf("'%s'  ", s);
    s=optimize_path(s);
    printf(" '%s'\n", s);
    g_free(s);
    
    s=g_strdup("a./b");
    printf("'%s'  ", s);
    s=optimize_path(s);
    printf(" '%s'\n", s);
    g_free(s);
    
    s=g_strdup("a//b");
    printf("'%s'  ", s);
    s=optimize_path(s);
    printf(" '%s'\n", s);
    g_free(s);
    
    s=g_strdup("a/../b");
    printf("'%s'  ", s);
    s=optimize_path(s);
    printf(" '%s'\n", s);
    g_free(s);
    
    s=g_strdup("../b/c");
    printf("'%s'  ", s);
    s=optimize_path(s);
    printf(" '%s'\n", s);
    g_free(s);
    
    s=g_strdup("a/..");
    printf("'%s'  ", s);
    s=optimize_path(s);
    printf(" '%s'\n", s);
    g_free(s);
    
    s=g_strdup("a/../");
    printf("'%s'  ", s);
    s=optimize_path(s);
    printf(" '%s'\n", s);
    g_free(s);
    
    exit(1);
#endif  

    path_to_exe = argv[0];
    ac = argc;
    av = (char **)argv;

    starting_sbrk = (char *)sbrk(0);
/*    dbg("\n\n");*/
    select_loop(init);
    terminate_all_subsystems();

    
    return retval;
}


void shrink_memory(int u)
{
/*  shrink_dns_cache(u);
    shrink_format_cache(u);
    garbage_collection(u);
    delete_unused_format_cache_entries();*/
}
