/*
 * ===========================
 * VDK Visual Development Kit
 * Version 2.0
 * February 2001
 * ===========================
 *
 * Copyright (C) 1998, Mario Motta
 * Developed by Mario Motta <mmotta@guest.net>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
 * 02111-1307, USA.
 *
*/


#include <vdk/image.h>
#include <vdk/forms.h>
#include <vdk/colors.h>
#include <vdk/tooltips.h>
#include <cstdio>
#include <string>
#include <unistd.h>
#include <vdk/rawpixbuf.h>

#define DEFAULT_ICON_SIZE GTK_ICON_SIZE_BUTTON
#include "gtk/gtkstock.h"
#include "gtk/gtkiconfactory.h"
static void
x_gtk_image_update_size (GtkImage *image,
                       gint      image_width,
                       gint      image_height)
{
  GTK_WIDGET (image)->requisition.width = image_width + GTK_MISC (image)->xpad * 2;
  GTK_WIDGET (image)->requisition.height = image_height + GTK_MISC (image)->ypad * 2;

  if (GTK_WIDGET_VISIBLE (image))
    gtk_widget_queue_resize (GTK_WIDGET (image));
}

static void
x_gtk_image_clear (GtkImage *image)
{
  g_object_freeze_notify (G_OBJECT (image));
  /*
      printf("\nhere!!");
      fflush(stdout);
  */
  if (image->storage_type != GTK_IMAGE_EMPTY)
    g_object_notify (G_OBJECT (image), "storage_type");

  if (image->mask)
    {
      g_object_unref (image->mask);
      image->mask = NULL;
      g_object_notify (G_OBJECT (image), "mask");
    }

  if (image->icon_size != DEFAULT_ICON_SIZE)
    {
      image->icon_size = DEFAULT_ICON_SIZE;
      g_object_notify (G_OBJECT (image), "icon_size");
    }
  
  switch (image->storage_type)
    {
    case GTK_IMAGE_PIXMAP:

      if (image->data.pixmap.pixmap)
        g_object_unref (image->data.pixmap.pixmap);
      image->data.pixmap.pixmap = NULL;
      
      g_object_notify (G_OBJECT (image), "pixmap");
      
      break;

    case GTK_IMAGE_IMAGE:

      if (image->data.image.image)
        g_object_unref (image->data.image.image);
      image->data.image.image = NULL;
      
      g_object_notify (G_OBJECT (image), "image");
      
      break;

    case GTK_IMAGE_PIXBUF:

      if (image->data.pixbuf.pixbuf)
        g_object_unref (image->data.pixbuf.pixbuf);

      g_object_notify (G_OBJECT (image), "pixbuf");
      
      break;

    case GTK_IMAGE_STOCK:

      g_free (image->data.stock.stock_id);

      image->data.stock.stock_id = NULL;
      
      g_object_notify (G_OBJECT (image), "stock");      
      break;

    case GTK_IMAGE_ICON_SET:
      if (image->data.icon_set.icon_set)
        gtk_icon_set_unref (image->data.icon_set.icon_set);
      image->data.icon_set.icon_set = NULL;
      
      g_object_notify (G_OBJECT (image), "icon_set");      
      break;

    case GTK_IMAGE_ANIMATION:
      if (image->data.anim.frame_timeout)
        g_source_remove (image->data.anim.frame_timeout);
      
      if (image->data.anim.anim)
        g_object_unref (image->data.anim.anim);

      image->data.anim.frame_timeout = 0;
      image->data.anim.anim = NULL;
      
      g_object_notify (G_OBJECT (image), "pixbuf_animation");
      
      break;
      
    case GTK_IMAGE_EMPTY:
    default:
      break;
      
    }

  image->storage_type = GTK_IMAGE_EMPTY;

  memset (&image->data, '\0', sizeof (image->data));

  g_object_thaw_notify (G_OBJECT (image));

}


static int
handle_expose(GtkWidget* w , GdkEventExpose* event, void* o) 
{  
  g_return_val_if_fail(o != NULL,FALSE); 
  g_return_val_if_fail(w != NULL,FALSE); 
  printf("\nexpose event");
  return FALSE;
}
/*
 */
VDKImage::VDKImage(VDKForm* owner,
		   const char* pixfile,
		   char* tipString,
		   bool sensitive):
  VDKObject(owner)
{
  width = height = 0;
  if(sensitive)
    widget = gtk_event_box_new();
  else
    widget = gtk_vbox_new(true,0);
  if(!GTK_WIDGET_REALIZED(owner->Window()))
    gtk_widget_realize(owner->Window());
  if(pixfile)
    {
      pixmap = new VDKPixbuf(owner,pixfile);
      if(pixmap != NULL)
	{ 
	  pixmapWid =  sigwid = gtk_image_new_from_pixbuf(pixmap->AsGdkPixbuf());
	  // g_signal_connect_data(pixmapWid, "expose_event", G_CALLBACK (handle_expose), this, NULL,(GConnectFlags) 0);
	  width = pixmap->Width();
	  height = pixmap->Height();
	  gtk_widget_set_size_request(widget,width-10,height-10);
	  gtk_container_add(GTK_CONTAINER(widget),pixmapWid);
	  gtk_widget_show(pixmapWid);
	  gtk_widget_queue_draw(pixmapWid);
	}
      else
	pixmapWid = NULL;
    }
  else
    {
      pixmap = NULL;
      pixmapWid = NULL;
      tip = NULL;
    }
  oldRawPix = pixmap;
  if(tipString)
    tip = new VDKTooltip(owner,this,tipString);
  else
    tip = NULL;
  ConnectDefaultSignals();
  
}
/*
 */
VDKImage::VDKImage(VDKForm* owner,
		   const char** pixdata,
		   char* tipString,
		   bool sensitive):
  VDKObject(owner)
{
  width = height = 0;
  if(sensitive)
    widget = gtk_event_box_new();
  else
    widget = gtk_vbox_new(true,0);
  if(!GTK_WIDGET_REALIZED(owner->Window()))
    gtk_widget_realize(owner->Window());
  if(pixdata)
    {
      pixmap = new VDKPixbuf(owner,pixdata);
      if(pixmap != NULL)
	{
	  pixmapWid =  sigwid = gtk_image_new_from_pixbuf(pixmap->AsGdkPixbuf());
	  width = pixmap->Width();
	  height = pixmap->Height();
	  gtk_widget_set_size_request(widget,width-1,height-1);
	  gtk_container_add(GTK_CONTAINER(widget),pixmapWid);
	  gtk_widget_show(pixmapWid);
	  gtk_widget_queue_draw(pixmapWid);
	}
      else
	pixmapWid = NULL;
    }
  else
    {
      pixmap = NULL;
      pixmapWid = NULL;
      tip = NULL;
    }
  oldRawPix = pixmap;

  if(tipString)
    tip = new VDKTooltip(owner,this,tipString);
  else
    tip = NULL;

  gtk_signal_connect (GTK_OBJECT (widget), "button_press_event",
		      GTK_SIGNAL_FUNC(VDKObject::VDKEventPipe),this);
  ConnectDefaultSignals();
}

VDKImage::~VDKImage()
{
}
/*
 */
VDKPixbuf* VDKImage::SetImage(const char* file)
{
  if(!file)
      {
      if(GTK_WIDGET_REALIZED(WrappedWidget()))
      {
      if(pixmapWid)
            {
            x_gtk_image_clear (GTK_IMAGE(pixmapWid));
            x_gtk_image_update_size (GTK_IMAGE(pixmapWid),0,0);
            }
      }
      return NULL;
      }
  else
 
    return SetImage(new VDKPixbuf(this,file));
}
/*
 */
VDKPixbuf* VDKImage::SetImage(const char** pixdata)
{

if(!pixdata)
      {
      if(GTK_WIDGET_REALIZED(WrappedWidget()))
      {
      if(pixmapWid)
            {
            x_gtk_image_clear (GTK_IMAGE(pixmapWid));
            x_gtk_image_update_size (GTK_IMAGE(pixmapWid),0,0);
            }
      }
      return NULL;
      }
    return SetImage(new VDKPixbuf(this,pixdata));
}





VDKPixbuf*
VDKImage::SetImage(VDKPixbuf* newpix)
{
  VDKPixbuf* oldpix;
  if(oldRawPix == newpix)
    return NULL;
  else
    {
      oldpix = oldRawPix;
      if(pixmap)
	{
	  pixmap = NULL;
	}
      if(pixmapWid)
	{
	    pixmap = newpix;
	    gtk_image_set_from_pixbuf(GTK_IMAGE(pixmapWid),
                                   pixmap->AsGdkPixbuf());
	    gtk_widget_set_size_request(widget,newpix->Width()-1,newpix->Height()-1);
	    gtk_widget_queue_draw(pixmapWid);
	}	
      else
	{
	    pixmap = newpix;
	    pixmapWid = gtk_image_new_from_pixbuf(pixmap->AsGdkPixbuf());
	    gtk_widget_set_size_request(widget,newpix->Width()-1,newpix->Height()-1);
	    gtk_container_add(GTK_CONTAINER(widget),pixmapWid);
	    gtk_widget_show(pixmapWid);
	    gtk_widget_queue_draw(pixmapWid);
	}
      oldRawPix = newpix;
    }
  return oldpix;
}
