# -*- coding: utf-8 -*-

## This file is part of Videoporama
# Videoporama is a program to make diaporama export in video file
# Copyright (C) 2007-2010  Olivier Ponchaut <opvg@numericable.be> - Dominique Levray

# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License along
# with this program; if not, write to the Free Software Foundation, Inc.,
# 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.


import os
import sys
import subprocess
from xml.dom import minidom
from xml.dom.minidom import Document
from PyQt4.QtCore import *
from PyQt4.QtGui import *
from GlobalDefines import *
from mplayer import *
from sound import *
from SND_editorDlg import *
from soundProgress import *
from SoundProcess import *
from DocHelpDlg import *

class SoundProgressDlg(QDialog, Ui_soundprogress) :
    def __init__(self, parent=None) :
      super(SoundProgressDlg, self).__init__(parent)
      self.setupUi(self)
      self.setModal(True)
      
    def DoRenderInfoSound(self, text, progress) :
      self.message.setText(text)
      self.progressBar.setValue(progress)


class SoundDlg(QDialog,Ui_SND_Dialog) :
    def __init__(self, lenght, VideoporamaInstance, parent=None):
      super(SoundDlg, self).__init__(parent)
      self.setupUi(self)
      self.setModal(True)
      # Add mplayer widget at interface
      vbox = QVBoxLayout(self.groupMplayer)
      hbox = QHBoxLayout()
      self.processAudioB = QToolButton()
      self.processAudioB.setIcon(QIcon(QPixmap("icons/render.png")))
      hbox.addWidget(self.processAudioB)
      self.audioPlayer = Mplayer(VideoporamaInstance ,cheminVideo=[""], taille=(300,270), facteurLimitant=Mplayer.LARGEUR,                                 choixWidget=(Mplayer.PAS_PRECEDENT_SUIVANT,Mplayer.CURSEUR_A_PART), cheminMPlayer=VideoporamaInstance.MP)
      self.audioPlayer.setAudio(True)
      self.displayUrl=QLabel()
      hbox.addWidget(self.audioPlayer)      
      vbox.addWidget(self.displayUrl)
      vbox.addLayout(hbox)
      self.montageLenght = lenght # Total montage time in second
      self.mainAudioLenght = 0.0
      self.commentAudioLenght = 0.0
      self.VideoporamaInstance = VideoporamaInstance
      self.currentMain = -1
      self.currentComment = -1
      self.SND_timeline.setMinimumWidth(int(self.montageLenght*40))
      self.SND_main.setMinimumWidth(int(self.montageLenght*40))
      self.SND_comment.setMinimumWidth(int(self.montageLenght*40))
      self.SND_video.setMinimumWidth(int(self.montageLenght*40))
      self.showPosition.setMinimumWidth(int(self.montageLenght*40))
      self.showPosition.setRange(0, self.montageLenght*100)
      self.SND_timeline.setRowHeight(0, 100)
      self.SND_main.setRowHeight(0, 45)
      self.SND_comment.setRowHeight(0, 45)
      self.SND_video.setRowHeight(0, 38)
      self.SND_video.setRowHeight(1, 38)
      self.updatePosition(0)
      self.connect(self.SND_main, SIGNAL("cellClicked(int,int)"), self.setCurrentMain)
      self.connect(self.SND_comment, SIGNAL("cellClicked(int,int)"), self.setCurrentComment)
      self.connect(self.SND_video, SIGNAL("cellClicked(int,int)"), self.setCurrentVideo)
      self.connect(self.SND_main, SIGNAL("cellDoubleClicked(int,int)"), self.editAudioMain)
      self.connect(self.SND_comment, SIGNAL("cellDoubleClicked(int,int)"), self.editAudioComment)
      self.connect(self.cutMain, SIGNAL("clicked(bool)"), self.cutMainAction)
      self.connect(self.cutComment, SIGNAL("clicked(bool)"), self.cutCommentAction)
      self.connect(self.SND_add_main, SIGNAL("clicked(bool)"), self.add_main_action)
      self.connect(self.SND_add_comment, SIGNAL("clicked(bool)"), self.add_comment_action)
      self.connect(self.SND_del_main, SIGNAL("clicked(bool)"), self.del_main_action)
      self.connect(self.SND_del_comment, SIGNAL("clicked(bool)"), self.del_comment_action)
      self.connect(self.showPosition, SIGNAL("valueChanged(int)"), self.updatePosition)
      self.connect(self.processAudioB, SIGNAL("clicked(bool)"), self.renderSound)
      self.connect(self.buttonBox, SIGNAL("helpRequested()"), self.helpWin)


    def helpWin(self) :
      docw=DocHelp(self.VideoporamaInstance,self.VideoporamaInstance.qtapp.translate("Documentation","en-sound.html"),self)
      docw.show() 

    def cutMainAction(self, st) :
      """Cut sound object in main soundtrack from sound montage interface in function of cursor position"""
      if self.showPosition.value() != 0 :
        pos = self.showPosition.value()/100.0 # cursor position in second.ms
        i=0
        totTimeBefore = 0.0
        while i < self.SND_main.columnCount() :
          totTimeBefore += self.SND_main.cellWidget(0,i).lenght
          timeCurrentSO = self.SND_main.cellWidget(0,i).lenght
          if totTimeBefore > pos :
            totTimeBefore -= timeCurrentSO
            self.setCurrentMain(0,i)
            break
          i += 1
        #print "totTimeBefore = ", totTimeBefore
        #print "timeCurrentSO = ", timeCurrentSO
        #print "Position = ", pos
        if pos < totTimeBefore+timeCurrentSO :
          lengthSO = pos-totTimeBefore
          #print "lengthSO = ", lengthSO
          if self.SND_main.cellWidget(0,i).silence == 0 : #SO isn't silence object
            self.SND_main.cellWidget(0,i).TendV = self.SND_main.cellWidget(0,self.currentMain).TstartV + lengthSO
          else : # SO is silence object
            self.SND_main.cellWidget(0,i).silenceDuration = lengthSO
          SO = self.SND_main.cellWidget(0,i).copy()
          self.VideoporamaInstance.App_SetModifiedFlag()
          self.updateAudioSuite(SO)
            

    def cutCommentAction(self, st) :
      """Cut sound object in comment soundtrack from sound montage interface in function of cursor position"""
      if self.showPosition.value() != 0 and self.currentComment!=-1 :
        pos = self.showPosition.value()/100.0 # cursor position in second.ms
        i=0
        totTimeBefore = 0.0
        while i < self.currentComment :
          totTimeBefore += self.SND_comment.cellWidget(0,i).lenght
          timeCurrentSO = self.SND_comment.cellWidget(0,i).lenght
          if totTimeBefore > pos :
            totTimeBefore -= timeCurrentSO
            self.setCurrentComment(0,i)
            break
          i += 1
        if pos < totTimeBefore+timeCurrentSO :
          lengthSO = pos-totTimeBefore
          if self.SND_comment.cellWidget(0,self.currentComment).silence == 0 : #SO isn't silence object
            self.SND_comment.cellWidget(0,self.currentComment).TendV = self.SND_comment.cellWidget(0,self.currentComment).TstartV + lengthSO
          else : # SO is silence object
            self.SND_comment.cellWidget(0,self.currentComment).silenceDuration = lengthSO
          SO = self.SND_comment.cellWidget(0,self.currentComment).copy()
          self.VideoporamaInstance.App_SetModifiedFlag()
          self.updateAudioSuite(SO)
            

    ### Render to pre-listen the audio montage
    def renderSound(self) :
      """Function to render the full audio part and set the audio player to listen it"""
      self.VideoporamaInstance.qtapp.setOverrideCursor(QCursor(Qt.WaitCursor))
      self.renderSDlg = SoundProgressDlg(self)
      self.sndProcess = SND_Process(self.VideoporamaInstance, self.renderSDlg)
      xmlSound = self.getXMLSound(Document())
      
      self.sndProcess.setSoundToProcess(xmlSound, self.VideoporamaInstance.T+u"audio.tmp.wav", self.montageLenght)
      self.renderSDlg.show()
      self.renderSDlg.repaint()
      
      if self.sndProcess.run() :
        ### set MPlayer widget
        self.audioPlayer.setFileToPlay(self.VideoporamaInstance.T+u"audio.tmp.wav")
        self.displayUrl.setText(QString(u"audio.tmp.wav"))
        self.renderSDlg.close()
        self.VideoporamaInstance.qtapp.restoreOverrideCursor()
        
    ### Timeline setup
    def setTimeline(self, mainTimeline, ips) :
      i=0
      while i < mainTimeline.columnCount() :
        self.SND_timeline.insertColumn(i)
        if i == mainTimeline.columnCount()-1 : last = 1
        else : last = 0
        img = mainTimeline.cellWidget(0,i).getTimeImage(ips, last)
        seq = mainTimeline.cellWidget(0,i)
        self.SND_timeline.setColumnWidth(i,int(img.timeTot*40))
        self.SND_timeline.setCellWidget(0,i,img)
        if self.SND_video.columnCount() != 2*i+1 :
          self.SND_video.insertColumn(2*i)
          self.SND_video.setColumnWidth(2*i,int(img.imageTime[2]*40))
        self.SND_video.insertColumn(2*i+1)        
        self.SND_video.setColumnWidth(2*i+1,int((img.imageTime[0]-img.imageTime[2]-img.imageTime[4])*40))
        
        if seq.ObjectType == 2 :
          colv=0
          self.SND_video.insertColumn(2*i+2)        
          self.SND_video.setColumnWidth(2*i+2,int(img.imageTime[4]*40))
          startT=seq.StartVideo.hour()*3600.0+seq.StartVideo.minute()*60.0+seq.StartVideo.second()+seq.StartVideo.msec()/1000.0
          endT=seq.EndVideo.hour()*3600.0+seq.EndVideo.minute()*60.0+seq.EndVideo.second()+seq.EndVideo.msec()/1000.0
          videoSnd1 = soundObject(u"Video", seq.urlim, startT, startT+img.imageTime[2], fadein=img.imageTime[2])
          if self.SND_video.columnCount()==2*i+3 :
            if self.SND_video.cellWidget(0,2*i) != None :
              colv = 1
          self.SND_video.setCellWidget(colv,2*i,videoSnd1)        
          videoSnd2 = soundObject(u"Video", seq.urlim, startT+img.imageTime[2], endT-img.imageTime[4])
          self.SND_video.setCellWidget(colv,2*i+1,videoSnd2)
          videoSnd3 = soundObject(u"Video", seq.urlim, startT+img.timeTot, endT, fadeout=img.imageTime[4])
          self.SND_video.setCellWidget(colv,2*i+2,videoSnd3)
          if colv :
            nullSnd = nullSound(img.timeTot-img.imageTime[4])
            self.SND_video.setCellWidget(0,2*i+1,nullSnd)

        else :
          nullSnd1 = nullSound(img.imageTime[2])
          nullSnd2 = nullSound(img.timeTot-img.imageTime[4])
          if self.SND_video.cellWidget(0,2*i) == None :
            self.SND_video.setCellWidget(0,2*i,nullSnd1)
          self.SND_video.setCellWidget(0,2*i+1,nullSnd2)
        if last and self.SND_video.columnCount()!=2*i+3 :
          self.SND_video.insertColumn(2*i+2)
          self.SND_video.setColumnWidth(2*i+2,int(img.imageTime[4]*40))          
          nullSnd1 = nullSound(img.imageTime[4])
          self.SND_video.setCellWidget(0,2*i+2,nullSnd1)
             
        i += 1
        self.SND_timeline.repaint()
        self.SND_video.repaint()
      
    def setSoundFromXml(self, xmlSound) :
      """Function to load sound object from xml definition"""
      if xmlSound != None :
        mainXml = xmlSound.getElementsByTagName('mainTrack')[0].getElementsByTagName('soundObject')
        for node in mainXml :
          audio = soundObject(
                              track=node.getAttribute('track'),
                              urlFile=MakeAbsolut(self.VideoporamaInstance.ProjectFilePathName, node.getAttribute('urlFile')),
                              TstartV=float(node.getAttribute('TstartV')),
                              TendV=float(node.getAttribute('TendV')),
                              selected=False,
                              silence=int(node.getAttribute('silence')),
                              silenceDuration=float(node.getAttribute('silenceD')),
                              gain=int(node.getAttribute('gain')),
                              fadein=float(node.getAttribute('fadein')),
                              fadeout=float(node.getAttribute('fadeout')))
          self.setAudio(audio)
        commentXml = xmlSound.getElementsByTagName('commentTrack')[0].getElementsByTagName('soundObject')
        for node in commentXml :
          audio = soundObject(
                              track=node.getAttribute('track'),
                              urlFile=MakeAbsolut(self.VideoporamaInstance.ProjectFilePathName, node.getAttribute('urlFile')),
                              TstartV=float(node.getAttribute('TstartV')),
                              TendV=float(node.getAttribute('TendV')),
                              selected=False,
                              silence=int(node.getAttribute('silence')),
                              silenceDuration=float(node.getAttribute('silenceD')),
                              gain=int(node.getAttribute('gain')),
                              fadein=float(node.getAttribute('fadein')),
                              fadeout=float(node.getAttribute('fadeout')))
          self.setAudio(audio)

    def updateAudioMontageLenght(self) :
      self.mainAudioLenght = 0.0
      i=0
      while i < self.SND_main.columnCount() :
        self.mainAudioLenght += self.SND_main.cellWidget(0,i).lenght
        i+=1
      self.commentAudioLenght = 0.0
      i=0
      while i < self.SND_comment.columnCount() :
        self.commentAudioLenght += self.SND_comment.cellWidget(0,i).lenght
        i+=1
      self.infoTime.setText(u"%s / %s" % (secondToPos(self.mainAudioLenght), secondToPos(self.montageLenght)))

    def updatePosition(self, pos) :
      self.position.setText(u"%s / %s" % (secondToPos(pos/100.0), secondToPos(self.montageLenght)))
           
    def getXMLSound(self, doc) :
      """Function to return xml infos of defined soundtracks main and comment"""
      xmlRoot = doc.createElement(u"sound")
      xmlMain = doc.createElement(u"mainTrack")
      i=0
      while i<self.SND_main.columnCount() :
        xmlMain.appendChild(self.SND_main.cellWidget(0,i).getXMLSoundObject(doc))
        i += 1
      xmlComment = doc.createElement(u"commentTrack")
      i=0
      while i<self.SND_comment.columnCount() :
        xmlComment.appendChild(self.SND_comment.cellWidget(0,i).getXMLSoundObject(doc))
        i += 1
      xmlRoot.appendChild(xmlMain)
      xmlRoot.appendChild(xmlComment)
      return xmlRoot

    def getPropSound(self) :
      """Function to return properties of defined soundtracks main and comment"""
      soundDef = []
      mainDef = []
      commentDef = []
      i=0
      while i<self.SND_main.columnCount() :
        mainDef.append(self.SND_main.cellWidget(0,i).getPropSoundObject())
        i += 1
      i=0
      while i<self.SND_comment.columnCount() :
        commentDef.append(self.SND_comment.cellWidget(0,i).getPropSoundObject())
        i += 1
      soundDef.append(mainDef)
      soundDef.append(commentDef)
      return soundDef

    ### Player / recorder audio functions
    def add_main_action(self) :
      self.editor = SoundEditorDlg(self.VideoporamaInstance, u"Main", self, self.montageLenght-self.mainAudioLenght)
      self.editor.show()
      self.connect(self.editor.buttonBox,SIGNAL("accepted()"), self.addAudio)
      
    def add_comment_action(self) :
      self.editor = SoundEditorDlg(self.VideoporamaInstance, u"Comment", self, self.montageLenght-self.commentAudioLenght)
      self.editor.show()
      self.connect(self.editor.buttonBox,SIGNAL("accepted()"), self.addAudio)
      
    def addAudio(self) :
      audio = self.editor.getAudioObject()
      self.editor.audioPlayer.arretMPlayer()
      self.setAudio(audio)
     
    def setAudio(self, audio) :
      if audio != None and audio.lenght > 0 :
        if audio.track == u"Main" :
          self.SND_main.insertColumn(self.currentMain+1)   
          self.SND_main.setColumnWidth(self.currentMain+1, int(audio.lenght*40))
          self.SND_main.setCellWidget(0, self.currentMain+1, audio)
          self.setCurrentMain(0, self.currentMain+1)
          self.SND_main.repaint()

        if audio.track == u"Comment" : 
          self.SND_comment.insertColumn(self.currentComment+1)   
          self.SND_comment.setColumnWidth(self.currentComment+1, int(audio.lenght*40))
          self.SND_comment.setCellWidget(0, self.currentComment+1, audio)
          self.setCurrentComment(0, self.currentComment+1)
          self.SND_comment.repaint()
          
        self.updateAudioMontageLenght()
          
    def editAudioMain(self, row, column) :      
      self.editor = SoundEditorDlg(self.VideoporamaInstance ,u"Main", self, self.montageLenght-self.mainAudioLenght)
      self.editor.setEditorValue(
            self.SND_main.cellWidget(0, column).urlFile, 
            self.SND_main.cellWidget(0, column).TstartV, 
            self.SND_main.cellWidget(0, column).TendV,
            self.SND_main.cellWidget(0, column).silenceDuration,
            self.SND_main.cellWidget(0, column).silence,
            self.SND_main.cellWidget(0, column).gain,
            self.SND_main.cellWidget(0, column).fadein,
            self.SND_main.cellWidget(0, column).fadeout)
      self.editor.show()
      self.connect(self.editor.buttonBox,SIGNAL("accepted()"), self.updateAudio)
      self.connect(self.editor.buttonBox,SIGNAL("rejected()"), self.editor.audioPlayer.arretMPlayer)
      
    def editAudioComment(self, row, column) :      
      self.editor = SoundEditorDlg(self.VideoporamaInstance ,u"Comment", self, self.montageLenght-self.commentAudioLenght)
      self.editor.setEditorValue(
            self.SND_comment.cellWidget(0, column).urlFile, 
            self.SND_comment.cellWidget(0, column).TstartV, 
            self.SND_comment.cellWidget(0, column).TendV,
            self.SND_comment.cellWidget(0, column).silenceDuration,
            self.SND_comment.cellWidget(0, column).silence,
            self.SND_comment.cellWidget(0, column).gain)
      self.editor.show()
      self.connect(self.editor.buttonBox,SIGNAL("accepted()"), self.updateAudio)
      self.connect(self.editor.buttonBox,SIGNAL("rejected()"), self.editor.audioPlayer.arretMPlayer)
      
    def updateAudio(self) :
      self.editor.audioPlayer.arretMPlayer()
      audio = self.editor.getAudioObject(True)
      self.updateAudioSuite(audio)
      
    def updateAudioSuite(self, audio) :
      if audio.track  == u"Main" :
        self.SND_main.setCellWidget(0, self.currentMain, audio)
        self.SND_main.setColumnWidth(self.currentMain, int(audio.lenght*40))
      elif audio.track  == u"Comment" :
        self.SND_comment.setCellWidget(0, self.currentComment, audio)
        self.SND_comment.setColumnWidth(self.currentComment, int(audio.lenght*40))
      self.updateAudioMontageLenght()

        
    def del_main_action(self) :
      if self.currentMain == -1 : return
      self.SND_main.removeColumn(self.currentMain)
      self.currentMain = -1
      self.VideoporamaInstance.App_SetModifiedFlag()
      self.updateAudioMontageLenght()


    def del_comment_action(self) :
      if self.currentComment == -1 : return
      self.SND_comment.removeColumn(self.currentComment)
      self.currentComment = -1
      self.VideoporamaInstance.App_SetModifiedFlag()
      self.updateAudioMontageLenght()


    def setCurrentMain(self, row, column) :
      if not self.SND_main.cellWidget(0, column).silence :
        self.audioPlayer.setFileToPlay(self.SND_main.cellWidget(0, column).urlFile, (self.SND_main.cellWidget(0, column).TstartV,self.SND_main.cellWidget(0, column).TendV))
        self.displayUrl.setText(QString(self.SND_main.cellWidget(0, column).urlFile.split("/")[-1]))
      if self.currentMain == column : return
      previous = self.currentMain
      self.currentMain = column
      self.SND_main.cellWidget(0, column).drawPix(True)
      if previous != -1 :
        self.SND_main.cellWidget(0, previous).drawPix(False)
          
    def setCurrentComment(self, row, column) :
      if not self.SND_comment.cellWidget(0, column).silence :
        self.audioPlayer.setFileToPlay(self.SND_comment.cellWidget(0, column).urlFile, (self.SND_comment.cellWidget(0, column).TstartV,self.SND_comment.cellWidget(0, column).TendV))
        self.displayUrl.setText(QString(self.SND_comment.cellWidget(0, column).urlFile.split("/")[-1]))
      if self.currentComment == column : return
      previous = self.currentComment
      self.currentComment = column
      self.SND_comment.cellWidget(0, column).drawPix(True)
      if previous != -1 :
        self.SND_comment.cellWidget(0, previous).drawPix(False)

    def setCurrentVideo(self, row, column) :
      if not self.SND_video.cellWidget(row, column).silence :
        self.audioPlayer.setFileToPlay(self.SND_video.cellWidget(row, column).urlFile, (self.SND_video.cellWidget(row, column).TstartV,self.SND_video.cellWidget(row, column).TendV))
        self.displayUrl.setText(QString(self.SND_video.cellWidget(row, column).urlFile.split("/")[-1]))
