(* This file is generated by Why3's Coq-realize driver *)
(* Beware! Only edit allowed sections below    *)
Require Import BuiltIn.
Require BuiltIn.
Require bool.Bool.
Require int.Int.

(* Why3 assumption *)
Definition zwf_zero (a:Z) (b:Z): Prop := (0%Z <= b)%Z /\ (a < b)%Z.

(* Why3 goal *)
Definition alloc_table : forall (t:Type) {t_WT:WhyType t}, Type.

Admitted.

(* Why3 goal *)
Definition pointer : forall (t:Type) {t_WT:WhyType t}, Type.

Admitted.

Global Instance pointer_WhyType : forall (t:Type) {t_WT:WhyType t}, WhyType (pointer t).
Admitted.

(* Why3 goal *)
Definition block : forall (t:Type) {t_WT:WhyType t}, Type.

Admitted.

(* Why3 goal *)
Definition base_block: forall {t:Type} {t_WT:WhyType t}, (pointer t) ->
  (block t).

Admitted.

(* Why3 goal *)
Definition offset_max: forall {t:Type} {t_WT:WhyType t}, (alloc_table t)
  -> (pointer t) -> Z.

Admitted.

(* Why3 goal *)
Definition offset_min: forall {t:Type} {t_WT:WhyType t}, (alloc_table t)
  -> (pointer t) -> Z.

Admitted.

(* Why3 assumption *)
Definition valid {t:Type} {t_WT:WhyType t} (a:(alloc_table t)) (p:(pointer
  t)): Prop := ((offset_min a p) <= 0%Z)%Z /\ (0%Z <= (offset_max a p))%Z.

(* Why3 assumption *)
Definition same_block {t:Type} {t_WT:WhyType t} (p:(pointer t)) (q:(pointer
  t)): Prop := ((base_block p) = (base_block q)).

(* Why3 goal *)
Definition sub_pointer: forall {t:Type} {t_WT:WhyType t}, (pointer t)
  -> (pointer t) -> Z.

Admitted.

(* Why3 goal *)
Definition shift: forall {t:Type} {t_WT:WhyType t}, (pointer t) -> Z ->
  (pointer t).

Admitted.

(* Why3 goal *)
Definition null: forall {t:Type} {t_WT:WhyType t}, (pointer t).

Admitted.

(* Why3 goal *)
Definition pointer_address: forall {t:Type} {t_WT:WhyType t}, (pointer t) ->
  (pointer unit).

Admitted.

(* Why3 goal *)
Definition absolute_address: Z -> (pointer unit).

Admitted.

(* Why3 goal *)
Definition address: forall {t:Type} {t_WT:WhyType t}, (pointer t) -> Z.

Admitted.

(* Why3 goal *)
Lemma address_injective : forall {t:Type} {t_WT:WhyType t},
  forall (p:(pointer t)), forall (q:(pointer t)), (p = q) <->
  ((address p) = (address q)).
intuition.

Admitted.

(* Why3 goal *)
Lemma address_shift_lt : forall {t:Type} {t_WT:WhyType t}, forall (p:(pointer
  t)), forall (i:Z), forall (j:Z), ((address (shift p i)) < (address (shift p
  j)))%Z <-> (i < j)%Z.
intuition.

Admitted.

(* Why3 goal *)
Lemma address_shift_le : forall {t:Type} {t_WT:WhyType t}, forall (p:(pointer
  t)), forall (i:Z), forall (j:Z), ((address (shift p
  i)) <= (address (shift p j)))%Z <-> (i <= j)%Z.
intuition.

Admitted.

(* Why3 goal *)
Lemma shift_zero : forall {t:Type} {t_WT:WhyType t}, forall (p:(pointer t)),
  ((shift p 0%Z) = p).
intuition.

Admitted.

(* Why3 goal *)
Lemma shift_shift : forall {t:Type} {t_WT:WhyType t}, forall (p:(pointer t)),
  forall (i:Z), forall (j:Z), ((shift (shift p i) j) = (shift p (i + j)%Z)).
intuition.

Admitted.

(* Why3 goal *)
Lemma offset_max_shift : forall {t:Type} {t_WT:WhyType t},
  forall (a:(alloc_table t)), forall (p:(pointer t)), forall (i:Z),
  ((offset_max a (shift p i)) = ((offset_max a p) - i)%Z).
intuition.

Admitted.

(* Why3 goal *)
Lemma offset_min_shift : forall {t:Type} {t_WT:WhyType t},
  forall (a:(alloc_table t)), forall (p:(pointer t)), forall (i:Z),
  ((offset_min a (shift p i)) = ((offset_min a p) - i)%Z).
intuition.

Admitted.

(* Why3 goal *)
Lemma neq_shift : forall {t:Type} {t_WT:WhyType t}, forall (p:(pointer t)),
  forall (i:Z), forall (j:Z), (~ (i = j)) -> ~ ((shift p i) = (shift p j)).
intuition.

Admitted.

(* Why3 goal *)
Lemma null_not_valid : forall {t:Type} {t_WT:WhyType t},
  forall (a:(alloc_table t)), ~ (valid a (null :(pointer t))).
intuition.

Admitted.

(* Why3 goal *)
Lemma null_pointer : forall {t:Type} {t_WT:WhyType t}, forall (a:(alloc_table
  t)), (0%Z <= (offset_min a (null :(pointer t))))%Z /\ ((offset_max a
  (null :(pointer t))) <= (-2%Z)%Z)%Z.
intuition.

Admitted.





(* Why3 goal *)
Definition eq_pointer_bool: forall {t:Type} {t_WT:WhyType t}, (pointer t)
  -> (pointer t) -> bool.

Admitted.

(* Why3 goal *)
Definition neq_pointer_bool: forall {t:Type} {t_WT:WhyType t}, (pointer t)
  -> (pointer t) -> bool.

Admitted.

(* Why3 goal *)
Lemma eq_pointer_bool_def : forall {t:Type} {t_WT:WhyType t},
  forall (p1:(pointer t)), forall (p2:(pointer t)), ((eq_pointer_bool p1
  p2) = true) <-> (p1 = p2).
intuition.

Admitted.

(* Why3 goal *)
Lemma neq_pointer_bool_def : forall {t:Type} {t_WT:WhyType t},
  forall (p1:(pointer t)), forall (p2:(pointer t)), ((neq_pointer_bool p1
  p2) = true) <-> ~ (p1 = p2).
intuition.

Admitted.

(* Why3 goal *)
Lemma same_block_shift_right : forall {t:Type} {t_WT:WhyType t},
  forall (p:(pointer t)), forall (q:(pointer t)), forall (i:Z), (same_block p
  q) -> (same_block p (shift q i)).
intuition.

Admitted.

(* Why3 goal *)
Lemma same_block_shift_left : forall {t:Type} {t_WT:WhyType t},
  forall (p:(pointer t)), forall (q:(pointer t)), forall (i:Z), (same_block q
  p) -> (same_block (shift q i) p).
intuition.

Admitted.

(* Why3 goal *)
Lemma sub_pointer_shift : forall {t:Type} {t_WT:WhyType t},
  forall (p:(pointer t)) (q:(pointer t)), (same_block p q) -> (p = (shift q
  (sub_pointer p q))).
intuition.

Admitted.

(* Why3 goal *)
Lemma sub_pointer_self : forall {t:Type} {t_WT:WhyType t}, forall (p:(pointer
  t)), ((sub_pointer p p) = 0%Z).
intuition.

Admitted.

(* Why3 goal *)
Lemma sub_pointer_zero : forall {t:Type} {t_WT:WhyType t}, forall (p:(pointer
  t)) (q:(pointer t)), (same_block p q) -> (((sub_pointer p q) = 0%Z) ->
  (p = q)).
intuition.

Admitted.

(* Why3 goal *)
Lemma sub_pointer_shift_left : forall {t:Type} {t_WT:WhyType t},
  forall (p:(pointer t)) (q:(pointer t)) (i:Z), ((sub_pointer (shift p i)
  q) = ((sub_pointer p q) + i)%Z).
intuition.

Admitted.

(* Why3 goal *)
Lemma sub_pointer_shift_right : forall {t:Type} {t_WT:WhyType t},
  forall (p:(pointer t)) (q:(pointer t)) (i:Z), ((sub_pointer p (shift q
  i)) = ((sub_pointer p q) - i)%Z).
intuition.

Admitted.

(* Why3 goal *)
Lemma sub_pointer_neg : forall {t:Type} {t_WT:WhyType t}, forall (p:(pointer
  t)) (q:(pointer t)), ((sub_pointer p q) = (-(sub_pointer q p))%Z).
intros t t_WT p q.

Admitted.

(* Why3 goal *)
Definition memory : forall (t:Type) {t_WT:WhyType t}
  (v:Type) {v_WT:WhyType v}, Type.

Admitted.

(* Why3 goal *)
Definition select: forall {t:Type} {t_WT:WhyType t}
  {v:Type} {v_WT:WhyType v}, (memory t v) -> (pointer t) -> v.

Admitted.

(* Why3 goal *)
Definition store: forall {t:Type} {t_WT:WhyType t} {v:Type} {v_WT:WhyType v},
  (memory t v) -> (pointer t) -> v -> (memory t v).

Admitted.

(* Why3 goal *)
Lemma select_store_eq : forall {t:Type} {t_WT:WhyType t}
  {v:Type} {v_WT:WhyType v}, forall (m:(memory t v)), forall (p1:(pointer
  t)), forall (p2:(pointer t)), forall (a:v), (p1 = p2) -> ((select (store m
  p1 a) p2) = a).
intuition.

Admitted.

(* Why3 goal *)
Lemma select_store_neq : forall {t:Type} {t_WT:WhyType t}
  {v:Type} {v_WT:WhyType v}, forall (m:(memory t v)), forall (p1:(pointer
  t)), forall (p2:(pointer t)), forall (a:v), (~ (p1 = p2)) ->
  ((select (store m p1 a) p2) = (select m p2)).
intuition.

Admitted.

(* Why3 goal *)
Definition pset : forall (t:Type) {t_WT:WhyType t}, Type.

Admitted.

(* Why3 goal *)
Definition pset_empty: forall {t:Type} {t_WT:WhyType t}, (pset t).

Admitted.

(* Why3 goal *)
Definition pset_singleton: forall {t:Type} {t_WT:WhyType t}, (pointer t) ->
  (pset t).

Admitted.

(* Why3 goal *)
Definition pset_deref: forall {t:Type} {t_WT:WhyType t}
  {v:Type} {v_WT:WhyType v}, (memory t (pointer v)) -> (pset t) -> (pset v).

Admitted.

(* Why3 goal *)
Definition pset_union: forall {t:Type} {t_WT:WhyType t}, (pset t) -> (pset
  t) -> (pset t).

Admitted.

(* Why3 goal *)
Definition pset_all: forall {z:Type} {z_WT:WhyType z}, (pset z) -> (pset z).

Admitted.

(* Why3 goal *)
Definition pset_range: forall {t:Type} {t_WT:WhyType t}, (pset t) -> Z
  -> Z -> (pset t).

Admitted.

(* Why3 goal *)
Definition pset_range_left: forall {z:Type} {z_WT:WhyType z}, (pset z)
  -> Z -> (pset z).

Admitted.

(* Why3 goal *)
Definition pset_range_right: forall {z:Type} {z_WT:WhyType z}, (pset z)
  -> Z -> (pset z).

Admitted.

(* Why3 goal *)
Definition in_pset: forall {t:Type} {t_WT:WhyType t}, (pointer t) -> (pset
  t) -> Prop.

Admitted.

(* Why3 goal *)
Definition valid_pset: forall {t:Type} {t_WT:WhyType t}, (alloc_table t)
  -> (pset t) -> Prop.

Admitted.

(* Why3 assumption *)
Definition pset_disjoint {t:Type} {t_WT:WhyType t} (ps1:(pset t)) (ps2:(pset
  t)): Prop := forall (p:(pointer t)), ~ ((in_pset p ps1) /\ (in_pset p
  ps2)).

(* Why3 assumption *)
Definition pset_included {t:Type} {t_WT:WhyType t} (ps1:(pset t)) (ps2:(pset
  t)): Prop := forall (p:(pointer t)), (in_pset p ps1) -> (in_pset p ps2).

(* Why3 goal *)
Lemma pset_included_self : forall {t:Type} {t_WT:WhyType t}, forall (ps:(pset
  t)), (pset_included ps ps).
intuition.

Admitted.

(* Why3 goal *)
Lemma pset_included_range : forall {t:Type} {t_WT:WhyType t},
  forall (ps:(pset t)), forall (a:Z) (b:Z) (c:Z) (d:Z), ((c <= a)%Z /\
  (b <= d)%Z) -> (pset_included (pset_range ps a b) (pset_range ps c d)).
intuition.

Admitted.

(* Why3 goal *)
Lemma pset_included_range_all : forall {t:Type} {t_WT:WhyType t},
  forall (ps:(pset t)) (a:Z) (b:Z), (pset_included (pset_range ps a b)
  (pset_all ps)).
intuition.

Admitted.

(* Why3 goal *)
Lemma in_pset_empty : forall {t:Type} {t_WT:WhyType t}, forall (p:(pointer
  t)), ~ (in_pset p (pset_empty :(pset t))).
intuition.

Admitted.

(* Why3 goal *)
Lemma in_pset_singleton : forall {t:Type} {t_WT:WhyType t},
  forall (p:(pointer t)), forall (q:(pointer t)), (in_pset p
  (pset_singleton q)) <-> (p = q).
intuition.

Admitted.

(* Why3 goal *)
Lemma in_pset_deref : forall {t:Type} {t_WT:WhyType t}
  {v:Type} {v_WT:WhyType v}, forall (p:(pointer v)), forall (m:(memory t
  (pointer v))), forall (q:(pset t)), (in_pset p (pset_deref m q)) <->
  exists r:(pointer t), (in_pset r q) /\ (p = (select m r)).
intuition.

Admitted.

(* Why3 goal *)
Lemma in_pset_all : forall {t:Type} {t_WT:WhyType t}, forall (p:(pointer t)),
  forall (q:(pset t)), (in_pset p (pset_all q)) <-> exists i:Z,
  exists r:(pointer t), (in_pset r q) /\ (p = (shift r i)).
intuition.

Admitted.

(* Why3 goal *)
Lemma in_pset_range : forall {t:Type} {t_WT:WhyType t}, forall (p:(pointer
  t)), forall (q:(pset t)), forall (a:Z), forall (b:Z), (in_pset p
  (pset_range q a b)) <-> exists i:Z, exists r:(pointer t), (a <= i)%Z /\
  ((i <= b)%Z /\ ((in_pset r q) /\ (p = (shift r i)))).
intuition.

Admitted.

(* Why3 goal *)
Lemma in_pset_range_left : forall {t:Type} {t_WT:WhyType t},
  forall (p:(pointer t)), forall (q:(pset t)), forall (b:Z), (in_pset p
  (pset_range_left q b)) <-> exists i:Z, exists r:(pointer t), (i <= b)%Z /\
  ((in_pset r q) /\ (p = (shift r i))).
intuition.

Admitted.

(* Why3 goal *)
Lemma in_pset_range_right : forall {t:Type} {t_WT:WhyType t},
  forall (p:(pointer t)), forall (q:(pset t)), forall (a:Z), (in_pset p
  (pset_range_right q a)) <-> exists i:Z, exists r:(pointer t), (a <= i)%Z /\
  ((in_pset r q) /\ (p = (shift r i))).
intuition.

Admitted.

(* Why3 goal *)
Lemma in_pset_union : forall {t:Type} {t_WT:WhyType t}, forall (p:(pointer
  t)), forall (s1:(pset t)), forall (s2:(pset t)), (in_pset p (pset_union s1
  s2)) <-> ((in_pset p s1) \/ (in_pset p s2)).
intuition.

Admitted.

(* Why3 goal *)
Lemma valid_pset_empty : forall {t:Type} {t_WT:WhyType t},
  forall (a:(alloc_table t)), (valid_pset a (pset_empty :(pset t))).
intuition.

Admitted.

(* Why3 goal *)
Lemma valid_pset_singleton : forall {t:Type} {t_WT:WhyType t},
  forall (a:(alloc_table t)), forall (p:(pointer t)), (valid_pset a
  (pset_singleton p)) <-> (valid a p).
intuition.

Admitted.

(* Why3 goal *)
Lemma valid_pset_deref : forall {t:Type} {t_WT:WhyType t}
  {v:Type} {v_WT:WhyType v}, forall (a:(alloc_table v)), forall (m:(memory t
  (pointer v))), forall (q:(pset t)), (valid_pset a (pset_deref m q)) <->
  forall (r:(pointer t)), forall (p:(pointer v)), ((in_pset r q) /\
  (p = (select m r))) -> (valid a p).
intuition.

Admitted.

(* Why3 goal *)
Lemma valid_pset_range : forall {t:Type} {t_WT:WhyType t},
  forall (a:(alloc_table t)), forall (q:(pset t)), forall (c:Z),
  forall (d:Z), (valid_pset a (pset_range q c d)) <-> forall (i:Z),
  forall (r:(pointer t)), ((in_pset r q) /\ ((c <= i)%Z /\ (i <= d)%Z)) ->
  (valid a (shift r i)).
intuition.

Admitted.

(* Why3 goal *)
Lemma valid_pset_union : forall {t:Type} {t_WT:WhyType t},
  forall (a:(alloc_table t)), forall (s1:(pset t)), forall (s2:(pset t)),
  (valid_pset a (pset_union s1 s2)) <-> ((valid_pset a s1) /\ (valid_pset a
  s2)).
intuition.

Admitted.

(* Why3 assumption *)
Definition not_assigns {t:Type} {t_WT:WhyType t} {v:Type} {v_WT:WhyType v}
  (a:(alloc_table t)) (m1:(memory t v)) (m2:(memory t v)) (l:(pset
  t)): Prop := forall (p:(pointer t)), ((valid a p) /\ ~ (in_pset p l)) ->
  ((select m2 p) = (select m1 p)).

(* Why3 goal *)
Lemma not_assigns_refl : forall {t:Type} {t_WT:WhyType t}
  {v:Type} {v_WT:WhyType v}, forall (a:(alloc_table t)), forall (m:(memory t
  v)), forall (l:(pset t)), (not_assigns a m m l).
intuition.

Admitted.

(* Why3 goal *)
Lemma not_assigns_trans : forall {t:Type} {t_WT:WhyType t}
  {v:Type} {v_WT:WhyType v}, forall (a:(alloc_table t)), forall (m1:(memory t
  v)), forall (m2:(memory t v)), forall (m3:(memory t v)), forall (l:(pset
  t)), (not_assigns a m1 m2 l) -> ((not_assigns a m2 m3 l) -> (not_assigns a
  m1 m3 l)).
intuition.

Admitted.

(* Why3 goal *)
Definition full_separated: forall {t1:Type} {t1_WT:WhyType t1}
  {t2:Type} {t2_WT:WhyType t2}, (pointer t1) -> (pointer t2) -> Prop.

Admitted.

(* Why3 goal *)
Lemma full_separated_shift1 : forall {z:Type} {z_WT:WhyType z},
  forall (p:(pointer z)), forall (q:(pointer z)), forall (i:Z),
  (full_separated p q) -> (full_separated p (shift q i)).
intuition.

Admitted.

(* Why3 goal *)
Lemma full_separated_shift2 : forall {z:Type} {z_WT:WhyType z},
  forall (p:(pointer z)), forall (q:(pointer z)), forall (i:Z),
  (full_separated p q) -> (full_separated (shift q i) p).
intuition.

Admitted.

(* Why3 goal *)
Lemma full_separated_shift3 : forall {z:Type} {z_WT:WhyType z},
  forall (p:(pointer z)), forall (q:(pointer z)), forall (i:Z),
  (full_separated q p) -> (full_separated (shift q i) p).
intuition.

Admitted.

(* Why3 goal *)
Lemma full_separated_shift4 : forall {z:Type} {z_WT:WhyType z},
  forall (p:(pointer z)), forall (q:(pointer z)), forall (i:Z),
  (full_separated q p) -> (full_separated p (shift q i)).
intuition.

Admitted.

(* Why3 goal *)
Definition tag_table : forall (t:Type) {t_WT:WhyType t}, Type.

Admitted.

(* Why3 goal *)
Definition tag_id : forall (t:Type) {t_WT:WhyType t}, Type.

Admitted.

Global Instance tag_id_WhyType : forall (t:Type) {t_WT:WhyType t}, WhyType (tag_id t).
Admitted.

(* Why3 goal *)
Definition int_of_tag: forall {t:Type} {t_WT:WhyType t}, (tag_id t) -> Z.

Admitted.

(* Why3 goal *)
Definition typeof: forall {t:Type} {t_WT:WhyType t}, (tag_table t)
  -> (pointer t) -> (tag_id t).

Admitted.

(* Why3 goal *)
Definition parenttag: forall {t:Type} {t_WT:WhyType t}, (tag_id t) -> (tag_id
  t) -> Prop.

Admitted.

(* Why3 goal *)
Definition subtag: forall {t:Type} {t_WT:WhyType t}, (tag_id t) -> (tag_id
  t) -> Prop.

Admitted.

(* Why3 goal *)
Definition subtag_bool: forall {t:Type} {t_WT:WhyType t}, (tag_id t)
  -> (tag_id t) -> bool.

Admitted.

(* Why3 goal *)
Lemma subtag_bool_def : forall {t:Type} {t_WT:WhyType t}, forall (t1:(tag_id
  t)), forall (t2:(tag_id t)), ((subtag_bool t1 t2) = true) <-> (subtag t1
  t2).
intuition.

Admitted.

(* Why3 goal *)
Lemma subtag_refl : forall {t:Type} {t_WT:WhyType t}, forall (t1:(tag_id t)),
  (subtag t1 t1).
intuition.

Admitted.

(* Why3 goal *)
Lemma subtag_parent : forall {t:Type} {t_WT:WhyType t}, forall (t1:(tag_id
  t)), forall (t2:(tag_id t)), forall (t3:(tag_id t)), (subtag t1 t2) ->
  ((parenttag t2 t3) -> (subtag t1 t3)).
intuition.

Admitted.

(* Why3 assumption *)
Definition instanceof {t:Type} {t_WT:WhyType t} (a:(tag_table t)) (p:(pointer
  t)) (t1:(tag_id t)): Prop := (subtag (typeof a p) t1).

(* Why3 goal *)
Definition downcast: forall {t:Type} {t_WT:WhyType t}, (tag_table t)
  -> (pointer t) -> (tag_id t) -> (pointer t).

Admitted.

(* Why3 goal *)
Lemma downcast_instanceof : forall {t:Type} {t_WT:WhyType t},
  forall (a:(tag_table t)), forall (p:(pointer t)), forall (s:(tag_id t)),
  (instanceof a p s) -> ((downcast a p s) = p).
intuition.

Admitted.

(* Why3 goal *)
Definition bottom_tag: forall {a:Type} {a_WT:WhyType a}, (tag_id a).

Admitted.

(* Why3 goal *)
Lemma bottom_tag_axiom : forall {t:Type} {t_WT:WhyType t}, forall (t1:(tag_id
  t)), (subtag t1 (bottom_tag :(tag_id t))).
intuition.

Admitted.

(* Why3 goal *)
Lemma root_subtag : forall {t:Type} {t_WT:WhyType t}, forall (a:(tag_id t)),
  forall (b:(tag_id t)), forall (c:(tag_id t)), (parenttag a
  (bottom_tag :(tag_id t))) -> ((parenttag b (bottom_tag :(tag_id t))) ->
  ((~ (a = b)) -> ((subtag c a) -> ~ (subtag c b)))).
intuition.

Admitted.

(* Why3 assumption *)
Definition fully_packed {a:Type} {a_WT:WhyType a} (tag_table1:(tag_table a))
  (usmutable:(memory a (tag_id a))) (this:(pointer a)): Prop :=
  ((select usmutable this) = (typeof tag_table1 this)).

(* Why3 goal *)
Definition bw_compl: Z -> Z.

Admitted.

(* Why3 goal *)
Definition bw_and: Z -> Z -> Z.

Admitted.

(* Why3 goal *)
Lemma bw_and_not_null : forall (a:Z), forall (b:Z), (~ ((bw_and a
  b) = 0%Z)) -> ((~ (a = 0%Z)) /\ ~ (b = 0%Z)).
intuition.

Admitted.

(* Why3 goal *)
Definition bw_xor: Z -> Z -> Z.

Admitted.

(* Why3 goal *)
Definition bw_or: Z -> Z -> Z.

Admitted.

(* Why3 goal *)
Definition lsl: Z -> Z -> Z.

Admitted.

(* Why3 goal *)
Lemma lsl_left_positive_returns_positive : forall (a:Z), forall (b:Z),
  ((0%Z <= a)%Z /\ (0%Z <= b)%Z) -> (0%Z <= (lsl a b))%Z.
intuition.

Admitted.

(* Why3 goal *)
Lemma lsl_left_positive_monotone : forall (a1:Z), forall (a2:Z),
  forall (b:Z), ((0%Z <= a1)%Z /\ ((a1 <= a2)%Z /\ (0%Z <= b)%Z)) -> ((lsl a1
  b) <= (lsl a2 b))%Z.
intuition.

Admitted.

(* Why3 goal *)
Definition lsr: Z -> Z -> Z.

Admitted.

(* Why3 goal *)
Lemma lsr_left_positive_returns_positive : forall (a:Z), forall (b:Z),
  ((0%Z <= a)%Z /\ (0%Z <= b)%Z) -> (0%Z <= (lsr a b))%Z.
intuition.

Admitted.

(* Why3 goal *)
Lemma lsr_left_positive_decreases : forall (a:Z), forall (b:Z),
  ((0%Z <= a)%Z /\ (0%Z <= b)%Z) -> ((lsr a b) <= a)%Z.
intuition.

Admitted.

(* Why3 goal *)
Definition asr: Z -> Z -> Z.

Admitted.

(* Why3 goal *)
Lemma asr_positive_on_positive : forall (a:Z), forall (b:Z), ((0%Z <= a)%Z /\
  (0%Z <= b)%Z) -> (0%Z <= (asr a b))%Z.
intuition.

Admitted.

(* Why3 goal *)
Lemma asr_decreases_on_positive : forall (a:Z), forall (b:Z),
  ((0%Z <= a)%Z /\ (0%Z <= b)%Z) -> ((asr a b) <= a)%Z.
intuition.

Admitted.

(* Why3 goal *)
Lemma asr_lsr_same_on_positive : forall (a:Z), forall (b:Z), ((0%Z <= a)%Z /\
  (0%Z <= b)%Z) -> ((asr a b) = (lsr a b)).
intuition.

Admitted.

(* Why3 goal *)
Lemma lsl_of_lsr_decreases_on_positive : forall (a:Z), forall (b:Z),
  ((0%Z <= a)%Z /\ (0%Z <= b)%Z) -> ((lsl (lsr a b) b) <= a)%Z.
intuition.

Admitted.

(* Why3 goal *)
Lemma lsr_of_lsl_identity_on_positive : forall (a:Z), forall (b:Z),
  ((0%Z <= a)%Z /\ (0%Z <= b)%Z) -> ((lsr (lsl a b) b) = a).
intuition.

Admitted.

(* Why3 goal *)
Definition alloc_extends: forall {t:Type} {t_WT:WhyType t}, (alloc_table t)
  -> (alloc_table t) -> Prop.

Admitted.

(* Why3 assumption *)
Definition alloc_fresh {t:Type} {t_WT:WhyType t} (a:(alloc_table t))
  (p:(pointer t)) (n:Z): Prop := forall (i:Z), ((0%Z <= i)%Z /\ (i < n)%Z) ->
  ~ (valid a (shift p i)).

(* Why3 goal *)
Lemma alloc_extends_offset_min : forall {t:Type} {t_WT:WhyType t},
  forall (a1:(alloc_table t)), forall (a2:(alloc_table t)), (alloc_extends a1
  a2) -> forall (p:(pointer t)), (valid a1 p) -> ((offset_min a1
  p) = (offset_min a2 p)).
intuition.

Admitted.

(* Why3 goal *)
Lemma alloc_extends_offset_max : forall {t:Type} {t_WT:WhyType t},
  forall (a1:(alloc_table t)), forall (a2:(alloc_table t)), (alloc_extends a1
  a2) -> forall (p:(pointer t)), (valid a1 p) -> ((offset_max a1
  p) = (offset_max a2 p)).
intuition.

Admitted.

(* Why3 goal *)
Lemma alloc_extends_not_assigns_empty : forall {t:Type} {t_WT:WhyType t}
  {v:Type} {v_WT:WhyType v}, forall (a1:(alloc_table t)),
  forall (a2:(alloc_table t)), forall (m1:(memory t v)), forall (m2:(memory t
  v)), forall (l:(pset t)), forall (p:(pointer t)), forall (n:Z),
  ((alloc_extends a1 a2) /\ ((alloc_fresh a1 p n) /\ ((not_assigns a2 m1 m2
  l) /\ (pset_included l (pset_all (pset_singleton p)))))) -> (not_assigns a1
  m1 m2 (pset_empty :(pset t))).
intuition.

Admitted.

(* Why3 goal *)
Definition alloc_extends_except: forall {t:Type} {t_WT:WhyType t},
  (alloc_table t) -> (alloc_table t) -> (pset t) -> Prop.

Admitted.

(* Why3 goal *)
Lemma alloc_extends_except_offset_min : forall {t:Type} {t_WT:WhyType t},
  forall (a1:(alloc_table t)), forall (a2:(alloc_table t)), forall (l:(pset
  t)), (alloc_extends_except a1 a2 l) -> forall (p:(pointer t)), ((valid a1
  p) /\ ~ (in_pset p l)) -> ((offset_min a1 p) = (offset_min a2 p)).
intuition.

Admitted.

(* Why3 goal *)
Lemma alloc_extends_except_offset_max : forall {t:Type} {t_WT:WhyType t},
  forall (a1:(alloc_table t)), forall (a2:(alloc_table t)), forall (l:(pset
  t)), (alloc_extends_except a1 a2 l) -> forall (p:(pointer t)), ((valid a1
  p) /\ ~ (in_pset p l)) -> ((offset_max a1 p) = (offset_max a2 p)).
intuition.

Admitted.

(* Why3 goal *)
Definition mybag : forall (a:Type) {a_WT:WhyType a}, Type.

Admitted.

(* Why3 goal *)
Definition in_mybag: forall {a:Type} {a_WT:WhyType a}, a -> (mybag a) ->
  Prop.

Admitted.

(* Why3 goal *)
Definition disj_mybag: forall {a:Type} {a_WT:WhyType a}, (mybag a) -> (mybag
  a) -> Prop.

Admitted.

(* Why3 goal *)
Lemma disj_sym : forall {a:Type} {a_WT:WhyType a}, forall (s1:(mybag a))
  (s2:(mybag a)), (disj_mybag s1 s2) -> (disj_mybag s2 s1).
intuition.

Admitted.

(* Why3 goal *)
Definition sub_mybag: forall {a:Type} {a_WT:WhyType a}, (mybag a) -> (mybag
  a) -> Prop.

Admitted.

(* Why3 goal *)
Lemma sub_refl : forall {a:Type} {a_WT:WhyType a}, forall (sa:(mybag (pointer
  a))), (sub_mybag sa sa).
intuition.

Admitted.

(* Why3 goal *)
Lemma sub_disj : forall {a:Type} {a_WT:WhyType a}, forall (s1:(mybag a))
  (s2:(mybag a)) (s3:(mybag a)), (disj_mybag s1 s3) -> ((sub_mybag s2 s3) ->
  (disj_mybag s1 s2)).
intuition.

Admitted.

(* Why3 goal *)
Lemma sub_in : forall {a:Type} {a_WT:WhyType a}, forall (s1:(mybag a))
  (s2:(mybag a)), forall (p:a), (~ (in_mybag p s2)) -> ((sub_mybag s1 s2) ->
  ~ (in_mybag p s1)).
intuition.

Admitted.

(* Why3 goal *)
Lemma sub_sub : forall {a:Type} {a_WT:WhyType a}, forall (s1:(mybag a))
  (s2:(mybag a)) (s3:(mybag a)), (sub_mybag s1 s2) -> ((sub_mybag s2 s3) ->
  (sub_mybag s1 s3)).
intuition.

Admitted.

(* Why3 goal *)
Definition frame_between: forall {a:Type} {a_WT:WhyType a}
  {b:Type} {b_WT:WhyType b}, (mybag (pointer a)) -> (memory a b) -> (memory a
  b) -> Prop.

Admitted.

(* Why3 goal *)
Lemma frame_between_refl : forall {a:Type} {a_WT:WhyType a}
  {b:Type} {b_WT:WhyType b}, forall (sa:(mybag (pointer a))),
  forall (m:(memory a b)), (frame_between sa m m).
intuition.

Admitted.

(* Why3 goal *)
Lemma frame_between_gen : forall {a:Type} {a_WT:WhyType a}
  {b:Type} {b_WT:WhyType b}, forall (sa:(mybag (pointer a))),
  forall (m1:(memory a b)) (m2:(memory a b)), forall (p:(pointer a)),
  forall (v:b), (frame_between sa m1 m2) -> ((in_mybag p sa) ->
  (frame_between sa (store m1 p v) m2)).
intuition.

Admitted.

(* Why3 goal *)
Lemma frame_between_gen2 : forall {a:Type} {a_WT:WhyType a}
  {b:Type} {b_WT:WhyType b}, forall (sa:(mybag (pointer a))),
  forall (m1:(memory a b)) (m2:(memory a b)) (m3:(memory a b)),
  (frame_between sa m1 m2) -> ((frame_between sa m2 m3) -> (frame_between sa
  m1 m3)).
intuition.

Admitted.

(* Why3 goal *)
Lemma frame_between_gen_sub1 : forall {a:Type} {a_WT:WhyType a}
  {b:Type} {b_WT:WhyType b}, forall (s12:(mybag (pointer a))) (s23:(mybag
  (pointer a))) (s13:(mybag (pointer a))), forall (m1:(memory a b))
  (m2:(memory a b)) (m3:(memory a b)), (sub_mybag s12 s13) -> ((frame_between
  s12 m1 m2) -> ((frame_between s23 m2 m3) -> (frame_between s13 m1 m3))).
intuition.

Admitted.

(* Why3 goal *)
Lemma frame_between_gen_sub2 : forall {a:Type} {a_WT:WhyType a}
  {b:Type} {b_WT:WhyType b}, forall (s12:(mybag (pointer a))) (s23:(mybag
  (pointer a))) (s13:(mybag (pointer a))), forall (m1:(memory a b))
  (m2:(memory a b)) (m3:(memory a b)), (frame_between s12 m1 m2) ->
  ((sub_mybag s23 s13) -> ((frame_between s23 m2 m3) -> (frame_between s13 m1
  m3))).
intuition.

Admitted.

(* Why3 goal *)
Lemma frame_between_pointer : forall {a:Type} {a_WT:WhyType a}
  {b:Type} {b_WT:WhyType b}, forall (sa:(mybag (pointer a))),
  forall (m1:(memory a b)) (m2:(memory a b)), forall (p:(pointer a)),
  (frame_between sa m1 m2) -> ((~ (in_mybag p sa)) -> ((select m1
  p) = (select m2 p))).
intuition.

Admitted.

(* Why3 goal *)
Lemma frame_between_sub : forall {a:Type} {a_WT:WhyType a}
  {b:Type} {b_WT:WhyType b}, forall (sa:(mybag (pointer a))),
  forall (sb:(mybag (pointer a))), forall (m1:(memory a b)) (m2:(memory a
  b)), (frame_between sa m1 m2) -> ((sub_mybag sa sb) -> (frame_between sb m1
  m2)).
intuition.

Admitted.


