/*
 * Decompiled with CFR 0.152.
 */
package rene.zirkel.expression;

import rene.zirkel.construction.ConstructionException;
import rene.zirkel.expression.BasicExpression;
import rene.zirkel.expression.DifferenceExpression;
import rene.zirkel.expression.ExpressionText;
import rene.zirkel.expression.ProductExpression;

class SumExpression
extends BasicExpression {
    BasicExpression E1;
    BasicExpression E2;

    public SumExpression(BasicExpression basicExpression, BasicExpression basicExpression2) {
        this.E1 = basicExpression;
        this.E2 = basicExpression2;
    }

    public static BasicExpression scan(ExpressionText expressionText) throws ConstructionException {
        BasicExpression basicExpression = ProductExpression.scan(expressionText);
        if (expressionText.next() == '+') {
            expressionText.advance();
            return SumExpression.scan(expressionText, basicExpression);
        }
        if (expressionText.next() == '-') {
            expressionText.advance();
            return DifferenceExpression.scan(expressionText, basicExpression);
        }
        return basicExpression;
    }

    public static BasicExpression scan(ExpressionText expressionText, BasicExpression basicExpression) throws ConstructionException {
        BasicExpression basicExpression2 = ProductExpression.scan(expressionText);
        if (expressionText.next() == '+') {
            expressionText.advance();
            return SumExpression.scan(expressionText, new SumExpression(basicExpression, basicExpression2));
        }
        if (expressionText.next() == '-') {
            expressionText.advance();
            return DifferenceExpression.scan(expressionText, new SumExpression(basicExpression, basicExpression2));
        }
        return new SumExpression(basicExpression, basicExpression2);
    }

    public double getValue() throws ConstructionException {
        return this.E1.getValue() + this.E2.getValue();
    }

    public void translate() {
        this.E1.translate();
        this.E2.translate();
    }

    public String toString() {
        return this.E1 + "+" + this.E2;
    }

    public void reset() {
        this.E1.reset();
        this.E2.reset();
    }
}

