/* yForth? - A Forth interpreter written in ANSI C
 * Copyright (C) 2012 Luca Padovani
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * ------------------------------------------------------------------------
 * Module name:     double.h
 * Abstract:        include file for "double-numbers" word set
 */

#ifdef DECLARE_WORDS
#	ifdef PROTOTYPES
#		undef PROTOTYPES
#	endif
#	undef __DOUBLE_H__
#else
#	ifndef PROTOTYPES
#		define PROTOTYPES
#	endif
#endif

#ifndef __DOUBLE_H__
#define __DOUBLE_H__

#include "yforth.h"
#include "macro.h"

/**************************************************************************/
/* PROTOTYPES *************************************************************/
/**************************************************************************/

code(two_constant,						"2constant",			0)
code(two_literal,						"2literal",				COMP_ONLY | IMMEDIATE)
code(two_variable,						"2variable",			0)
code(d_plus,							"d+",					0)
code(d_minus,							"d-",					0)
code(d_dot,								"d.",					0)
code(d_dot_r,							"d.r",					0)
code(d_zero_less,						"d0<",					0)
code(d_zero_equals,						"d0=",					0)
code(d_two_star,						"d2*",					0)
code(d_two_slash,						"d2/",					0)
code(d_less_than,						"d<",					0)
code(d_equals,							"d=",					0)
code(drop,								"d>s",					0)
code(dabs,								"dabs",					0)
code(dmax,								"dmax",					0)
code(dmin,								"dmin",					0)
code(dnegate,							"dnegate",				0)
code(m_star_slash,						"m*/",					0)
code(m_plus,							"m+",					0)

#ifdef PROTOTYPES

#endif

#endif

